/*
 * Decompiled with CFR 0.152.
 */
package de.samply.share.common.control.uiquerybuilder;

import com.sun.jersey.api.client.Client;
import de.samply.auth.client.jwt.JwtException;
import de.samply.auth.rest.AccessTokenDto;
import de.samply.common.mdrclient.MdrClient;
import de.samply.common.mdrclient.MdrConnectionException;
import de.samply.common.mdrclient.MdrInvalidResponseException;
import de.samply.common.mdrclient.domain.DataElement;
import de.samply.common.mdrclient.domain.Designation;
import de.samply.common.mdrclient.domain.EnumElementType;
import de.samply.common.mdrclient.domain.EnumIdentificationStatus;
import de.samply.common.mdrclient.domain.Result;
import de.samply.common.mdrclient.domain.ResultList;
import de.samply.jsf.JsfUtils;
import de.samply.jsf.MdrUtils;
import de.samply.share.common.model.uiquerybuilder.MenuItem;
import de.samply.share.common.model.uiquerybuilder.MenuItemTreeManager;
import de.samply.share.common.utils.ProjectInfo;
import de.samply.share.common.utils.SamplyShareUtils;
import de.samply.share.common.utils.oauth2.OAuthUtils;
import de.samply.web.mdrfaces.MdrContext;
import java.io.IOException;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.component.html.HtmlPanelGroup;
import org.omnifaces.util.Ajax;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractItemSearchController
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractItemSearchController.class);
    protected String language;
    protected transient List<MenuItem> menuItems = new ArrayList<MenuItem>();
    protected transient MdrClient mdrClient = MdrContext.getMdrContext().getMdrClient();
    private transient List<String> keywords = new ArrayList<String>();
    private transient List<MenuItem> searchedMenuItems = new ArrayList<MenuItem>();
    private List<String> selectedKeywords = new ArrayList<String>();
    private String searchText;
    private transient HtmlPanelGroup searchPanel = new HtmlPanelGroup();
    private transient HtmlPanelGroup itemNavigationPanel = new HtmlPanelGroup();
    private transient HtmlPanelGroup itemFilterPanel = new HtmlPanelGroup();
    private transient HtmlCommandLink refreshButton = new HtmlCommandLink();
    private AccessTokenDto accessToken;
    private List<String> searchNamespaces = new ArrayList<String>();
    private List<Result> additionalSearchItems = new ArrayList<Result>();

    public AbstractItemSearchController() {
        this.language = "de";
    }

    public AbstractItemSearchController(String language) {
        this.language = language;
    }

    public final void onSearch() throws InvalidKeyException, NoSuchAlgorithmException, SignatureException, JwtException, IOException {
        logger.debug("Searching items...");
        String projectName = ProjectInfo.INSTANCE.getProjectName();
        if (projectName.equalsIgnoreCase("osse")) {
            this.language = "en";
        }
        this.searchedMenuItems = new ArrayList<MenuItem>();
        if (this.searchText != null && !this.searchText.isEmpty()) {
            List<Object> resultList;
            if (projectName.equalsIgnoreCase("osse")) {
                resultList = this.searchItemsLocal(this.searchText, this.language);
            } else {
                resultList = new ArrayList();
                for (String string : this.searchNamespaces) {
                    List<Result> resultsToAdd = this.searchItems(this.searchText, this.language, string);
                    for (Result result : resultsToAdd) {
                        if (result.getIdentification().getStatus() != EnumIdentificationStatus.RELEASED) continue;
                        resultList.add(result);
                    }
                }
                List<Result> fromAdditionalSearchItems = this.searchInAddtionalItems(this.searchText);
                for (Result result : fromAdditionalSearchItems) {
                    resultList.add(result);
                }
            }
            if (resultList == null || resultList.isEmpty()) {
                logger.debug("No results found for search query: " + this.searchText + " in language " + this.language + " in any namespaces");
            } else {
                for (Result result : resultList) {
                    if (result.getType().compareTo(EnumElementType.DATAELEMENT.name()) != 0 && result.getType().compareTo(EnumElementType.RECORD.name()) != 0) continue;
                    MenuItem menuItem = MenuItemTreeManager.buildMenuItem(result.getId(), EnumElementType.valueOf((String)result.getType()), MdrUtils.getDesignation((List)result.getDesignations()), MdrUtils.getDefinition((List)result.getDesignations()), new ArrayList<MenuItem>(), null);
                    this.searchedMenuItems.add(menuItem);
                }
            }
        }
        this.itemNavigationPanel.setStyleClass("hidden");
        this.refreshButton.setStyleClass(this.refreshButton.getStyleClass() + " disabled");
        this.itemFilterPanel.setStyleClass("visible");
        Ajax.update((String[])new String[]{this.searchPanel.getClientId(), this.refreshButton.getClientId()});
    }

    private List<Result> searchInAddtionalItems(String searchText) {
        ArrayList<Result> resultList = new ArrayList<Result>();
        for (Result item : this.additionalSearchItems) {
            for (Designation designation : item.getDesignations()) {
                if (!designation.getDefinition().toLowerCase().contains(searchText.toLowerCase()) && !designation.getDesignation().toLowerCase().contains(searchText.toLowerCase())) continue;
                resultList.add(item);
            }
        }
        return resultList;
    }

    protected List<Result> searchItemsLocal(String searchText, String language) {
        try {
            return this.mdrClient.searchLocal(searchText, language, null);
        }
        catch (MdrConnectionException | MdrInvalidResponseException | ExecutionException ex) {
            logger.error("Error while searching MDR", ex);
            return Collections.emptyList();
        }
    }

    protected List<Result> searchItems(String searchText, String language, String namespace) {
        try {
            if (namespace != null && namespace.length() > 0) {
                return this.mdrClient.searchInNamespace(searchText, language, this.getAccessToken(), namespace);
            }
            return this.mdrClient.search(searchText, language, this.getAccessToken());
        }
        catch (MdrConnectionException | MdrInvalidResponseException | ExecutionException ex) {
            logger.error("Error while searching MDR", ex);
            return Collections.emptyList();
        }
    }

    protected List<Result> searchItems(String searchText) {
        return this.searchItems(searchText, JsfUtils.getLocaleLanguage(), null);
    }

    public final void onClearSearch() {
        this.selectedKeywords = new ArrayList<String>();
        this.searchText = "";
        this.refreshButton.setStyleClass(this.refreshButton.getStyleClass().replace("disabled", ""));
        this.itemNavigationPanel.setStyleClass("visible");
        this.itemFilterPanel.setStyleClass("hidden");
        Ajax.update((String[])new String[]{this.searchPanel.getParent().getClientId(), this.refreshButton.getClientId()});
    }

    public final HtmlPanelGroup getItemNavigationPanel() {
        return this.itemNavigationPanel;
    }

    public final void setItemNavigationPanel(HtmlPanelGroup itemNavigationPanel) {
        this.itemNavigationPanel = itemNavigationPanel;
    }

    public final HtmlPanelGroup getItemFilterPanel() {
        return this.itemFilterPanel;
    }

    public final void setItemFilterPanel(HtmlPanelGroup itemFilterPanel) {
        this.itemFilterPanel = itemFilterPanel;
    }

    public final List<String> getSelectedKeywords() {
        return this.selectedKeywords;
    }

    public final void setSelectedKeywords(List<String> selectedKeywords) {
        this.selectedKeywords = selectedKeywords;
    }

    public final List<MenuItem> getSearchedMenuItems() {
        return this.searchedMenuItems;
    }

    public final void setSearchedMenuItems(List<MenuItem> searchedMenuItems) {
        this.searchedMenuItems = searchedMenuItems;
    }

    public final List<String> getKeywords() {
        logger.debug("Resolving list of item keywords to help on the item search...");
        HashSet<String> keysHashSet = new HashSet<String>();
        ArrayList items = new ArrayList();
        for (Result r : items) {
            String[] designationKeywords;
            for (String k : designationKeywords = ((Designation)r.getDesignations().get(0)).getDesignation().split(" ")) {
                keysHashSet.add(k);
            }
        }
        this.keywords = new ArrayList<String>(keysHashSet);
        return this.keywords;
    }

    public final void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    public final HtmlPanelGroup getSearchPanel() {
        return this.searchPanel;
    }

    public final void setSearchPanel(HtmlPanelGroup searchPanel) {
        this.searchPanel = searchPanel;
    }

    public final HtmlCommandLink getRefreshButton() {
        return this.refreshButton;
    }

    public final void setRefreshButton(HtmlCommandLink refreshButton) {
        this.refreshButton = refreshButton;
    }

    public final List<MenuItem> getMenuItems() {
        return this.menuItems;
    }

    public final void setMenuItems(List<MenuItem> menuItems) {
        this.menuItems = menuItems;
    }

    public final String getSearchText() {
        return this.searchText;
    }

    public final void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    protected List<String> getSearchNamespaces() {
        return this.searchNamespaces;
    }

    protected void setSearchNamespaces(List<String> namespaces) {
        this.searchNamespaces = namespaces;
    }

    protected void addToSearchNamespaces(String namespace) {
        if (this.searchNamespaces == null) {
            this.searchNamespaces = new ArrayList<String>();
        }
        this.searchNamespaces.add(namespace);
    }

    public List<Result> getAdditionalSearchItems() {
        return this.additionalSearchItems;
    }

    public void setAdditionalSearchItems(List<Result> additionalSearchItems) {
        this.additionalSearchItems = additionalSearchItems;
    }

    public abstract String getPrivateKey();

    public abstract String getMdrAuthKeyId();

    public abstract String getMdrAuthUrl();

    protected String getAccessToken() {
        if (this.accessToken != null) {
            return this.accessToken.getAccessToken();
        }
        try {
            this.accessToken = OAuthUtils.getAccessToken(Client.create(), this.getMdrAuthUrl(), this.getMdrAuthKeyId(), this.getPrivateKey());
            if (this.accessToken != null) {
                return this.accessToken.getAccessToken();
            }
            logger.error("Error obtaining OAuth access token");
            return null;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException ex) {
            throw new RuntimeException("Error obtaining OAuth access token", ex);
        }
    }

    protected ResultList getMdrRootElements() {
        try {
            return this.mdrClient.getUserRootElements(JsfUtils.getLocaleLanguage(), this.getAccessToken(), this.getMdrAuthKeyId());
        }
        catch (ExecutionException ex) {
            throw new RuntimeException("Error loading MDR root elements", ex);
        }
    }

    protected ResultList getMdrRootElements(String namespace) {
        if (namespace.equalsIgnoreCase("dktk")) {
            return this.getMdrRootElements();
        }
        try {
            ResultList resultList = new ResultList();
            List results = this.mdrClient.getNamespaceMembers("en", this.getAccessToken(), this.getMdrAuthKeyId(), namespace);
            resultList.setResults(results);
            return resultList;
        }
        catch (ExecutionException ex) {
            throw new RuntimeException("Error loading MDR root elements", ex);
        }
    }

    protected ResultList getMdrRootElements(String namespace, String accessToken, String authId) {
        if (namespace.equalsIgnoreCase("dktk")) {
            return this.getMdrRootElements();
        }
        try {
            ResultList resultList = new ResultList();
            List results = this.mdrClient.getNamespaceMembers("en", accessToken, authId, namespace);
            resultList.setResults(results);
            return resultList;
        }
        catch (ExecutionException ex) {
            throw new RuntimeException("Error loading MDR root elements", ex);
        }
    }

    protected ResultList getNamespaceMembersAnonymous(String namespace, String language) {
        if (language == null || language.length() < 2) {
            language = "en";
        }
        try {
            ResultList resultList = new ResultList();
            List results = this.mdrClient.getNamespaceMembers(language, namespace);
            resultList.setResults(results);
            return resultList;
        }
        catch (ExecutionException ex) {
            throw new RuntimeException("Error loading MDR root elements", ex);
        }
    }

    protected List<Result> getGroupMembers(String mdrId) {
        try {
            return this.mdrClient.getMembers(mdrId, JsfUtils.getLocaleLanguage(), this.getAccessToken(), this.getMdrAuthKeyId());
        }
        catch (MdrConnectionException | ExecutionException ex) {
            throw new RuntimeException("There was an error  while trying to load MDR item members of element with id " + mdrId + ".", ex);
        }
    }

    protected ResultList getMdrElements(List<String> keys) {
        if (SamplyShareUtils.isNullOrEmpty(keys)) {
            return new ResultList();
        }
        try {
            ResultList resultList = new ResultList();
            ArrayList<Result> results = new ArrayList<Result>();
            for (String key : keys) {
                DataElement dataElement = this.mdrClient.getDataElement(key, "de");
                results.add(SamplyShareUtils.dataElementToResult(dataElement));
            }
            resultList.setResults(results);
            return resultList;
        }
        catch (MdrConnectionException | MdrInvalidResponseException | ExecutionException ex) {
            throw new RuntimeException("Error loading MDR keys", ex);
        }
    }

    public abstract void resetMenuItems();

    public void onDataElementGroupClick(String mdrId) {
        logger.debug("Loading menu item children...");
        MenuItem parent = MenuItemTreeManager.getMenuItem(this.menuItems, mdrId);
        if (MenuItemTreeManager.isItemOpen(parent)) {
            MenuItemTreeManager.cleanMenuItemStyleClass(parent);
        } else {
            MenuItemTreeManager.cleanMenuItemsStyleClass(this.menuItems);
            MenuItemTreeManager.clearMenuItemChildren(parent);
            if (parent != null) {
                logger.debug("Menu " + parent.getDesignation() + ", " + parent.getMdrId() + " clicked.");
            }
            for (Result r : this.getGroupMembers(mdrId)) {
                MenuItem menuItem = MenuItemTreeManager.buildMenuItem(r.getId(), EnumElementType.valueOf((String)r.getType()), MdrUtils.getDesignation((List)r.getDesignations()), MdrUtils.getDefinition((List)r.getDesignations()), new ArrayList<MenuItem>(), parent);
                MenuItemTreeManager.addMenuItem(menuItem, parent);
            }
            MenuItemTreeManager.setItemAndParentsOpen(parent);
            Ajax.update((String[])new String[]{this.itemNavigationPanel.getClientId()});
        }
    }

    public void onMdrItemsRefresh() {
        logger.debug("Clear MDR cache...");
        this.mdrClient.cleanCache();
    }
}

