/*
 * Decompiled with CFR 0.152.
 */
package de.samply.reporter.utils;

import de.samply.reporter.report.workbook.WorkbookManager;
import de.samply.reporter.template.SheetTemplate;
import de.samply.reporter.utils.ExternalSheetUtils;
import de.samply.reporter.utils.ExternalSheetUtilsException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExternalSheetUtils {
    public static void addSheetFromSourceExcelFile(WorkbookManager workbookManager, SheetTemplate template) throws ExternalSheetUtilsException {
        try (InputStream inputStream = ExternalSheetUtils.fetchInputStream((SheetTemplate)template);){
            if (inputStream != null) {
                ExternalSheetUtils.addSheetFromSourceExcelFile((WorkbookManager)workbookManager, (SheetTemplate)template, (InputStream)inputStream);
            }
        }
        catch (IOException e) {
            throw new ExternalSheetUtilsException((Throwable)e);
        }
    }

    private static void addSheetFromSourceExcelFile(WorkbookManager workbookManager, SheetTemplate template, InputStream inputStream) throws ExternalSheetUtilsException {
        try (Workbook sourceWorkbook = WorkbookFactory.create((InputStream)inputStream);){
            Sheet sourceSheet;
            if (sourceWorkbook != null && (sourceSheet = sourceWorkbook.getSheetAt(0)) != null) {
                ExternalSheetUtils.copy((Sheet)sourceSheet, (Sheet)workbookManager.createSheet(template));
            }
        }
        catch (IOException e) {
            throw new ExternalSheetUtilsException((Throwable)e);
        }
    }

    private static InputStream fetchInputStream(SheetTemplate template) throws ExternalSheetUtilsException {
        try {
            return ExternalSheetUtils.fetchInputStreamWithoutExceptionHandling((SheetTemplate)template);
        }
        catch (IOException | URISyntaxException e) {
            throw new ExternalSheetUtilsException((Throwable)e);
        }
    }

    private static InputStream fetchInputStreamWithoutExceptionHandling(SheetTemplate template) throws IOException, URISyntaxException {
        InputStream result = null;
        if (template.getFileUrl() != null) {
            result = new URI(template.getFileUrl()).toURL().openStream();
        }
        if (template.getFilePath() != null) {
            result = Files.newInputStream(Path.of(template.getFilePath(), new String[0]), new OpenOption[0]);
        }
        return result;
    }

    private static void copy(Sheet sourceSheet, Sheet targetSheet) {
        int i;
        int maxColumnNum = 0;
        for (i = 0; i < sourceSheet.getLastRowNum() + 1; ++i) {
            Row sourceRow = sourceSheet.getRow(i);
            Row newRow = targetSheet.createRow(i);
            if (sourceRow == null) continue;
            ExternalSheetUtils.copyRow((Row)sourceRow, (Row)newRow);
            if (sourceRow.getLastCellNum() <= maxColumnNum) continue;
            maxColumnNum = sourceRow.getLastCellNum();
        }
        for (i = 0; i < maxColumnNum; ++i) {
            targetSheet.setColumnWidth(i, sourceSheet.getColumnWidth(i));
        }
    }

    private static void copyRow(Row sourceRow, Row targetRow) {
        targetRow.setHeight(sourceRow.getHeight());
        for (int j = 0; j < sourceRow.getLastCellNum(); ++j) {
            Cell sourceCell = sourceRow.getCell(j);
            Cell targetCell = targetRow.createCell(j);
            if (sourceCell == null) continue;
            targetCell.setCellStyle(sourceCell.getCellStyle());
            switch (1.$SwitchMap$org$apache$poi$ss$usermodel$CellType[sourceCell.getCellType().ordinal()]) {
                case 1: {
                    targetCell.setCellValue("");
                    break;
                }
                case 2: {
                    targetCell.setCellValue(sourceCell.getBooleanCellValue());
                    break;
                }
                case 3: {
                    targetCell.setCellValue((double)sourceCell.getErrorCellValue());
                    break;
                }
                case 4: {
                    targetCell.setCellFormula(sourceCell.getCellFormula());
                    break;
                }
                case 5: {
                    targetCell.setCellValue(sourceCell.getNumericCellValue());
                    break;
                }
                case 6: {
                    targetCell.setCellValue(sourceCell.getRichStringCellValue());
                }
            }
            ExternalSheetUtils.copyMergedRegions((Cell)sourceCell, (Row)sourceRow, (Row)targetRow);
            ExternalSheetUtils.copyCellStyles((Cell)sourceCell, (Cell)targetCell);
        }
    }

    private static void copyMergedRegions(Cell sourceCell, Row sourceRow, Row targetRow) {
        int numMergedRegions = sourceRow.getSheet().getNumMergedRegions();
        for (int i = 0; i < numMergedRegions; ++i) {
            CellRangeAddress mergedRegion = sourceRow.getSheet().getMergedRegion(i);
            if (!mergedRegion.isInRange(sourceRow.getRowNum(), sourceCell.getColumnIndex())) continue;
            CellRangeAddress newMergedRegion = ExternalSheetUtils.getAdjustedMergedRegion((CellRangeAddress)mergedRegion, (Row)targetRow);
            if (!ExternalSheetUtils.isMergedRegionValid((Sheet)targetRow.getSheet(), (CellRangeAddress)newMergedRegion)) continue;
            targetRow.getSheet().addMergedRegion(newMergedRegion);
        }
    }

    private static void copyCellStyles(Cell sourceCell, Cell targetCell) {
        CellStyle sourceCellStyle = sourceCell.getCellStyle();
        CellStyle newCellStyle = targetCell.getSheet().getWorkbook().createCellStyle();
        newCellStyle.cloneStyleFrom(sourceCellStyle);
        targetCell.setCellStyle(newCellStyle);
    }

    private static CellRangeAddress getAdjustedMergedRegion(CellRangeAddress mergedRegion, Row newRow) {
        int newRowNum = newRow.getRowNum();
        int lastRow = mergedRegion.getLastRow();
        int firstCol = mergedRegion.getFirstColumn();
        int lastCol = mergedRegion.getLastColumn();
        return new CellRangeAddress(newRowNum, newRowNum + (lastRow - mergedRegion.getFirstRow()), firstCol, lastCol);
    }

    private static boolean isMergedRegionValid(Sheet sheet, CellRangeAddress mergedRegion) {
        int numMergedRegions = sheet.getNumMergedRegions();
        for (int i = 0; i < numMergedRegions; ++i) {
            CellRangeAddress existingRegion = sheet.getMergedRegion(i);
            if (existingRegion.getFirstRow() != mergedRegion.getFirstRow() || existingRegion.getLastRow() != mergedRegion.getLastRow() || existingRegion.getFirstColumn() != mergedRegion.getFirstColumn() || existingRegion.getLastColumn() != mergedRegion.getLastColumn()) continue;
            return false;
        }
        return true;
    }
}

