/*
 * Decompiled with CFR 0.152.
 */
package de.samply.reporter.script;

import de.samply.reporter.context.CellContext;
import de.samply.reporter.context.CellStyleContext;
import de.samply.reporter.context.Context;
import de.samply.reporter.script.ScriptEngineException;
import de.samply.reporter.script.ScriptEngineImpl;
import de.samply.reporter.script.ScriptResult;
import de.samply.reporter.template.script.Script;
import de.samply.reporter.template.script.ScriptFramework;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IContext;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.StringTemplateResolver;

public class ThymeleafEngine
extends ScriptEngineImpl {
    private final TemplateEngine templateEngine = this.createTemplateEngine();

    public ScriptFramework getScriptFramework() {
        return ScriptFramework.THYMELEAF;
    }

    public ScriptResult generateRawResult(Script script, Context context) throws ScriptEngineException {
        ScriptResult result = super.generateRawResult(script, context);
        org.thymeleaf.context.Context thymeleafContext = new org.thymeleaf.context.Context();
        thymeleafContext.setVariable("context", (Object)context);
        this.generateResult(result, script, thymeleafContext);
        return result;
    }

    public CellContext generateCellContext(Script script, CellStyleContext cellStyleContext, Context context) {
        CellContext cellContext = new CellContext(cellStyleContext);
        org.thymeleaf.context.Context thymeleafContext = new org.thymeleaf.context.Context();
        thymeleafContext.setVariable("context", (Object)context);
        thymeleafContext.setVariable("cellContext", (Object)cellStyleContext);
        this.generateResult(script, thymeleafContext, (Writer)new StringWriter());
        return cellContext;
    }

    private void generateResult(ScriptResult result, Script script, org.thymeleaf.context.Context context) throws ScriptEngineException {
        try (FileWriter fileWriter = new FileWriter(result.rawResult().toFile());){
            this.generateResult(script, context, (Writer)fileWriter);
        }
        catch (IOException e) {
            throw new ScriptEngineException((Throwable)e);
        }
    }

    private void generateResult(Script script, org.thymeleaf.context.Context context, Writer writer) {
        this.templateEngine.process(script.getValue(), (IContext)context, writer);
    }

    private TemplateEngine createTemplateEngine() {
        TemplateEngine templateEngine = new TemplateEngine();
        StringTemplateResolver stringTemplateResolver = new StringTemplateResolver();
        stringTemplateResolver.setTemplateMode(TemplateMode.TEXT);
        templateEngine.setTemplateResolver((ITemplateResolver)stringTemplateResolver);
        return templateEngine;
    }
}

