/*
 * Decompiled with CFR 0.152.
 */
package de.samply.reporter.logger;

import com.google.common.collect.EvictingQueue;
import de.samply.reporter.logger.Logger;
import java.util.ArrayList;
import java.util.Collections;
import org.slf4j.LoggerFactory;

public class BufferedLoggerFactory {
    private static EvictingQueue<String> evictingQueue = EvictingQueue.create((int)1000);

    public static Logger getLogger(Class clazz) {
        org.slf4j.Logger logger = LoggerFactory.getLogger((Class)clazz);
        return new Logger(evictingQueue, logger);
    }

    public static String[] getLastLoggerLines(int numberOfLines, String lastLine) {
        ArrayList<String> result = new ArrayList<String>();
        if (numberOfLines > 0) {
            ArrayList lines = new ArrayList(evictingQueue);
            for (int i = lines.size() - 1; i >= 0 && i >= lines.size() - numberOfLines; --i) {
                String currentLine = (String)lines.get(i);
                if (lastLine != null && currentLine.equals(lastLine)) break;
                result.add(currentLine);
            }
        }
        Collections.reverse(result);
        return result.toArray(new String[0]);
    }

    public static void clearBuffer() {
        evictingQueue.clear();
    }
}

