/*
 * Decompiled with CFR 0.152.
 */
package de.samply.reporter.exporter;

import de.samply.reporter.exporter.ExporterClientException;
import de.samply.reporter.exporter.RequestResponseEntity;
import de.samply.reporter.logger.BufferedLoggerFactory;
import de.samply.reporter.logger.Logger;
import de.samply.reporter.template.Exporter;
import de.samply.reporter.template.ReportTemplate;
import de.samply.reporter.utils.FileUtils;
import io.netty.channel.ChannelOption;
import io.netty.channel.epoll.EpollChannelOption;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.util.retry.Retry;

@Component
public class ExporterClient {
    private static final Logger logger = BufferedLoggerFactory.getLogger(ExporterClient.class);
    private final WebClient webClient;
    private final String exporterApiKey;
    private final String exporterQuery;
    private final String exporterQueryFormat;
    private final String exporterTemplateId;
    private final String exporterOutputFormat;
    private final String tempFilesDirectory;
    private final int maxNumberOfAttemptsToGetExport;
    private final int timeInSecondsToWaitBetweenAttemptsToGetExport;
    private final int webClientBufferSizeInBytes;
    private final Boolean isExporterInSameServer;

    public ExporterClient(@Value(value="${EXPORTER_URL}") String exporterUrl, @Value(value="${EXPORTER_API_KEY}") String exporterApiKey, @Value(value="${EXPORTER_QUERY:Patient}") String exporterQuery, @Value(value="${EXPORTER_QUERY_FORMAT:FHIR_PATH}") String exporterQueryFormat, @Value(value="${EXPORTER_TEMPLATE_ID:ccp-qb}") String exporterTemplateId, @Value(value="${EXPORTER_OUTPUT_FORMAT:CSV}") String exporterOutputFormat, @Value(value="${TEMP_FILES_DIRECTORY:./temp-files}") String tempFilesDirectory, @Value(value="${MAX_NUMBER_OF_ATTEMPTS_TO_GET_EXPORT:4320}") Integer maxNumberOfAttemptsToGetExport, @Value(value="${TIME_IN_SECONDS_TO_WAIT_BETWEEN_ATTEMPTS_TO_GET_EXPORT:20}") Integer timeInSecondsToWaitBetweenAttemptsToGetExport, @Value(value="${WEBCLIENT_BUFFER_SIZE_IN_BYTES:#{36 * 1024 * 1024}}") Integer webClientBufferSizeInBytes, @Value(value="${WEBCLIENT_REQUEST_TIMEOUT_IN_SECONDS:180}") Integer webClientRequestTimeoutInSeconds, @Value(value="${WEBCLIENT_CONNECTION_TIMEOUT_IN_SECONDS:180}") Integer webClientConnectionTimeoutInSeconds, @Value(value="${WEBCLIENT_TCP_KEEP_IDLE_IN_SECONDS:300}") Integer webClientTcpKeepIdleInSeconds, @Value(value="${WEBCLIENT_TCP_KEEP_INTERVAL_IN_SECONDS:60}") Integer webClientTcpKeepIntervalInSeconds, @Value(value="${WEBCLIENT_TCP_KEEP_CONNECTION_NUMBER_OF_TRIES:10}") Integer webClientTcpKeepConnetionNumberOfTries, @Value(value="${IS_EXPORTER_IN_SAME_SERVER:true}") Boolean isExporterInSameServer) {
        this.isExporterInSameServer = isExporterInSameServer;
        this.webClient = WebClient.builder().clientConnector((ClientHttpConnector)new ReactorClientHttpConnector((HttpClient)((HttpClient)((HttpClient)((HttpClient)((HttpClient)HttpClient.create().responseTimeout(Duration.ofSeconds(webClientRequestTimeoutInSeconds.intValue())).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)(webClientConnectionTimeoutInSeconds * 1000))).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(EpollChannelOption.TCP_KEEPIDLE, (Object)webClientTcpKeepIdleInSeconds)).option(EpollChannelOption.TCP_KEEPINTVL, (Object)webClientTcpKeepIntervalInSeconds)).option(EpollChannelOption.TCP_KEEPCNT, (Object)webClientTcpKeepConnetionNumberOfTries))).baseUrl(exporterUrl).build();
        this.exporterApiKey = exporterApiKey;
        this.exporterQuery = exporterQuery;
        this.exporterQueryFormat = exporterQueryFormat;
        this.exporterTemplateId = exporterTemplateId;
        this.exporterOutputFormat = exporterOutputFormat;
        this.tempFilesDirectory = tempFilesDirectory;
        this.maxNumberOfAttemptsToGetExport = maxNumberOfAttemptsToGetExport;
        this.timeInSecondsToWaitBetweenAttemptsToGetExport = timeInSecondsToWaitBetweenAttemptsToGetExport;
        this.webClientBufferSizeInBytes = webClientBufferSizeInBytes;
    }

    public void fetchExportFiles(Consumer<String> exportFilePathConsumer, ReportTemplate template, Runnable finalizerIfError) throws ExporterClientException {
        RequestResponseEntity requestResponseEntity;
        if (template.getExporter() == null || template.getExporter().getExportUrl() == null) {
            logger.info("Sending request to exporter...");
            Exporter exporter = this.fetchExporter(template);
            WebClient.RequestBodySpec requestBodySpec = (WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(uriBuilder -> uriBuilder.path("/request").queryParam("query", new Object[]{exporter.getQuery()}).queryParam("query-format", new Object[]{exporter.getQueryFormat()}).queryParamIfPresent("template-id", Optional.ofNullable(exporter.getTemplateId())).queryParam("output-format", new Object[]{exporter.getOutputFormat()}).build(new Object[0]))).header("x-api-key", new String[]{this.exporterApiKey})).header("internal-request", new String[]{this.isExporterInSameServer.toString()});
            if (exporter.getTemplate() != null && exporter.getTemplate().trim().isEmpty()) {
                requestBodySpec.contentType(MediaType.APPLICATION_XML);
                requestBodySpec.bodyValue((Object)exporter.getTemplate());
            }
            requestResponseEntity = (RequestResponseEntity)requestBodySpec.retrieve().bodyToMono(RequestResponseEntity.class).block();
        } else {
            requestResponseEntity = new RequestResponseEntity(template.getExporter().getExportUrl());
        }
        this.fetchExportFiles(requestResponseEntity, exportFilePathConsumer, finalizerIfError);
    }

    private Exporter fetchExporter(ReportTemplate template) {
        Exporter exporter = new Exporter();
        exporter.setQuery(this.fetchExporterValue(template, Exporter::getQuery, this.exporterQuery));
        exporter.setQueryFormat(this.fetchExporterValue(template, Exporter::getQueryFormat, this.exporterQueryFormat));
        if (template != null && template.getExporter() != null && template.getExporter().getTemplate() != null) {
            exporter.setTemplate(this.fetchExporterValue(template, Exporter::getTemplate, null));
        } else {
            exporter.setTemplateId(this.fetchExporterValue(template, Exporter::getTemplateId, this.exporterTemplateId));
        }
        exporter.setOutputFormat(this.fetchExporterValue(template, Exporter::getOutputFormat, this.exporterOutputFormat));
        return exporter;
    }

    private String fetchExporterValue(ReportTemplate template, Function<Exporter, String> templateFunction, String defaultValue) {
        return template != null && templateFunction.apply(template.getExporter()) != null ? templateFunction.apply(template.getExporter()) : defaultValue;
    }

    private void fetchExportFiles(RequestResponseEntity requestResponseEntity, Consumer<String> exportFilePathConsumer, Runnable finalizerIfError) throws ExporterClientException {
        try {
            AtomicReference filePath = new AtomicReference();
            this.fetchExportFiles(requestResponseEntity.responseUrl(), filePath).doOnError(throwable -> {
                throw new RuntimeException((Throwable)throwable);
            }).subscribe(fileBytes -> {
                this.copyInputStreamToFilePath((InputStream)new ByteArrayInputStream((byte[])fileBytes), (String)filePath.get());
                exportFilePathConsumer.accept((String)filePath.get());
            }, throwable -> {
                logger.error(ExceptionUtils.getStackTrace((Throwable)throwable));
                finalizerIfError.run();
            });
        }
        catch (RuntimeException e) {
            throw new ExporterClientException((Throwable)e);
        }
    }

    private Mono<byte[]> fetchExportFiles(String exportFilesUrl, AtomicReference<String> filePath) {
        AtomicInteger counter = new AtomicInteger(1);
        return WebClient.builder().codecs(codecs -> codecs.defaultCodecs().maxInMemorySize(this.webClientBufferSizeInBytes)).baseUrl(exportFilesUrl).build().get().exchangeToMono(clientResponse -> {
            if (clientResponse.statusCode().is2xxSuccessful()) {
                if (HttpStatus.OK.equals((Object)clientResponse.statusCode())) {
                    logger.info("Export available. Downloading...");
                    filePath.set(this.fetchFilePath(this.fetchFilename(clientResponse)));
                    return clientResponse.bodyToMono(byte[].class);
                }
                return counter.get() >= this.maxNumberOfAttemptsToGetExport ? Mono.error((Throwable)new ExporterClientException("Export file not ready after max number of attempts")) : Mono.error((Throwable)new WebClientResponseException(clientResponse.statusCode(), null, clientResponse.headers().asHttpHeaders(), null, null, null));
            }
            return Mono.error((Throwable)new ExporterClientException("Error getting export files: " + String.valueOf(clientResponse.statusCode())));
        }).retryWhen((Retry)Retry.fixedDelay((long)this.maxNumberOfAttemptsToGetExport, (Duration)Duration.ofSeconds(this.timeInSecondsToWaitBetweenAttemptsToGetExport)).filter(throwable -> this.shouldRetry(throwable, counter)));
    }

    private boolean shouldRetry(Throwable throwable, AtomicInteger counter) {
        if (throwable instanceof WebClientResponseException) {
            WebClientResponseException responseException = (WebClientResponseException)throwable;
            logger.info("Fetching export... (Attempt: " + counter.getAndIncrement() + ")");
            HttpStatusCode statusCode = responseException.getStatusCode();
            return statusCode != HttpStatus.OK && this.isQueryStillRunning();
        }
        return false;
    }

    private boolean isQueryStillRunning() {
        return true;
    }

    private String fetchFilename(ClientResponse clientResponse) {
        List header = clientResponse.headers().header("Content-Disposition");
        return !header.isEmpty() ? this.fetchFilenameFromHeader((String)header.get(0)) : FileUtils.fetchRandomFilename((String)"zip");
    }

    private String fetchFilenameFromHeader(String headerField) {
        return headerField != null && headerField.contains("filename=") ? headerField.substring(headerField.indexOf("filename=") + "filename=".length()).replace("\"", "") : FileUtils.fetchRandomFilename((String)"zip");
    }

    private String fetchFilePath(String filename) {
        return Path.of(this.tempFilesDirectory, new String[0]).resolve(filename).toString();
    }

    private void copyInputStreamToFilePath(InputStream inputStream, String filePath) {
        try (ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
             FileOutputStream fileOutputStream = new FileOutputStream(filePath);){
            fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String[] fetchLogs(int numberOfLines, String lastLine) {
        return (String[])this.webClient.get().uri(uriBuilder -> {
            uriBuilder.path("/logs").queryParam("logs-size", new Object[]{numberOfLines});
            if (lastLine != null && !lastLine.isEmpty()) {
                uriBuilder.queryParam("logs-last-line", new Object[]{lastLine});
            }
            return uriBuilder.build(new Object[0]);
        }).header("x-api-key", new String[]{this.exporterApiKey}).retrieve().bodyToMono(String[].class).block();
    }
}

