/*
 * Decompiled with CFR 0.152.
 */
package de.samply.reporter.context;

import java.util.HashSet;
import java.util.Set;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Workbook;

public class CellStyleContext {
    private final Set<Cell> formattedCells = new HashSet();
    private final Workbook workbook;

    public CellStyleContext(Workbook workbook) {
        this.workbook = workbook;
    }

    public void addCellStyleToCell(Cell cell, CellStyle cellStyle) {
        if (this.formattedCells.contains(cell)) {
            CellStyle newCellStyle = this.createCellStyle();
            newCellStyle.cloneStyleFrom(cell.getCellStyle());
            newCellStyle.cloneStyleFrom(cellStyle);
            cell.setCellStyle(newCellStyle);
        } else {
            cell.setCellStyle(cellStyle);
            this.formattedCells.add(cell);
        }
    }

    public CellStyle createCellStyle() {
        return this.workbook.createCellStyle();
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }
}

