/*
 * Decompiled with CFR 0.152.
 */
package de.samply.reporter.utils.poi;

import de.samply.reporter.utils.poi.SortOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class SheetSorter {
    private final Map<Integer, SortInfo> columnOrderMap = new HashMap<Integer, SortInfo>();
    private static final DataFormatter dataFormatter = new DataFormatter();
    private static BiFunction<Row, Integer, String> defaultRowColumnExtractor = (row, column) -> dataFormatter.formatCellValue(row.getCell(column.intValue()));

    public void addSortKey(int column, SortOrder order) {
        this.columnOrderMap.put(column, new StringSortInfo(order));
    }

    public <C extends Comparable> void addSortKey(int column, SortOrder order, BiFunction<Row, Integer, C> rowColumnExtractor) {
        this.columnOrderMap.put(column, new SortInfo<C>(order, rowColumnExtractor));
    }

    public void sortSheet(Sheet sheet) {
        this.columnOrderMap.keySet().forEach(column -> this.sortSheet(sheet, (int)column, this.columnOrderMap.get(column)));
    }

    private void sortSheet(Sheet sheet, int column, SortInfo sortInfo) {
        ArrayList rows = new ArrayList();
        sheet.forEach(row -> {
            if (row.getRowNum() != 0) {
                rows.add(row);
            }
        });
        Comparator<Row> comparator = Comparator.comparing(row -> (Comparable)sortInfo.getRowColumnExtractor().apply((Row)row, column));
        Collections.sort(rows, sortInfo.getOrder() == SortOrder.ASCENDING ? comparator : comparator.reversed());
        AtomicInteger counter = new AtomicInteger(1);
        rows.forEach(row -> this.cloneRowInSheet(sheet, (Row)row, counter));
        rows.forEach(arg_0 -> ((Sheet)sheet).removeRow(arg_0));
    }

    private void cloneRowInSheet(Sheet sheet, Row row, AtomicInteger counter) {
        Row newRow = sheet.createRow(counter.getAndIncrement());
        row.forEach(cell -> {
            Cell newCell = newRow.createCell(cell.getColumnIndex());
            this.copyValue((Cell)cell, newCell);
            CellStyle cellStyle = cell.getCellStyle();
            newCell.setCellStyle(cellStyle);
        });
    }

    private void copyValue(Cell sourceCell, Cell targetCell) {
        switch (sourceCell.getCellType()) {
            case BLANK: {
                targetCell.setBlank();
                break;
            }
            case BOOLEAN: {
                targetCell.setCellValue(sourceCell.getBooleanCellValue());
                break;
            }
            case ERROR: {
                targetCell.setCellErrorValue(sourceCell.getErrorCellValue());
                break;
            }
            case FORMULA: {
                targetCell.setCellFormula(sourceCell.getCellFormula());
                break;
            }
            case NUMERIC: {
                targetCell.setCellValue(sourceCell.getNumericCellValue());
                break;
            }
            case STRING: {
                targetCell.setCellValue(sourceCell.getStringCellValue());
            }
        }
    }

    private static class StringSortInfo
    extends SortInfo<String> {
        private StringSortInfo(SortOrder order) {
            super(order, defaultRowColumnExtractor);
        }
    }

    private static class SortInfo<C extends Comparable> {
        private SortOrder order;
        private BiFunction<Row, Integer, C> rowColumnExtractor;

        public SortInfo(SortOrder order, BiFunction<Row, Integer, C> rowColumnExtractor) {
            this.order = order;
            this.rowColumnExtractor = rowColumnExtractor;
        }

        public SortOrder getOrder() {
            return this.order;
        }

        public BiFunction<Row, Integer, C> getRowColumnExtractor() {
            return this.rowColumnExtractor;
        }
    }
}

