/*
 * Decompiled with CFR 0.152.
 */
package de.samply.reporter.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.samply.reporter.utils.CloneUtilsException;

public class CloneUtils {
    private static ObjectMapper objectMapper = new ObjectMapper();

    public static <T> T clone(T object) throws CloneUtilsException {
        try {
            return CloneUtils.cloneWithoutExceptionHandling(object);
        }
        catch (JsonProcessingException e) {
            throw new CloneUtilsException(e);
        }
    }

    private static <T> T cloneWithoutExceptionHandling(T object) throws JsonProcessingException {
        String serializedObject = objectMapper.writeValueAsString(object);
        return (T)objectMapper.readValue(serializedObject, object.getClass());
    }
}

