/*
 * Decompiled with CFR 0.152.
 */
package de.samply.reporter.template;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import de.samply.reporter.app.ReporterConst;
import de.samply.reporter.template.ReportTemplate;
import de.samply.reporter.template.script.Script;
import de.samply.reporter.template.script.ScriptParser;
import de.samply.reporter.template.script.ScriptReference;
import de.samply.reporter.utils.VariablesReplacer;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ReportTemplateManager {
    private final VariablesReplacer variablesReplacer;
    private final String customTemplateId;
    private final Map<String, ReportTemplate> idQualityReportTemplateMap = new HashMap<String, ReportTemplate>();
    private final Map<String, Path> idQualityReportTemplatePathMap = new HashMap<String, Path>();
    private final Path reportTemplateDirectory;

    public ReportTemplateManager(VariablesReplacer variablesReplacer, @Value(value="${CUSTOM_TEMPLATE_ID:custom-{TIMESTAMP}}") String customTemplateId, @Value(value="${REPORT_TEMPLATE_DIRECTORY:./templates}") String reportTemplateDirectory) {
        this.variablesReplacer = variablesReplacer;
        this.customTemplateId = customTemplateId;
        this.reportTemplateDirectory = Path.of(reportTemplateDirectory, new String[0]);
        this.loadTemplates(this.reportTemplateDirectory);
    }

    private void loadTemplates(Path templateDirectory) {
        try {
            this.loadTemplatesWithoutExceptionHandling(templateDirectory);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadTemplatesWithoutExceptionHandling(Path templateDirectory) throws IOException {
        if (Files.exists(templateDirectory, new LinkOption[0])) {
            try (Stream<Path> pathStream = Files.list(templateDirectory);){
                pathStream.filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(this::loadTemplate);
            }
        }
    }

    private void loadTemplate(Path templatePath) {
        try {
            this.loadTemplateWithoutExceptionHandling(templatePath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadTemplateWithoutExceptionHandling(Path templatePath) throws IOException {
        ReportTemplate reportTemplate = this.fetchTemplate(templatePath);
        this.idQualityReportTemplateMap.put(reportTemplate.getId(), reportTemplate);
        this.idQualityReportTemplatePathMap.put(reportTemplate.getId(), templatePath);
    }

    public ReportTemplate fetchTemplate(Path templatePath) throws IOException {
        return this.fetchTemplate(Files.readString(templatePath));
    }

    public ReportTemplate fetchTemplate(String template) throws IOException {
        return this.fetchScriptFilesAndAddToTemplate((ReportTemplate)new XmlMapper().readValue(ScriptParser.readTemplateAndParseScripts(template), ReportTemplate.class));
    }

    private ReportTemplate fetchScriptFilesAndAddToTemplate(ReportTemplate template) throws IOException {
        try {
            this.fetchScriptReferences(template).forEach(scriptReference -> {
                try {
                    this.fetchScriptFileAndAddToScriptReference((ScriptReference)scriptReference);
                    this.filterIgnoredLinesInScript((ScriptReference)scriptReference);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            return template;
        }
        catch (RuntimeException e) {
            throw new IOException(e);
        }
    }

    private List<ScriptReference> fetchScriptReferences(ReportTemplate template) {
        ScriptReferenceList result = new ScriptReferenceList();
        result.add(template.getInitScript());
        template.getSheetTemplates().forEach(sheetTemplate -> {
            sheetTemplate.getFormatScripts().forEach(result::add);
            result.add(sheetTemplate.getValuesScript());
        });
        return result.toList();
    }

    private void fetchScriptFileAndAddToScriptReference(ScriptReference scriptReference) throws IOException {
        Script script = scriptReference.getScript();
        Optional<Path> path = this.fetchPath(script);
        if (path.isPresent()) {
            script.setValue(this.fetchScript(path.get()));
        }
    }

    private Optional<Path> fetchPath(Script script) {
        if (script != null && script.getFilePath() != null) {
            Path path = Path.of(script.getFilePath(), new String[0]);
            return Optional.of(path.isAbsolute() ? path : this.reportTemplateDirectory.resolve(path));
        }
        return Optional.empty();
    }

    private String fetchScript(Path scriptPath) throws IOException {
        return new String(Files.readAllBytes(scriptPath), StandardCharsets.UTF_8);
    }

    private void filterIgnoredLinesInScript(ScriptReference scriptReference) {
        if (scriptReference != null && scriptReference.getScript() != null && scriptReference.getScript().getValue() != null) {
            Script script = scriptReference.getScript();
            script.setValue(this.filterIgnoredLinesInScript(script.getValue()));
        }
    }

    private String filterIgnoredLinesInScript(String script) {
        StringBuilder result = new StringBuilder();
        Arrays.stream(script.split("\n")).filter(this::isNotIgnoredLine).map(line -> line.concat("\n")).forEach(result::append);
        return result.toString();
    }

    private boolean isNotIgnoredLine(String line) {
        return !Arrays.stream(ReporterConst.IGNORE_LINE_IN_SCRIPT_TOKENS).anyMatch(stringArray -> Arrays.stream(stringArray).allMatch(line::contains));
    }

    public ReportTemplate fetchTemplateAndGenerateCustomTemplateId(String template) throws IOException {
        ReportTemplate result = this.fetchTemplate(template);
        result.setId(this.generateCustomTemplateId());
        return result;
    }

    private String generateCustomTemplateId() {
        return this.variablesReplacer.replaceTimestamp(this.customTemplateId);
    }

    public ReportTemplate getQualityReportTemplate(String qualityReportTemplateId) {
        return this.idQualityReportTemplateMap.get(qualityReportTemplateId);
    }

    public String[] getReportTemplateIds() {
        return this.idQualityReportTemplateMap.keySet().toArray(new String[0]);
    }

    public Optional<Path> getReportTemplatePath(String reportTemplateId) {
        return Optional.ofNullable(this.idQualityReportTemplatePathMap.get(reportTemplateId));
    }

    private static class ScriptReferenceList {
        private final List<ScriptReference> scriptReferenceList = new ArrayList<ScriptReference>();

        private ScriptReferenceList() {
        }

        public void add(ScriptReference scriptReference) {
            if (scriptReference != null) {
                this.scriptReferenceList.add(scriptReference);
            }
        }

        public List<ScriptReference> toList() {
            return this.scriptReferenceList;
        }
    }
}

