/*
 * Decompiled with CFR 0.152.
 */
package de.samply.reporter.script;

import de.samply.reporter.context.CellContext;
import de.samply.reporter.context.CellStyleContext;
import de.samply.reporter.context.Context;
import de.samply.reporter.script.ScriptEngineException;
import de.samply.reporter.script.ScriptEngineImpl;
import de.samply.reporter.script.ScriptResult;
import de.samply.reporter.template.script.Script;
import de.samply.reporter.template.script.ScriptFramework;
import groovy.lang.Binding;
import groovy.text.GStringTemplateEngine;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class GroovyTemplatesEngine
extends ScriptEngineImpl {
    private final GStringTemplateEngine engine = new GStringTemplateEngine();

    @Override
    public ScriptFramework getScriptFramework() {
        return ScriptFramework.GROOVY_TEMPLATES;
    }

    @Override
    public ScriptResult generateRawResult(Script script, Context context) throws ScriptEngineException {
        ScriptResult result = super.generateRawResult(script, context);
        Binding binding = new Binding();
        binding.setVariable("context", (Object)context);
        this.generateResult(result, script, binding);
        this.removeUnnecessaryEmptyLines(result, context.getCsvConfig());
        return result;
    }

    private void generateResult(ScriptResult result, Script script, Binding binding) throws ScriptEngineException {
        try (FileWriter fileWriter = new FileWriter(result.rawResult().toFile());){
            this.generateResult(script, binding, fileWriter);
        }
        catch (IOException e) {
            throw new ScriptEngineException(e);
        }
    }

    private void generateResult(Script script, Binding binding, Writer writer) throws ScriptEngineException {
        try {
            this.engine.createTemplate(script.getValue()).make(binding.getVariables()).writeTo(writer);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new ScriptEngineException(e);
        }
    }

    @Override
    public CellContext generateCellContext(Script script, CellStyleContext cellStyleContext, Context context) throws ScriptEngineException {
        CellContext result = new CellContext(cellStyleContext);
        Binding binding = new Binding();
        binding.setVariable("context", (Object)context);
        binding.setVariable("cellContext", (Object)result);
        this.generateResult(script, binding, new StringWriter());
        return result;
    }
}

