/*
 * Decompiled with CFR 0.152.
 */
package de.samply.reporter.script;

import de.samply.reporter.context.ContextException;
import de.samply.reporter.context.CsvConfig;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Iterator;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class CsvRecordIterator
implements Iterator<CSVRecord> {
    private final FileReader fileReader;
    private final BufferedReader bufferedReader;
    private final CSVParser csvParser;
    private final Iterator<CSVRecord> iterator;

    public CsvRecordIterator(Path sourcePath, CsvConfig csvConfig) throws ContextException {
        try {
            this.fileReader = new FileReader(sourcePath.toFile());
            this.bufferedReader = new BufferedReader(this.fileReader);
            this.csvParser = this.createCsvParser(this.bufferedReader, csvConfig);
            this.iterator = this.csvParser.iterator();
        }
        catch (IOException e) {
            throw new ContextException(e);
        }
    }

    private CSVParser createCsvParser(BufferedReader bufferedReader, CsvConfig csvConfig) throws IOException {
        return CSVFormat.Builder.create().setHeader(new String[0]).setSkipHeaderRecord(true).setDelimiter(csvConfig.delimiter()).setRecordSeparator(csvConfig.endOfLine()).build().parse((Reader)bufferedReader);
    }

    @Override
    public boolean hasNext() {
        boolean result = this.iterator.hasNext();
        if (!result) {
            try {
                this.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public void close() throws IOException {
        if (this.csvParser != null && !this.csvParser.isClosed()) {
            this.csvParser.close();
        }
        if (this.bufferedReader != null) {
            this.bufferedReader.close();
        }
        if (this.fileReader != null) {
            this.fileReader.close();
        }
    }

    @Override
    public CSVRecord next() {
        return this.iterator.next();
    }
}

