/*
 * Decompiled with CFR 0.152.
 */
package de.samply.reporter.context;

import de.samply.reporter.app.ReporterConst;
import de.samply.reporter.context.Context;
import de.samply.reporter.context.CsvConfig;
import de.samply.reporter.template.ReportTemplate;
import java.nio.charset.Charset;
import java.nio.file.Path;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ContextGenerator {
    private final Path directory;
    private final CsvConfig defaultCsvConfig;

    public ContextGenerator(@Value(value="${TEMP_FILES_DIRECTORY:./temp-files}") String directory, @Value(value="${FILE_CHARSET:#{null}}") String charsetName, @Value(value="${FILE_END_OF_LINE:#{null}}") String endOfLine, @Value(value="\t") String delimiter) {
        this.directory = Path.of(directory, new String[0]);
        Charset charset = charsetName != null ? Charset.forName(charsetName) : ReporterConst.DEFAULT_CHARSET;
        endOfLine = endOfLine != null ? endOfLine : ReporterConst.DEFAULT_END_OF_LINE;
        delimiter = delimiter != null ? delimiter : ReporterConst.DEFAULT_END_OF_LINE;
        this.defaultCsvConfig = new CsvConfig(charset, endOfLine, delimiter);
    }

    public Context generate(ReportTemplate template, Path[] paths) {
        return new Context(this.directory, template, paths, this.defaultCsvConfig);
    }
}

