/*
 * Decompiled with CFR 0.152.
 */
package de.samply.reporter.app;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.samply.reporter.app.GenerateResponseEntity;
import de.samply.reporter.app.ReportStatus;
import de.samply.reporter.exporter.ExporterClient;
import de.samply.reporter.logger.BufferedLoggerFactory;
import de.samply.reporter.logger.Logger;
import de.samply.reporter.logger.Logs;
import de.samply.reporter.report.ReportGenerator;
import de.samply.reporter.report.ReportGeneratorException;
import de.samply.reporter.report.metainfo.ReportMetaInfo;
import de.samply.reporter.report.metainfo.ReportMetaInfoManager;
import de.samply.reporter.report.metainfo.ReportMetaInfoManagerException;
import de.samply.reporter.template.Exporter;
import de.samply.reporter.template.ReportTemplate;
import de.samply.reporter.template.ReportTemplateManager;
import de.samply.reporter.utils.ProjectVersion;
import jakarta.servlet.http.HttpServletRequest;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Optional;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RestController
public class ReporterController {
    private final Logger logger = BufferedLoggerFactory.getLogger(ReporterController.class);
    private final String projectVersion = ProjectVersion.getProjectVersion();
    private final ReportGenerator reportGenerator;
    private final ReportMetaInfoManager reportMetaInfoManager;
    private final ReportTemplateManager reportTemplateManager;
    private final ExporterClient exporterClient;
    private final String httpRelativePath;
    private final String httpServletRequestScheme;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public ReporterController(@Value(value="${HTTP_RELATIVE_PATH:}") String httpRelativePath, @Value(value="${HTTP_SERVLET_REQUEST_SCHEME:http}") String httpServletRequestScheme, ReportGenerator reportGenerator, ReportTemplateManager reportTemplateManager, ReportMetaInfoManager reportMetaInfoManager, ExporterClient exporterClient) {
        this.httpRelativePath = httpRelativePath;
        this.httpServletRequestScheme = httpServletRequestScheme;
        this.reportGenerator = reportGenerator;
        this.reportTemplateManager = reportTemplateManager;
        this.reportMetaInfoManager = reportMetaInfoManager;
        this.exporterClient = exporterClient;
    }

    @GetMapping(value={"/info"})
    public ResponseEntity<String> info() {
        return new ResponseEntity((Object)this.projectVersion, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"/generate"})
    public ResponseEntity<String> generate(HttpServletRequest httpServletRequest, @RequestParam(name="template-id", required=false) String templateId, @RequestParam(name="export-url", required=false) String exportUrl, @RequestHeader(name="Content-Type", required=false) String contentType, @RequestHeader(name="internal-request", required=false) Boolean isInternalRequest, @RequestBody(required=false) String template) throws ReportGeneratorException, ReportMetaInfoManagerException, JsonProcessingException {
        ReportTemplate reportTemplate;
        if (template != null) {
            if (contentType != null && !contentType.equalsIgnoreCase("application/xml")) {
                return new ResponseEntity((Object)"Content Type not supported. Please set content type as application/xml", (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            try {
                reportTemplate = this.reportTemplateManager.fetchTemplateAndGenerateCustomTemplateId(template);
            }
            catch (IOException e) {
                return new ResponseEntity((Object)ExceptionUtils.getStackTrace((Throwable)e), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        if (templateId == null) {
            return new ResponseEntity((Object)"No template nor template id provided", (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        reportTemplate = this.reportTemplateManager.getQualityReportTemplate(templateId);
        if (exportUrl != null) {
            try {
                reportTemplate = reportTemplate.clone();
            }
            catch (CloneNotSupportedException e) {
                return new ResponseEntity((Object)ExceptionUtils.getStackTrace((Throwable)e), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
            Exporter exporter = reportTemplate.getExporter();
            if (exporter == null) {
                exporter = new Exporter();
                reportTemplate.setExporter(exporter);
            }
            exporter.setExportUrl(exportUrl);
        }
        ReportMetaInfo reportMetaInfo = this.reportMetaInfoManager.createNewReportMetaInfo(reportTemplate);
        this.reportGenerator.generate(reportTemplate, reportMetaInfo);
        return new ResponseEntity((Object)this.createRequestResponseEntity(httpServletRequest, reportMetaInfo.id(), isInternalRequest), (HttpStatusCode)HttpStatus.OK);
    }

    private String createRequestResponseEntity(HttpServletRequest request, String reportId, Boolean isInternalRequest) throws JsonProcessingException {
        return this.objectMapper.writeValueAsString((Object)new GenerateResponseEntity(this.fetchResponseUrl(request, reportId, isInternalRequest)));
    }

    private String fetchResponseUrl(HttpServletRequest httpServletRequest, String reportId, Boolean isInternalRequest) {
        ServletUriComponentsBuilder servletUriComponentsBuilder = ServletUriComponentsBuilder.fromRequestUri((HttpServletRequest)httpServletRequest);
        if (isInternalRequest != null && isInternalRequest.booleanValue()) {
            servletUriComponentsBuilder.scheme("http").replacePath("/report");
        } else {
            servletUriComponentsBuilder.scheme(this.httpServletRequestScheme).replacePath(this.createHttpPath("/report"));
        }
        String result = servletUriComponentsBuilder.queryParam("report-id", new Object[]{reportId}).toUriString();
        this.logger.info("Response URL: " + result);
        return result;
    }

    private String createHttpPath(String httpPath) {
        return this.httpRelativePath != null && this.httpRelativePath.length() > 0 ? this.httpRelativePath + "/" + httpPath : httpPath;
    }

    @GetMapping(value={"/report"}, produces={"application/octet-stream"})
    public ResponseEntity<InputStreamResource> fetchReport(@RequestParam(name="report-id") String reportId) throws ReportMetaInfoManagerException, FileNotFoundException {
        Optional<ReportMetaInfo> reportMetaInfo = this.reportMetaInfoManager.fetchReportMetaInfo(reportId);
        if (reportMetaInfo.isEmpty()) {
            return ResponseEntity.notFound().build();
        }
        if (!reportMetaInfo.get().path().toFile().exists()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.ACCEPTED);
        }
        return this.createResponseEntity(reportMetaInfo.get().path());
    }

    private ResponseEntity<InputStreamResource> createResponseEntity(Path path) throws FileNotFoundException {
        return this.createResponseEntity(new InputStreamResource((InputStream)new FileInputStream(path.toFile())), path.getFileName().toString());
    }

    private ResponseEntity<InputStreamResource> createResponseEntity(InputStreamResource inputStreamResource, String filename) {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=" + filename})).body((Object)inputStreamResource);
    }

    @GetMapping(value={"/reports-list"})
    public ResponseEntity fetchAllReports(@RequestParam(name="page", required=false) Integer page, @RequestParam(name="page-size", required=false) Integer pageSize) throws ReportMetaInfoManagerException {
        return ResponseEntity.ok().body((Object)(page != null && pageSize != null ? this.reportMetaInfoManager.fetchAllExistingReportMetaInfos(pageSize, page) : this.reportMetaInfoManager.fetchAllExistingReportMetaInfos()));
    }

    @GetMapping(value={"/report-status"})
    public ResponseEntity<ReportStatus> fetchReportStatus(@RequestParam(name="report-id") String reportId) throws ReportMetaInfoManagerException {
        Optional<ReportMetaInfo> reportMetaInfo = this.reportMetaInfoManager.fetchReportMetaInfo(reportId);
        if (reportMetaInfo.isEmpty()) {
            return ResponseEntity.ok((Object)((Object)ReportStatus.NOT_FOUND));
        }
        if (this.reportGenerator.isReportRunning(reportMetaInfo.get())) {
            return ResponseEntity.ok((Object)((Object)ReportStatus.RUNNING));
        }
        if (!reportMetaInfo.get().path().toFile().exists()) {
            return ResponseEntity.ok((Object)((Object)ReportStatus.ERROR));
        }
        return ResponseEntity.ok((Object)((Object)ReportStatus.OK));
    }

    @GetMapping(value={"/logs"})
    public ResponseEntity<Logs[]> fetchLogs(@RequestParam(name="logs-size") int logsSize, @RequestParam(name="logs-last-line-reporter", required=false) String logsLastLine, @RequestParam(name="logs-last-line-exporter", required=false) String exporterLogsLastLine) {
        Logs reporterLogs = new Logs("reporter", BufferedLoggerFactory.getLastLoggerLines(logsSize, logsLastLine));
        Logs exporterLogs = new Logs("exporter", this.exporterClient.fetchLogs(logsSize, exporterLogsLastLine));
        Logs[] logs = new Logs[]{reporterLogs, exporterLogs};
        return ResponseEntity.ok().body((Object)logs);
    }

    @GetMapping(value={"/report-template-ids"})
    public ResponseEntity<String[]> fetchTemplateIds() {
        return ResponseEntity.ok().body((Object)this.reportTemplateManager.getReportTemplateIds());
    }

    @GetMapping(value={"/report-template"}, produces={"application/octet-stream"})
    public ResponseEntity<InputStreamResource> fetchReporTemplate(@RequestParam(name="template-id") String reportTemplateId) throws FileNotFoundException {
        Optional<Path> reportTemplatePath = this.reportTemplateManager.getReportTemplatePath(reportTemplateId);
        if (reportTemplatePath.isEmpty()) {
            return ResponseEntity.notFound().build();
        }
        return this.createResponseEntity(reportTemplatePath.get());
    }

    @GetMapping(value={"/running-reports"})
    public ResponseEntity fetchRunningReports() throws ReportMetaInfoManagerException {
        return ResponseEntity.ok().body((Object)this.reportMetaInfoManager.fetchRunningReportMetaInfos());
    }
}

