/*
 * Decompiled with CFR 0.152.
 */
package de.samply.reporter.zip;

import de.samply.reporter.logger.BufferedLoggerFactory;
import de.samply.reporter.logger.Logger;
import de.samply.reporter.zip.ZipperException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.core.io.InputStreamResource;

/*
 * Exception performing whole class analysis ignored.
 */
public class Zipper {
    private static final Logger logger = BufferedLoggerFactory.getLogger(Zipper.class);

    public static Path zip(List<Path> paths) throws ZipperException {
        Path zippedFile = Zipper.generateZipFilename(paths);
        Zipper.zipFiles(paths, (Path)zippedFile);
        Zipper.removeFiles(paths);
        return zippedFile;
    }

    private static void removeFiles(List<Path> paths) {
        paths.forEach(path -> {
            try {
                Files.deleteIfExists(path);
            }
            catch (IOException e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        });
    }

    private static Path generateZipFilename(List<Path> paths) {
        Path path = paths.get(0);
        String filename = path.getFileName().toString();
        int index = filename.lastIndexOf(".");
        filename = filename.substring(0, index);
        return path.getParent().resolve(filename + ".zip");
    }

    private static void zipFiles(List<Path> paths, Path zippedPath) throws ZipperException {
        try {
            Zipper.zipFilesWithoutExceptionHandling((Path)zippedPath, paths);
        }
        catch (FileNotFoundException e) {
            throw new ZipperException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static InputStreamResource zipFilesWithoutExceptionHandling(Path zipFilePath, List<Path> filePaths) throws FileNotFoundException, ZipperException {
        try (FileOutputStream outputStream = new FileOutputStream(zipFilePath.toFile());){
            InputStreamResource inputStreamResource;
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);){
                Zipper.addFilesToZipOutputStream((ZipOutputStream)zipOutputStream, filePaths);
                inputStreamResource = new InputStreamResource((InputStream)new FileInputStream(zipFilePath.toFile()));
            }
            return inputStreamResource;
        }
        catch (IOException e) {
            throw new ZipperException((Throwable)e);
        }
    }

    private static void addFilesToZipOutputStream(ZipOutputStream zipOutputStream, List<Path> filePaths) throws ZipperException {
        try {
            filePaths.forEach(filePath -> {
                File fileToZip = filePath.toFile();
                try (FileInputStream fileInputStream = new FileInputStream(fileToZip);){
                    int length;
                    ZipEntry zipEntry = new ZipEntry(fileToZip.getName());
                    zipOutputStream.putNextEntry(zipEntry);
                    byte[] bytes = new byte[1024];
                    while ((length = fileInputStream.read(bytes)) >= 0) {
                        zipOutputStream.write(bytes, 0, length);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (RuntimeException e) {
            throw new ZipperException((Throwable)e);
        }
    }
}

