/*
 * Decompiled with CFR 0.152.
 */
package de.samply.reporter.zip;

import de.samply.reporter.zip.ExporterUnzipperException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ExporterUnzipper {
    private final Path tempFilesDirectory;

    public ExporterUnzipper(@Value(value="${TEMP_FILES_DIRECTORY:./temp-files}") String tempFilesDirectory) {
        this.tempFilesDirectory = Path.of(tempFilesDirectory, new String[0]);
    }

    public Path[] extractFiles(String zipPath) throws ExporterUnzipperException {
        Path zipPath2 = this.moveToTempDirectory(zipPath);
        this.unzipFiles(zipPath2);
        this.removePath(zipPath2);
        return this.fetchFilesFromDirectory(zipPath2.getParent());
    }

    private void unzipFiles(Path zipPath) throws ExporterUnzipperException {
        try {
            this.unzipFilesWithoutExceptionHandling(zipPath);
        }
        catch (IOException e) {
            throw new ExporterUnzipperException((Throwable)e);
        }
    }

    private void unzipFilesWithoutExceptionHandling(Path zipPath) throws IOException {
        try (ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(zipPath.toFile()));){
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                this.unzipFile(zipPath.getParent(), zipEntry, zipInputStream);
                zipInputStream.closeEntry();
                zipEntry = zipInputStream.getNextEntry();
            }
        }
    }

    private void unzipFile(Path directory, ZipEntry zipEntry, ZipInputStream zipInputStream) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(directory.resolve(zipEntry.getName()).toFile());){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = zipInputStream.read(buffer)) > 0) {
                fileOutputStream.write(buffer, 0, length);
            }
        }
    }

    private Path moveToTempDirectory(String zipPath) throws ExporterUnzipperException {
        try {
            Path originalPath = Path.of(zipPath, new String[0]);
            return Files.move(originalPath, this.createTempDirectory().resolve(originalPath.getFileName().toString()), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new ExporterUnzipperException((Throwable)e);
        }
    }

    private Path createTempDirectory() throws ExporterUnzipperException {
        try {
            return Files.createTempDirectory(this.tempFilesDirectory, "TEMP_", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ExporterUnzipperException((Throwable)e);
        }
    }

    private void removePath(Path path) throws ExporterUnzipperException {
        try {
            Files.delete(path);
        }
        catch (IOException e) {
            throw new ExporterUnzipperException((Throwable)e);
        }
    }

    private Path[] fetchFilesFromDirectory(Path directory) throws ExporterUnzipperException {
        Path[] pathArray;
        block8: {
            Stream<Path> directoryStream = Files.walk(directory, new FileVisitOption[0]);
            try {
                pathArray = (Path[])directoryStream.filter(path -> !Files.isDirectory(path, new LinkOption[0])).toArray(Path[]::new);
                if (directoryStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (directoryStream != null) {
                        try {
                            directoryStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ExporterUnzipperException((Throwable)e);
                }
            }
            directoryStream.close();
        }
        return pathArray;
    }
}

