/*
 * Decompiled with CFR 0.152.
 */
package de.samply.reporter.utils.poi;

import de.samply.reporter.utils.poi.SheetSorter;
import de.samply.reporter.utils.poi.SortOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class SheetSorter {
    private final Map<Integer, SortInfo> columnOrderMap = new HashMap();
    private static final DataFormatter dataFormatter = new DataFormatter();
    private static BiFunction<Row, Integer, String> defaultRowColumnExtractor = (row, column) -> dataFormatter.formatCellValue(row.getCell(column.intValue()));

    public void addSortKey(int column, SortOrder order) {
        this.columnOrderMap.put(column, new StringSortInfo(order));
    }

    public <C extends Comparable> void addSortKey(int column, SortOrder order, BiFunction<Row, Integer, C> rowColumnExtractor) {
        this.columnOrderMap.put(column, new SortInfo(order, rowColumnExtractor));
    }

    public void sortSheet(Sheet sheet) {
        this.columnOrderMap.keySet().forEach(column -> this.sortSheet(sheet, column.intValue(), (SortInfo)this.columnOrderMap.get(column)));
    }

    private void sortSheet(Sheet sheet, int column, SortInfo sortInfo) {
        ArrayList rows = new ArrayList();
        sheet.forEach(row -> {
            if (row.getRowNum() != 0) {
                rows.add(row);
            }
        });
        Comparator<Row> comparator = Comparator.comparing(row -> (Comparable)sortInfo.getRowColumnExtractor().apply(row, column));
        Collections.sort(rows, sortInfo.getOrder() == SortOrder.ASCENDING ? comparator : comparator.reversed());
        AtomicInteger counter = new AtomicInteger(1);
        rows.forEach(row -> this.cloneRowInSheet(sheet, row, counter));
        rows.forEach(arg_0 -> ((Sheet)sheet).removeRow(arg_0));
    }

    private void cloneRowInSheet(Sheet sheet, Row row, AtomicInteger counter) {
        Row newRow = sheet.createRow(counter.getAndIncrement());
        row.forEach(cell -> {
            Cell newCell = newRow.createCell(cell.getColumnIndex());
            this.copyValue(cell, newCell);
            CellStyle cellStyle = cell.getCellStyle();
            newCell.setCellStyle(cellStyle);
        });
    }

    private void copyValue(Cell sourceCell, Cell targetCell) {
        switch (1.$SwitchMap$org$apache$poi$ss$usermodel$CellType[sourceCell.getCellType().ordinal()]) {
            case 1: {
                targetCell.setBlank();
                break;
            }
            case 2: {
                targetCell.setCellValue(sourceCell.getBooleanCellValue());
                break;
            }
            case 3: {
                targetCell.setCellErrorValue(sourceCell.getErrorCellValue());
                break;
            }
            case 4: {
                targetCell.setCellFormula(sourceCell.getCellFormula());
                break;
            }
            case 5: {
                targetCell.setCellValue(sourceCell.getNumericCellValue());
                break;
            }
            case 6: {
                targetCell.setCellValue(sourceCell.getStringCellValue());
            }
        }
    }
}

