/*
 * Decompiled with CFR 0.152.
 */
package de.samply.reporter.utils;

import de.samply.reporter.logger.BufferedLoggerFactory;
import de.samply.reporter.logger.Logger;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * Exception performing whole class analysis ignored.
 */
public class ProjectVersion {
    private static final String POM_FILE = "pom.xml";
    private static final Logger logger = BufferedLoggerFactory.getLogger(ProjectVersion.class);

    public static String getProjectVersion() {
        try {
            return ProjectVersion.getProjectVersion_WithoutManagementException();
        }
        catch (IOException | XmlPullParserException e) {
            logger.error("Error getting project version: " + ExceptionUtils.getStackTrace((Throwable)e));
            return "Quality Report Generator";
        }
    }

    private static String getProjectVersion_WithoutManagementException() throws IOException, XmlPullParserException {
        if (Files.exists(Paths.get("pom.xml", new String[0]), new LinkOption[0])) {
            return ProjectVersion.getProjectVersionFromPomFile();
        }
        return ProjectVersion.getProjectVersionFromManifest();
    }

    private static String getProjectVersionFromPomFile() throws IOException, XmlPullParserException {
        MavenXpp3Reader mavenXpp3Reader = new MavenXpp3Reader();
        Model model = mavenXpp3Reader.read((Reader)new FileReader("pom.xml"));
        return ProjectVersion.fetchVersion((Model)model);
    }

    private static String getProjectVersionFromManifest() {
        String implementationVersion = ProjectVersion.class.getPackage().getImplementationVersion();
        String implementationTitle = ProjectVersion.class.getPackage().getImplementationTitle();
        return ProjectVersion.createVersionToDisplay((String)implementationTitle, (String)implementationVersion);
    }

    private static String fetchVersion(Model model) {
        return ProjectVersion.createVersionToDisplay((String)model.getArtifactId(), (String)model.getVersion());
    }

    public static String createVersionToDisplay(String artifactId, String version) {
        return artifactId + ":" + version;
    }
}

