/*
 * Decompiled with CFR 0.152.
 */
package de.samply.reporter.script;

import de.samply.reporter.context.CellContext;
import de.samply.reporter.context.CellStyleContext;
import de.samply.reporter.context.Context;
import de.samply.reporter.logger.BufferedLoggerFactory;
import de.samply.reporter.logger.Logger;
import de.samply.reporter.script.GroovyTemplatesEngine;
import de.samply.reporter.script.ScriptEngine;
import de.samply.reporter.script.ScriptEngineException;
import de.samply.reporter.script.ScriptResult;
import de.samply.reporter.script.ThymeleafEngine;
import de.samply.reporter.template.ReportTemplate;
import de.samply.reporter.template.script.Script;
import de.samply.reporter.template.script.ScriptFramework;
import de.samply.reporter.template.script.ScriptReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class ScriptEngineManager {
    private final Logger logger = BufferedLoggerFactory.getLogger(ScriptEngineManager.class);
    private final Map<ScriptFramework, ScriptEngine> idScriptEngineMap = new HashMap();

    public ScriptEngineManager() {
        ScriptEngine[] scriptEngines = new ScriptEngine[]{new ThymeleafEngine(), new GroovyTemplatesEngine()};
        Arrays.stream(scriptEngines).forEach(scriptEngine -> this.idScriptEngineMap.put(scriptEngine.getScriptFramework(), scriptEngine));
    }

    public Map<Script, ScriptResult> generateRawReport(ReportTemplate template, Context context) {
        HashMap<Script, ScriptResult> results = new HashMap<Script, ScriptResult>();
        this.addScriptToResultsAndGenerateRawResult(template.getInitScript(), results, context);
        template.getSheetTemplates().forEach(sheetTemplate -> {
            this.logger.info("Generating temporal file with raw data for template " + sheetTemplate.getName() + "...");
            this.addScriptToResultsAndGenerateRawResult(sheetTemplate.getValuesScript(), results, context);
        });
        return results;
    }

    private void addScriptToResultsAndGenerateRawResult(ScriptReference scriptReference, Map<Script, ScriptResult> results, Context context) {
        if (scriptReference != null) {
            Script script = scriptReference.getScript();
            results.put(script, this.generateRawResult(script, context));
        }
    }

    private ScriptResult generateRawResult(Script script, Context context) {
        try {
            return this.generateRawResultWithoutExceptionHandling(script, context);
        }
        catch (ScriptEngineException e) {
            throw new RuntimeException(e);
        }
    }

    private ScriptResult generateRawResultWithoutExceptionHandling(Script script, Context context) throws ScriptEngineException {
        return ((ScriptEngine)this.idScriptEngineMap.get(this.fetchScriptFramework(script))).generateRawResult(script, context);
    }

    private ScriptFramework fetchScriptFramework(Script script) {
        ScriptFramework scriptFramework;
        ScriptFramework scriptFramework2 = scriptFramework = script.getFramework() != null ? ScriptFramework.valueOfFramework((String)script.getFramework()) : ScriptFramework.getDefault();
        if (scriptFramework == null) {
            throw new RuntimeException("Script Framework " + script.getFramework() + " not found");
        }
        return scriptFramework;
    }

    public CellContext generateCellContext(Script script, CellStyleContext cellStyleContext, Context context) throws ScriptEngineException {
        return ((ScriptEngine)this.idScriptEngineMap.get(this.fetchScriptFramework(script))).generateCellContext(script, cellStyleContext, context);
    }
}

