/*
 * Decompiled with CFR 0.152.
 */
package de.samply.reporter.report.workbook;

import de.samply.reporter.logger.BufferedLoggerFactory;
import de.samply.reporter.logger.Logger;
import de.samply.reporter.template.SheetTemplate;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class WorkbookManager {
    private static final Logger logger = BufferedLoggerFactory.getLogger(WorkbookManager.class);
    private final Integer workbookWindow;
    private final Integer maxNumberOfRows;
    private List<Workbook> workbooks = new ArrayList();
    private Map<SheetTemplate, List<Sheet>> templateSheetsMap = new HashMap();

    public WorkbookManager(Integer workbookWindow, Integer maxNumberOfRows) {
        this.workbookWindow = workbookWindow;
        this.maxNumberOfRows = maxNumberOfRows;
    }

    private Optional<Sheet> fetchLastSheet(SheetTemplate template) {
        List sheets = (List)this.templateSheetsMap.get(template);
        return sheets != null ? Optional.of((Sheet)sheets.get(sheets.size() - 1)) : Optional.empty();
    }

    public Sheet fetchLastSheetAndCreateIfNotExist(SheetTemplate template) {
        Optional lastSheet = this.fetchLastSheet(template);
        return lastSheet.isPresent() ? (Sheet)lastSheet.get() : this.createSheet(template);
    }

    public void apply(SheetTemplate template, Consumer<Sheet> sheetConsumer) {
        List sheets = (List)this.templateSheetsMap.get(template);
        if (sheets != null) {
            sheets.forEach(sheet -> sheetConsumer.accept((Sheet)sheet));
        }
    }

    public void apply(Consumer<Workbook> workbookConsumer) {
        this.workbooks.forEach(workbookConsumer);
    }

    public Row createRow(SheetTemplate template) {
        Optional lastSheet = this.fetchLastSheet(template);
        Sheet sheet = lastSheet.isPresent() ? (Sheet)lastSheet.get() : this.createSheet(template);
        int index = sheet.getLastRowNum() + 1;
        if (index > this.maxNumberOfRows) {
            sheet = this.createSheet(template);
            index = 0;
        }
        if (index == 0) {
            this.createHeaderRow(sheet, template);
            index = 1;
        }
        return sheet.createRow(index);
    }

    public Sheet createSheet(SheetTemplate sheetTemplate) {
        Optional lastSheet = this.fetchLastSheet(sheetTemplate);
        Workbook workbook = lastSheet.isEmpty() ? this.fetchFirstWorkbookOrCreateIfNotExist() : this.fetchNextWorkbookOrCreateIfNotExist(((Sheet)lastSheet.get()).getWorkbook());
        return this.createSheet(workbook, sheetTemplate);
    }

    private Optional<Workbook> fetchFirstWorkbook() {
        return this.workbooks.size() > 0 ? Optional.of((Workbook)this.workbooks.get(0)) : Optional.empty();
    }

    private Optional<Workbook> fetchNextWorkbook(Workbook workbook) {
        int index = this.workbooks.indexOf(workbook);
        return index + 1 < this.workbooks.size() ? Optional.of((Workbook)this.workbooks.get(index + 1)) : Optional.empty();
    }

    private Workbook fetchNextWorkbookOrCreateIfNotExist(Workbook workbook) {
        Optional nextWorkbook = this.fetchNextWorkbook(workbook);
        return nextWorkbook.isPresent() ? (Workbook)nextWorkbook.get() : this.createWorkbook();
    }

    private Workbook fetchFirstWorkbookOrCreateIfNotExist() {
        Optional firstWorkbook = this.fetchFirstWorkbook();
        return firstWorkbook.isPresent() ? (Workbook)firstWorkbook.get() : this.createWorkbook();
    }

    private Workbook createWorkbook() {
        SXSSFWorkbook workbook = new SXSSFWorkbook(this.workbookWindow.intValue());
        this.workbooks.add(workbook);
        return workbook;
    }

    private Sheet createSheet(Workbook workbook, SheetTemplate template) {
        ArrayList<Sheet> sheets;
        Sheet sheet = workbook.createSheet(template.getName());
        if (sheet instanceof SXSSFSheet) {
            ((SXSSFSheet)sheet).trackAllColumnsForAutoSizing();
        }
        if ((sheets = (ArrayList<Sheet>)this.templateSheetsMap.get(template)) == null) {
            sheets = new ArrayList<Sheet>();
            this.templateSheetsMap.put(template, sheets);
        }
        sheets.add(sheet);
        return sheet;
    }

    private void createHeaderRow(Sheet sheet, SheetTemplate template) {
        if (!template.getColumnTemplates().isEmpty()) {
            logger.info("Creating header row for sheet '" + template.getName() + "'...");
            Row row = sheet.createRow(0);
            AtomicInteger counter = new AtomicInteger(0);
            template.getColumnTemplates().forEach(columnTemplate -> row.createCell(counter.getAndIncrement()).setCellValue(columnTemplate.getName()));
            sheet.createFreezePane(0, 1);
            this.boldHeaderRow(sheet.getWorkbook(), row);
        }
    }

    private void boldHeaderRow(Workbook workbook, Row titleRow) {
        CellStyle cellStyle = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setBold(true);
        cellStyle.setFont(font);
        for (int j = 0; j < titleRow.getLastCellNum(); ++j) {
            Cell cell = titleRow.getCell(j);
            cell.setCellStyle(cellStyle);
        }
    }

    public void writeWorkbook(Path path) {
        this.apply(workbook -> this.writeWorkbook(path, workbook));
    }

    private void writeWorkbook(Path path, Workbook workbook) {
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.fetchRealPath(path, workbook).toFile());){
            workbook.write((OutputStream)fileOutputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Path fetchRealPath(Path path, Workbook workbook) {
        return this.workbooks.size() > 1 && this.workbooks.indexOf(workbook) > 0 ? path.getParent().resolve(this.createFilenameWithCounter(path, this.workbooks.indexOf(workbook) + 1)) : path;
    }

    public List<Path> fetchRealPaths(Path path) {
        return this.workbooks.stream().map(workbook -> this.fetchRealPath(path, workbook)).toList();
    }

    private String createFilenameWithCounter(Path path, int counter) {
        Object filename = path.getFileName().toString();
        int index = ((String)filename).lastIndexOf(".");
        if (counter > 1) {
            if (index > 0) {
                String extension = ((String)filename).substring(index);
                filename = ((String)filename).substring(0, index);
                filename = (String)filename + "_" + counter + extension;
            } else {
                filename = (String)filename + counter;
            }
        }
        return filename;
    }

    public boolean isMultiWorkbook() {
        return this.workbooks.size() > 1;
    }
}

