/*
 * Decompiled with CFR 0.152.
 */
package de.samply.reporter.report.metainfo;

import de.samply.reporter.report.RunningReportsManager;
import de.samply.reporter.report.metainfo.ReportMetaInfo;
import de.samply.reporter.report.metainfo.ReportMetaInfoManagerException;
import de.samply.reporter.template.ReportTemplate;
import de.samply.reporter.utils.VariablesReplacer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ReportMetaInfoManager {
    private final Path reportsMetaInfoFile;
    private final Path reportsDirectory;
    private final VariablesReplacer variablesReplacer;
    private final RunningReportsManager runningReportsManager;

    public ReportMetaInfoManager(VariablesReplacer variablesReplacer, RunningReportsManager runningReportsManager, @Value(value="${REPORTS_DIRECTORY:./reports}") String reportsDirectory, @Value(value="${REPORTS_META_INFO_FILENAME:reports-meta-info.csv}") String reportsMetaInfoFilename) throws ReportMetaInfoManagerException, IOException {
        this.reportsDirectory = Path.of(reportsDirectory, new String[0]);
        this.reportsMetaInfoFile = this.reportsDirectory.resolve(reportsMetaInfoFilename);
        this.variablesReplacer = variablesReplacer;
        this.runningReportsManager = runningReportsManager;
        this.reset();
    }

    public void reset() throws ReportMetaInfoManagerException, IOException {
        ReportMetaInfo[] reportMetaInfos = this.fetchAllExistingReportMetaInfos();
        this.recreateReportMetaInfoFile(List.of(reportMetaInfos));
    }

    public ReportMetaInfo createNewReportMetaInfo(ReportTemplate template) throws ReportMetaInfoManagerException {
        Path reportPath = this.reportsDirectory.resolve(this.variablesReplacer.fetchQualityReportFilename(template));
        String timestamp = this.fetchCurrentTimestamp();
        String reportId = this.generateReportId();
        ReportMetaInfo reportMetaInfo = new ReportMetaInfo(reportId, reportPath, timestamp, template.getId());
        this.addReportMetaInfoToFile(reportMetaInfo);
        return reportMetaInfo;
    }

    public void addReportMetaInfoToFile(ReportMetaInfo reportMetaInfo) throws ReportMetaInfoManagerException {
        try {
            this.addReportMetaInfoToFileWithoutExceptionHandling(reportMetaInfo);
        }
        catch (IOException e) {
            throw new ReportMetaInfoManagerException((Throwable)e);
        }
    }

    private void addReportMetaInfoToFileWithoutExceptionHandling(ReportMetaInfo reportMetaInfo) throws IOException {
        this.checkIfMetaInfoFileExistsAndCreateIfNot();
        Files.write(this.reportsMetaInfoFile, (reportMetaInfo.toString() + "\n").getBytes(), StandardOpenOption.APPEND);
    }

    private void checkIfMetaInfoFileExistsAndCreateIfNot() throws IOException {
        if (!this.reportsMetaInfoFile.toFile().exists()) {
            this.reportsMetaInfoFile.toFile().createNewFile();
        }
    }

    private String fetchCurrentTimestamp() {
        return new SimpleDateFormat("yyyyMMdd-HH_mm").format(Timestamp.from(Instant.now()));
    }

    private String generateReportId() {
        return RandomStringUtils.random((int)15, (boolean)true, (boolean)false);
    }

    public ReportMetaInfo[] fetchAllReportMetaInfos() throws ReportMetaInfoManagerException {
        return this.fetchAllReportMetaInfos(Optional.empty());
    }

    public ReportMetaInfo[] fetchAllExistingReportMetaInfos(int pageSize, int page) throws ReportMetaInfoManagerException {
        ReportMetaInfo[] reportMetaInfos = this.fetchAllExistingReportMetaInfos();
        ArrayList<ReportMetaInfo> result = new ArrayList<ReportMetaInfo>();
        for (int i = --page * pageSize; i < page * pageSize + pageSize && i < reportMetaInfos.length; ++i) {
            result.add(reportMetaInfos[i]);
        }
        return result.toArray(new ReportMetaInfo[0]);
    }

    public ReportMetaInfo[] fetchAllExistingReportMetaInfos() throws ReportMetaInfoManagerException {
        return this.fetchAllReportMetaInfos(Optional.of(reportMetaInfo -> reportMetaInfo.path().toFile().exists()));
    }

    public ReportMetaInfo[] fetchRunningReportMetaInfos() throws ReportMetaInfoManagerException {
        return this.fetchAllReportMetaInfos(Optional.of(reportMetaInfo -> !reportMetaInfo.path().toFile().exists() && this.runningReportsManager.isReportIdRunning(reportMetaInfo.id())));
    }

    public ReportMetaInfo[] fetchAllReportMetaInfos(Optional<Function<ReportMetaInfo, Boolean>> filter) throws ReportMetaInfoManagerException {
        try {
            return this.fetchAllReportMetaInfosWithoutExceptionHandling(filter);
        }
        catch (IOException e) {
            throw new ReportMetaInfoManagerException((Throwable)e);
        }
    }

    private ReportMetaInfo[] fetchAllReportMetaInfosWithoutExceptionHandling(Optional<Function<ReportMetaInfo, Boolean>> filter) throws IOException {
        ArrayList result = new ArrayList();
        this.checkIfMetaInfoFileExistsAndCreateIfNot();
        Files.readAllLines(this.reportsMetaInfoFile).forEach(line -> {
            ReportMetaInfo reportMetaInfo = ReportMetaInfo.create((Path)this.reportsDirectory, (String)line);
            if (filter.isEmpty() || ((Boolean)((Function)filter.get()).apply(reportMetaInfo)).booleanValue()) {
                result.add(reportMetaInfo);
            }
        });
        return result.toArray(new ReportMetaInfo[0]);
    }

    private void recreateReportMetaInfoFile(List<ReportMetaInfo> reportMetaInfos) throws IOException {
        if (this.reportsMetaInfoFile.toFile().exists()) {
            Files.delete(this.reportsMetaInfoFile);
        }
        reportMetaInfos.forEach(reportMetaInfo -> {
            try {
                this.addReportMetaInfoToFile(reportMetaInfo);
            }
            catch (ReportMetaInfoManagerException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public Optional<ReportMetaInfo> fetchReportMetaInfo(String reportId) throws ReportMetaInfoManagerException {
        ReportMetaInfo result = null;
        for (ReportMetaInfo reportMetaInfo : this.fetchAllReportMetaInfos()) {
            if (!reportMetaInfo.id().equals(reportId)) continue;
            result = reportMetaInfo;
            break;
        }
        return Optional.ofNullable(result);
    }
}

