/*
 * Decompiled with CFR 0.152.
 */
package de.samply.reporter.context;

import de.samply.reporter.context.CellStyleContext;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class CellContext {
    private final CellStyleContext cellStyleContext;
    private CellStyle cellStyle;
    private Function<Cell, Boolean> condition;
    private final List<Consumer<Cell>> cellModifiers = new ArrayList();
    private final List<Consumer<Sheet>> sheetModifiers = new ArrayList();
    private final DataFormatter dataFormatter = new DataFormatter();

    public CellContext(CellStyleContext cellStyleContext) {
        this.cellStyleContext = cellStyleContext;
    }

    public void setCondition(Function<Cell, Boolean> condition) {
        this.condition = condition;
    }

    public void setCellStyle(BiConsumer<Workbook, CellStyle> cellStyleConsumer) {
        this.cellStyle = this.cellStyleContext.createCellStyle();
        cellStyleConsumer.accept(this.cellStyleContext.getWorkbook(), this.cellStyle);
    }

    public void addCellModifier(Consumer<Cell> cellModifier) {
        this.cellModifiers.add(cellModifier);
    }

    public void addSheetModifier(Consumer<Sheet> sheetModifier) {
        this.sheetModifiers.add(sheetModifier);
    }

    public void applyCellStyleToCell(Cell cell) {
        if (cell != null && (this.condition == null || ((Boolean)this.condition.apply(cell)).booleanValue())) {
            if (this.cellStyle != null) {
                this.cellStyleContext.addCellStyleToCell(cell, this.cellStyle);
            }
            this.cellModifiers.forEach(cellModifier -> cellModifier.accept(cell));
        }
    }

    public void applySheetStyleToSheet(Sheet sheet) {
        if (sheet != null) {
            this.sheetModifiers.forEach(sheetModifier -> sheetModifier.accept(sheet));
        }
    }

    public String getCellValueAsString(Cell cell) {
        return cell != null ? this.dataFormatter.formatCellValue(cell) : "";
    }
}

