/*
 * Decompiled with CFR 0.152.
 */
package de.samply.reporter.utils;

import de.samply.reporter.template.ReportTemplate;
import de.samply.reporter.utils.EnvironmentUtils;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class VariablesReplacer {
    private final EnvironmentUtils environmentUtils;
    private final String qualityReportFilenameTemplate;
    private final String timestampFormat;

    public VariablesReplacer(EnvironmentUtils environmentUtils, @Value(value="${REPORT_FILENAME_TEMPLATE:report-{TIMESTAMP}}") String qualityReportFilenameTemplate, @Value(value="${TIMESTAMP_FORMAT:yyyyMMdd-HH_mm}") String timestampFormat) {
        this.environmentUtils = environmentUtils;
        this.qualityReportFilenameTemplate = qualityReportFilenameTemplate;
        this.timestampFormat = timestampFormat;
    }

    public String fetchQualityReportFilename(ReportTemplate template) {
        String result = template.getFilename() != null ? template.getFilename() : this.qualityReportFilenameTemplate;
        result = this.replaceAllVariables(result);
        return result;
    }

    public String replaceAllVariables(String input) {
        input = this.replaceTimestamp(input);
        input = this.replaceVariables(input);
        return input;
    }

    public String replaceTimestamp(String filename) {
        if (filename.contains("TIMESTAMP")) {
            String timestampFormat = this.timestampFormat;
            String templateStart = "TIMESTAMP:";
            if (filename.contains(templateStart)) {
                int index1 = filename.indexOf(templateStart);
                int index2 = filename.substring(index1).indexOf("}");
                timestampFormat = filename.substring(index1 + templateStart.length(), index1 + index2);
                filename = filename.replace(":" + timestampFormat, "");
            }
            String timestamp = this.fetchTimestamp(timestampFormat);
            filename = filename.replace("{TIMESTAMP}", timestamp);
        }
        return filename;
    }

    private String replaceVariables(String filename) {
        while (filename.contains("{")) {
            String variable = this.fetchNextVariable(filename);
            String value = this.environmentUtils.getEnvironmentVariable(variable);
            filename = filename.replace("{" + variable + "}", value != null ? value : "");
        }
        return filename;
    }

    private String fetchNextVariable(String filename) {
        int index1 = filename.indexOf("{");
        int index2 = filename.substring(index1).indexOf("}");
        return index2 >= 0 ? filename.substring(index1 + "{".length(), index1 + index2) : filename.substring(index1 + "{".length());
    }

    private String fetchTimestamp(String format) {
        if (format == null) {
            format = this.timestampFormat;
        }
        return new SimpleDateFormat(format).format(Timestamp.from(Instant.now()));
    }
}

