/*
 * Decompiled with CFR 0.152.
 */
package de.samply.reporter.template;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import de.samply.reporter.template.ReportTemplate;
import de.samply.reporter.template.script.ScriptParser;
import de.samply.reporter.utils.VariablesReplacer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ReportTemplateManager {
    private final VariablesReplacer variablesReplacer;
    private final String customTemplateId;
    private final Map<String, ReportTemplate> idQualityReportTemplateMap = new HashMap();
    private final Map<String, Path> idQualityReportTemplatePathMap = new HashMap();

    public ReportTemplateManager(VariablesReplacer variablesReplacer, @Value(value="${CUSTOM_TEMPLATE_ID:custom-{TIMESTAMP}}") String customTemplateId, @Value(value="${REPORT_TEMPLATE_DIRECTORY:./templates}") String qualityReportTemplateDirectory) {
        this.variablesReplacer = variablesReplacer;
        this.customTemplateId = customTemplateId;
        this.loadTemplates(Path.of(qualityReportTemplateDirectory, new String[0]));
    }

    private void loadTemplates(Path templateDirectory) {
        try {
            this.loadTemplatesWithoutExceptionHandling(templateDirectory);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadTemplatesWithoutExceptionHandling(Path templateDirectory) throws IOException {
        if (Files.exists(templateDirectory, new LinkOption[0])) {
            try (Stream<Path> pathStream = Files.list(templateDirectory);){
                pathStream.filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(arg_0 -> this.loadTemplate(arg_0));
            }
        }
    }

    private void loadTemplate(Path templatePath) {
        try {
            this.loadTemplateWithoutExceptionHandling(templatePath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadTemplateWithoutExceptionHandling(Path templatePath) throws IOException {
        ReportTemplate reportTemplate = this.fetchTemplate(templatePath);
        this.idQualityReportTemplateMap.put(reportTemplate.getId(), reportTemplate);
        this.idQualityReportTemplatePathMap.put(reportTemplate.getId(), templatePath);
    }

    public ReportTemplate fetchTemplate(Path templatePath) throws IOException {
        return this.fetchTemplate(Files.readString(templatePath));
    }

    public ReportTemplate fetchTemplate(String template) throws IOException {
        return (ReportTemplate)new XmlMapper().readValue(ScriptParser.readTemplateAndParseScripts((String)template), ReportTemplate.class);
    }

    public ReportTemplate fetchTemplateAndGenerateCustomTemplateId(String template) throws IOException {
        ReportTemplate result = this.fetchTemplate(template);
        result.setId(this.generateCustomTemplateId());
        return result;
    }

    private String generateCustomTemplateId() {
        return this.variablesReplacer.replaceTimestamp(this.customTemplateId);
    }

    public ReportTemplate getQualityReportTemplate(String qualityReportTemplateId) {
        return (ReportTemplate)this.idQualityReportTemplateMap.get(qualityReportTemplateId);
    }

    public String[] getReportTemplateIds() {
        return this.idQualityReportTemplateMap.keySet().toArray(new String[0]);
    }

    public Optional<Path> getReportTemplatePath(String reportTemplateId) {
        return Optional.ofNullable((Path)this.idQualityReportTemplatePathMap.get(reportTemplateId));
    }
}

