/*
 * Decompiled with CFR 0.152.
 */
package de.samply.reporter.report.metainfo;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.samply.reporter.report.metainfo.PathSerializer;
import java.nio.file.Path;

public record ReportMetaInfo(@JsonProperty(value="id") String id, @JsonProperty(value="path") @JsonSerialize(using=PathSerializer.class) Path path, @JsonProperty(value="timestamp") String timestamp, @JsonProperty(value="template-id") String templateId) {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="path")
    @JsonSerialize(using=PathSerializer.class)
    private final Path path;
    @JsonProperty(value="timestamp")
    private final String timestamp;
    @JsonProperty(value="template-id")
    private final String templateId;

    public ReportMetaInfo(@JsonProperty(value="id") String id, @JsonProperty(value="path") @JsonSerialize(using=PathSerializer.class) Path path, @JsonProperty(value="timestamp") String timestamp, @JsonProperty(value="template-id") String templateId) {
        this.id = id;
        this.path = path;
        this.timestamp = timestamp;
        this.templateId = templateId;
    }

    @Override
    public String toString() {
        return this.id + "," + this.path.getFileName().toString() + "," + this.timestamp + "," + this.templateId;
    }

    public static ReportMetaInfo create(Path reportDirectory, String reportMetaInfoLine) {
        String id = null;
        Path path = null;
        String timestamp = null;
        String templateId = null;
        if (reportMetaInfoLine != null) {
            String[] split = reportMetaInfoLine.split(",");
            if (split.length > 0) {
                id = split[0];
            }
            if (split.length > 1) {
                path = reportDirectory.resolve(split[1]);
            }
            if (split.length > 2) {
                timestamp = split[2];
            }
            if (split.length > 3) {
                templateId = split[3];
            }
        }
        return new ReportMetaInfo(id, path, timestamp, templateId);
    }

    @JsonProperty(value="id")
    public String id() {
        return this.id;
    }

    @JsonProperty(value="path")
    @JsonSerialize(using=PathSerializer.class)
    public Path path() {
        return this.path;
    }

    @JsonProperty(value="timestamp")
    public String timestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="template-id")
    public String templateId() {
        return this.templateId;
    }
}

