/*
 * Decompiled with CFR 0.152.
 */
package de.samply.reporter.context;

import de.samply.reporter.context.ContextException;
import de.samply.reporter.context.CsvConfig;
import de.samply.reporter.context.MultiMap;
import de.samply.reporter.logger.BufferedLoggerFactory;
import de.samply.reporter.logger.Logger;
import de.samply.reporter.script.CsvRecordIterator;
import de.samply.reporter.template.ColumnTemplate;
import de.samply.reporter.template.ReportTemplate;
import de.samply.reporter.template.SheetTemplate;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class Context {
    private final Logger logger = BufferedLoggerFactory.getLogger(Context.class);
    private final Path resultsDirectory;
    private final ReportTemplate reportTemplate;
    private final Path[] sourcePaths;
    private final CsvConfig csvConfig;
    private final Map<String, Function<String[], String>> functionMap = new HashMap();
    private final MultiMap multiMap = new MultiMap();
    private final Map<String, Integer> sheetNameColumnNameIndex = new HashMap();

    public Context(Path resultsDirectory, ReportTemplate reportTemplate, Path[] sourcePaths, CsvConfig csvConfig) {
        this.resultsDirectory = resultsDirectory;
        this.reportTemplate = reportTemplate;
        this.sourcePaths = sourcePaths;
        this.sortSourcePaths(sourcePaths);
        this.csvConfig = csvConfig;
    }

    private void sortSourcePaths(Path[] sourcePaths) {
        Arrays.sort(sourcePaths, Comparator.comparing(path -> path.getFileName().toString().length()));
    }

    public Logger getLogger() {
        return this.logger;
    }

    public CsvConfig getCsvConfig() {
        return this.csvConfig;
    }

    public void defineFunction(String functionName, Function<String[], String> function) {
        this.functionMap.put(functionName, function);
    }

    public String executeFunction(String functionName, String ... parameters) {
        Function function = (Function)this.functionMap.get(functionName);
        return function != null ? (String)function.apply(parameters) : "";
    }

    public Iterator<CSVRecord> fetchCsvRecords(String filename) throws ContextException {
        Path sourcePath = this.findSourcePathByName(filename);
        return this.fetchCsvRecords(sourcePath);
    }

    public Iterator<CSVRecord> fetchCsvRecords(Path path) throws ContextException {
        return path != null ? new CsvRecordIterator(path, this.csvConfig) : Collections.emptyIterator();
    }

    private Path findSourcePathByName(String filename) {
        for (Path path : this.sourcePaths) {
            if (!path.getFileName().toString().toLowerCase().contains(filename.toLowerCase())) continue;
            return path;
        }
        return null;
    }

    public Object getElement(String ... keys) {
        return this.multiMap.get(keys);
    }

    public List<Object> getAllElement(String ... keys) {
        return this.multiMap.getAll(keys);
    }

    public Set<String> getKeySet(String ... keys) {
        return this.multiMap.getKeySet(keys);
    }

    public void putElement(Object element, String ... keys) {
        this.multiMap.put(element, keys);
    }

    public Path getResultsDirectory() {
        return this.resultsDirectory;
    }

    public ReportTemplate getReportTemplate() {
        return this.reportTemplate;
    }

    public List<Path> getSourcePaths() {
        return List.of(this.sourcePaths);
    }

    public void applyToRecords(String filename, Consumer<CSVRecord> recordConsumer) {
        Path path = this.findSourcePathByName(filename);
        if (path != null) {
            this.applyToRecords(path, recordConsumer);
        }
    }

    public void applyToRecords(Path sourcePath, Consumer<CSVRecord> recordConsumer) {
        try (FileReader fileReader = new FileReader(sourcePath.toFile());
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            this.applyToRecords(bufferedReader, recordConsumer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void applyToRecords(BufferedReader bufferedReader, Consumer<CSVRecord> recordConsumer) throws IOException {
        try (CSVParser csvParser = CSVFormat.Builder.create().setHeader(new String[0]).setSkipHeaderRecord(true).setDelimiter(this.csvConfig.delimiter()).setRecordSeparator(this.csvConfig.endOfLine()).build().parse((Reader)bufferedReader);){
            csvParser.getRecords().forEach(recordConsumer);
        }
    }

    public boolean hasOnlyHeaders(Path path) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(path.toFile()));){
            int lineCount = 0;
            while (reader.readLine() != null) {
                if (++lineCount <= 1) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    public List<String> fetchHeaders(Path path) throws IOException {
        String[] result = new String[]{};
        try (BufferedReader reader = new BufferedReader(new FileReader(path.toFile()));){
            String line = reader.readLine();
            if (line != null && line.trim().length() > 0) {
                result = line.split(this.csvConfig.delimiter());
            }
        }
        return List.of(result);
    }

    public Integer getColumnIndex(String sheetName, String columnName) {
        String key = sheetName + columnName;
        Integer index = (Integer)this.sheetNameColumnNameIndex.get(key);
        if (index == null) {
            SheetTemplate sheetTemplate = null;
            for (SheetTemplate tempSheetTemplate : this.reportTemplate.getSheetTemplates()) {
                if (!tempSheetTemplate.getName().equalsIgnoreCase(sheetName)) continue;
                sheetTemplate = tempSheetTemplate;
                break;
            }
            if (sheetTemplate != null) {
                int tempIndex = 0;
                for (ColumnTemplate columnTemplate : sheetTemplate.getColumnTemplates()) {
                    if (columnTemplate.getName().equalsIgnoreCase(columnName)) {
                        index = tempIndex;
                        break;
                    }
                    ++tempIndex;
                }
            }
            this.sheetNameColumnNameIndex.put(key, index);
        }
        return index;
    }
}

