/*
 * Decompiled with CFR 0.152.
 */
package de.samply.reporter.app;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class CorsConfig
implements WebMvcConfigurer {
    private final String[] crossOrigins;
    private final int corsMaxAgeInSeconds;

    public CorsConfig(@Value(value="#{'${CROSS_ORIGINS:#{null}}'.split(',')}") String[] crossOrigins, @Value(value="${CORS_MAX_AGE_IN_SECONDS:360}") Integer corsMaxAgeInSeconds) {
        this.crossOrigins = crossOrigins;
        this.corsMaxAgeInSeconds = corsMaxAgeInSeconds;
    }

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**").allowedOrigins(this.crossOrigins).allowedMethods(new String[]{"GET", "POST", "OPTIONS"}).allowedHeaders(new String[]{"Authorization", "Cache-Control", "Content-Type", "Origin"}).allowCredentials(true).maxAge((long)this.corsMaxAgeInSeconds);
    }
}

