/*
 * Decompiled with CFR 0.152.
 */
package de.samply.project.directory.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.samply.common.http.HttpConnector;
import de.samply.project.directory.client.DktkProjectDirectoryParameters;
import de.samply.project.directory.client.Project;
import de.samply.project.directory.client.ProjectDirectory;
import de.samply.project.directory.client.ProjectDirectoryException;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;

public class DktkProjectDirectory
implements ProjectDirectory {
    private String source = "Url";
    private URL url;
    private String sourceFilePath = "https://deployment.ccp-it.dktk.dkfz.de/ccp-it-deployment-static/projects/projects.json";
    private String destinationFilePath = "src/tmp/projects.json";
    private HttpConnector httpConnector;
    private HashMap<String, Project> projectMap;

    public DktkProjectDirectory() {
    }

    public DktkProjectDirectory(DktkProjectDirectoryParameters dktkProjectDirectoryParameters) {
        this.sourceFilePath = dktkProjectDirectoryParameters.getSourceFilePath();
        this.destinationFilePath = dktkProjectDirectoryParameters.getDestinationFilePath();
        this.httpConnector = dktkProjectDirectoryParameters.getHttpConnector();
    }

    public void initialize() throws ProjectDirectoryException {
        try {
            this.url = new URL(this.sourceFilePath);
        }
        catch (Exception e) {
            throw new ProjectDirectoryException(e);
        }
        this.readFromSource();
    }

    public String getSourceFilePath() {
        return this.sourceFilePath;
    }

    public void setSourceFilePath(String sourceFilePath) {
        this.sourceFilePath = sourceFilePath;
    }

    public String getDestinationFilePath() {
        return this.destinationFilePath;
    }

    public void setDestinationFilePath(String destinationFilePath) {
        this.destinationFilePath = destinationFilePath;
    }

    @Override
    public Project getProject(String id) throws ProjectDirectoryException {
        if (this.projectMap == null) {
            this.initialize();
        }
        return this.projectMap.get(id);
    }

    public void readFromSource() throws ProjectDirectoryException {
        this.projectMap = new HashMap();
        try {
            JsonArray projList;
            JsonParser jsonParser = new JsonParser();
            if (this.source.equals("File")) {
                projList = jsonParser.parse((Reader)new FileReader(this.sourceFilePath)).getAsJsonArray();
            } else {
                CloseableHttpClient httpClient = this.getHttpClient(this.url);
                this.download(httpClient, this.url);
                projList = jsonParser.parse((Reader)new FileReader(this.destinationFilePath)).getAsJsonArray();
            }
            for (int i = 0; i < projList.size(); ++i) {
                JsonObject projJson = (JsonObject)projList.get(i);
                String id = projJson.get("id").getAsString();
                String name = projJson.get("name").getAsString();
                String title = projJson.get("title").getAsString();
                String type = projJson.get("type").getAsString();
                ArrayList<String> dataCategory = new ArrayList<String>();
                JsonArray jsonData = projJson.get("data_category").getAsJsonArray();
                for (int j = 0; j < jsonData.size(); ++j) {
                    dataCategory.add(jsonData.get(j).getAsString());
                }
                this.projectMap.put(id, new Project(id, name, title, type, dataCategory));
            }
        }
        catch (Exception e) {
            throw new ProjectDirectoryException(e);
        }
    }

    @Override
    public List<Project> getAllProjects() throws ProjectDirectoryException {
        if (this.projectMap == null) {
            this.initialize();
        }
        return new ArrayList<Project>(this.projectMap.values());
    }

    private CloseableHttpClient getHttpClient(URL url) {
        HttpConnector httpConnector = this.getHttpConnector();
        return httpConnector.getHttpClient(url);
    }

    private void download(CloseableHttpClient httpClient, URL url) throws IOException, URISyntaxException {
        try (CloseableHttpResponse httpResponse = this.getHttpResponse(httpClient, url);){
            this.download(httpResponse.getEntity().getContent());
        }
    }

    private void download(InputStream inputStream) throws IOException {
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(this.destinationFilePath));){
            int chunkSize;
            byte[] chunk = new byte[1024];
            while ((chunkSize = inputStream.read(chunk)) != -1) {
                ((OutputStream)outputStream).write(chunk, 0, chunkSize);
            }
            ((OutputStream)outputStream).flush();
        }
    }

    private CloseableHttpResponse getHttpResponse(CloseableHttpClient httpClient, URL url) throws URISyntaxException, IOException {
        HttpGet httpGet = new HttpGet(url.toURI());
        return httpClient.execute((HttpUriRequest)httpGet);
    }

    private HttpConnector getHttpConnector() {
        if (this.httpConnector == null) {
            this.httpConnector = this.createHttpConnector();
        }
        return this.httpConnector;
    }

    public void setHttpConnector(HttpConnector httpConnector) {
        this.httpConnector = httpConnector;
    }

    private HttpConnector createHttpConnector() {
        HashMap config = new HashMap();
        HttpConnector httpConnector = new HttpConnector(config);
        return httpConnector;
    }
}

