/*
 * Decompiled with CFR 0.152.
 */
package de.samply.common.web.jsf.renderer;

import com.sun.faces.renderkit.Attribute;
import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.MessagesRenderer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIMessages;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="javax.faces.Messages", rendererType="javax.faces.Messages")
public class BootstrapMessagesRenderer
extends MessagesRenderer {
    private static final Attribute[] ATTRIBUTES = AttributeManager.getAttributes((AttributeManager.Key)AttributeManager.Key.MESSAGESMESSAGES);

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        super.encodeBegin(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Iterator messageIt;
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        boolean mustRender = this.shouldWriteIdAttribute(component);
        UIMessages messages = (UIMessages)component;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = ((UIMessages)component).getFor();
        if (clientId == null && messages.isGlobalOnly()) {
            clientId = "";
        }
        if (!(messageIt = this.getMessageIter(context, clientId, component)).hasNext()) {
            if (mustRender) {
                if ("javax_faces_developmentstage_messages".equals(component.getId())) {
                    return;
                }
                writer.startElement("div", component);
                this.writeIdAttributeIfNecessary(context, writer, component);
                writer.endElement("div");
            }
            return;
        }
        this.writeIdAttributeIfNecessary(context, writer, component);
        RenderKitUtils.renderPassThruAttributes((FacesContext)context, (ResponseWriter)writer, (UIComponent)component, (Attribute[])ATTRIBUTES);
        HashMap msgs = new HashMap();
        msgs.put(FacesMessage.SEVERITY_INFO, new ArrayList());
        msgs.put(FacesMessage.SEVERITY_WARN, new ArrayList());
        msgs.put(FacesMessage.SEVERITY_ERROR, new ArrayList());
        msgs.put(FacesMessage.SEVERITY_FATAL, new ArrayList());
        while (messageIt.hasNext()) {
            FacesMessage curMessage = (FacesMessage)messageIt.next();
            if (curMessage.isRendered() && !messages.isRedisplay()) continue;
            ((List)msgs.get(curMessage.getSeverity())).add(curMessage);
        }
        List severityMessages = (List)msgs.get(FacesMessage.SEVERITY_FATAL);
        if (!severityMessages.isEmpty()) {
            this.encodeSeverityMessages(context, messages, FacesMessage.SEVERITY_FATAL, severityMessages);
        }
        if (!(severityMessages = (List)msgs.get(FacesMessage.SEVERITY_ERROR)).isEmpty()) {
            this.encodeSeverityMessages(context, messages, FacesMessage.SEVERITY_ERROR, severityMessages);
        }
        if (!(severityMessages = (List)msgs.get(FacesMessage.SEVERITY_WARN)).isEmpty()) {
            this.encodeSeverityMessages(context, messages, FacesMessage.SEVERITY_WARN, severityMessages);
        }
        if (!(severityMessages = (List)msgs.get(FacesMessage.SEVERITY_INFO)).isEmpty()) {
            this.encodeSeverityMessages(context, messages, FacesMessage.SEVERITY_INFO, severityMessages);
        }
    }

    private void encodeSeverityMessages(FacesContext facesContext, UIMessages uiMessages, FacesMessage.Severity severity, List<FacesMessage> messages) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String alertSeverityClass = "";
        String alertIconClass = "";
        if (FacesMessage.SEVERITY_INFO.equals(severity)) {
            alertSeverityClass = "alert-info";
            alertIconClass = "fa fa-lg fa-info-circle";
        } else if (FacesMessage.SEVERITY_WARN.equals(severity)) {
            alertSeverityClass = "alert-warning";
            alertIconClass = "fa fa-lg fa-exclamation-circle";
        } else if (FacesMessage.SEVERITY_ERROR.equals(severity)) {
            alertSeverityClass = "alert-danger";
            alertIconClass = "fa fa-lg fa-times-circle";
        } else if (FacesMessage.SEVERITY_FATAL.equals(severity)) {
            alertSeverityClass = "alert-danger";
            alertIconClass = "fa fa-lg fa-times-circle";
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)("alert " + alertSeverityClass), "alert " + alertSeverityClass);
        writer.writeAttribute("role", (Object)"alert", "alert");
        writer.startElement("a", (UIComponent)uiMessages);
        writer.writeAttribute("class", (Object)"close", "class");
        writer.writeAttribute("data-dismiss", (Object)"alert", "data-dismiss");
        writer.writeAttribute("href", (Object)"#", "href");
        writer.write("&#xd7;");
        writer.endElement("a");
        writer.startElement("ul", null);
        writer.writeAttribute("style", (Object)"list-style: none;", "list-style: none;");
        for (FacesMessage msg : messages) {
            String summary = msg.getSummary() != null ? msg.getSummary() : "";
            String detail = msg.getDetail() != null ? msg.getDetail() : summary;
            writer.startElement("li", (UIComponent)uiMessages);
            writer.startElement("i", null);
            writer.writeAttribute("class", (Object)alertIconClass, alertIconClass);
            writer.writeAttribute("style", (Object)"margin-right: 5px; margin-top: 5px; float:left;", "margin-right: 5px; margin-top: 5px; float:left;");
            writer.endElement("i");
            writer.startElement("div", null);
            if (uiMessages.isShowSummary()) {
                writer.startElement("span", (UIComponent)uiMessages);
                writer.writeAttribute("style", (Object)"font-size: large; font-weight: bold;", "font-size: large; font-weight: bold;");
                writer.writeText((Object)summary, (UIComponent)uiMessages, null);
                writer.endElement("span");
            }
            if (uiMessages.isShowDetail()) {
                writer.writeText((Object)(" " + detail), null);
            }
            writer.endElement("div");
            writer.endElement("li");
            msg.rendered();
        }
        writer.endElement("ul");
        writer.endElement("div");
    }
}

