/*
 * Decompiled with CFR 0.152.
 */
package de.samply.common.web.jsf.renderer;

import com.sun.faces.renderkit.Attribute;
import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.MessageRenderer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIMessage;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="javax.faces.Message", rendererType="javax.faces.Message")
public class BootstrapMessageRenderer
extends MessageRenderer {
    private static final Attribute[] ATTRIBUTES = AttributeManager.getAttributes((AttributeManager.Key)AttributeManager.Key.MESSAGESMESSAGES);

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        super.encodeBegin(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        boolean mustRender = this.shouldWriteIdAttribute(component);
        UIMessage messages = (UIMessage)component;
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        String clientId = ((UIMessage)component).getFor();
        Iterator messageIter = this.getMessageIter(context, clientId, component);
        assert (messageIter != null);
        if (!messageIter.hasNext()) {
            if (mustRender) {
                if ("javax_faces_developmentstage_messages".equals(component.getId())) {
                    return;
                }
                writer.startElement("div", component);
                this.writeIdAttributeIfNecessary(context, writer, component);
                writer.endElement("div");
            }
            return;
        }
        this.writeIdAttributeIfNecessary(context, writer, component);
        RenderKitUtils.renderPassThruAttributes((FacesContext)context, (ResponseWriter)writer, (UIComponent)component, (Attribute[])ATTRIBUTES);
        HashMap msgs = new HashMap();
        msgs.put(FacesMessage.SEVERITY_INFO, new ArrayList());
        msgs.put(FacesMessage.SEVERITY_WARN, new ArrayList());
        msgs.put(FacesMessage.SEVERITY_ERROR, new ArrayList());
        msgs.put(FacesMessage.SEVERITY_FATAL, new ArrayList());
        while (messageIter.hasNext()) {
            FacesMessage curMessage = (FacesMessage)messageIter.next();
            if (curMessage.isRendered() && !messages.isRedisplay()) continue;
            ((List)msgs.get(curMessage.getSeverity())).add(curMessage);
        }
        List severityMessages = (List)msgs.get(FacesMessage.SEVERITY_FATAL);
        if (severityMessages.size() > 0) {
            this.encodeSeverityMessages(context, component, messages, FacesMessage.SEVERITY_FATAL, severityMessages);
        }
        if ((severityMessages = (List)msgs.get(FacesMessage.SEVERITY_ERROR)).size() > 0) {
            this.encodeSeverityMessages(context, component, messages, FacesMessage.SEVERITY_ERROR, severityMessages);
        }
        if ((severityMessages = (List)msgs.get(FacesMessage.SEVERITY_WARN)).size() > 0) {
            this.encodeSeverityMessages(context, component, messages, FacesMessage.SEVERITY_WARN, severityMessages);
        }
        if ((severityMessages = (List)msgs.get(FacesMessage.SEVERITY_INFO)).size() > 0) {
            this.encodeSeverityMessages(context, component, messages, FacesMessage.SEVERITY_INFO, severityMessages);
        }
    }

    private void encodeSeverityMessages(FacesContext facesContext, UIComponent component, UIMessage uiMessages, FacesMessage.Severity severity, List<FacesMessage> messages) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String alertSeverityClass = "";
        if (FacesMessage.SEVERITY_INFO.equals(severity)) {
            alertSeverityClass = "alert-info";
        } else if (FacesMessage.SEVERITY_WARN.equals(severity)) {
            alertSeverityClass = "alert-warning";
        } else if (FacesMessage.SEVERITY_ERROR.equals(severity)) {
            alertSeverityClass = "alert-danger";
        } else if (FacesMessage.SEVERITY_FATAL.equals(severity)) {
            alertSeverityClass = "alert-danger";
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)("alert " + alertSeverityClass), "alert " + alertSeverityClass);
        writer.writeAttribute("role", (Object)"alert", "alert");
        writer.startElement("a", (UIComponent)uiMessages);
        writer.writeAttribute("class", (Object)"close", "class");
        writer.writeAttribute("data-dismiss", (Object)"alert", "data-dismiss");
        writer.writeAttribute("href", (Object)"#", "href");
        writer.write("&#xd7;");
        writer.endElement("a");
        for (FacesMessage msg : messages) {
            String detail;
            String summary = msg.getSummary() != null ? msg.getSummary() : "";
            String string = detail = msg.getDetail() != null ? msg.getDetail() : summary;
            if (uiMessages.isShowSummary()) {
                writer.startElement("strong", component);
                writer.writeText((Object)summary, component, null);
                writer.endElement("strong");
            }
            if (uiMessages.isShowDetail()) {
                writer.writeText((Object)(" " + detail), null);
            }
            msg.rendered();
        }
        writer.endElement("div");
    }
}

