/*
 * Decompiled with CFR 0.152.
 */
package de.samply.dktk.converter.sort.mdr;

import de.samply.common.mdrclient.MdrClient;
import de.samply.dktk.converter.sort.mdr.DateFirstComparator;
import de.samply.dktk.converter.sort.mdr.DktkIdComparator;
import de.samply.dktk.converter.sort.mdr.SortRules;
import java.util.Collections;
import java.util.List;

public class DktkSortRules
implements SortRules {
    private MdrClient mdrClient;

    public DktkSortRules(MdrClient mdrClient) {
        this.mdrClient = mdrClient;
    }

    @Override
    public List<String> sortMdrIds(List<String> listOfMdrIds) {
        listOfMdrIds = this.sortMdrIdsByDktkId(listOfMdrIds);
        listOfMdrIds = this.sortMdrIdsAssuringAdt90preceedsAdt93(listOfMdrIds);
        listOfMdrIds = this.sortMdrIdsAssuringAdt77preceedsAdt78(listOfMdrIds);
        listOfMdrIds = this.sortMdrIdsByPuttingDatesAtTheFirstPosition(listOfMdrIds);
        return listOfMdrIds;
    }

    private List<String> sortMdrIdsByDktkId(List<String> listOfMdrIds) {
        Collections.sort(listOfMdrIds, new DktkIdComparator(this.mdrClient));
        return listOfMdrIds;
    }

    private List<String> sortMdrIdsAssuringAdt90preceedsAdt93(List<String> listOfMdrIds) {
        return this.assureElement1PrecedesElement2(listOfMdrIds, "urn:adt:dataelement:90", "urn:adt:dataelement:93");
    }

    private List<String> sortMdrIdsAssuringAdt77preceedsAdt78(List<String> listOfMdrIds) {
        return this.assureElement1PrecedesElement2(listOfMdrIds, "urn:adt:dataelement:77", "urn:adt:dataelement:78");
    }

    private List<String> sortMdrIdsByPuttingDatesAtTheFirstPosition(List<String> listOfMdrIds) {
        Collections.sort(listOfMdrIds, new DateFirstComparator(this.mdrClient));
        return listOfMdrIds;
    }

    private List<String> assureElement1PrecedesElement2(List<String> listOfMdrIds, String mdrId1, String mdrId2) {
        Integer dataElement1index = null;
        Integer dataElement2index = null;
        for (String mdrId : listOfMdrIds) {
            if (mdrId1.contains(mdrId)) {
                dataElement1index = listOfMdrIds.indexOf(mdrId);
                continue;
            }
            if (!mdrId2.contains(mdrId)) continue;
            dataElement2index = listOfMdrIds.indexOf(mdrId);
        }
        if (dataElement1index != null && dataElement2index != null && dataElement1index > dataElement2index) {
            Collections.swap(listOfMdrIds, (int)dataElement1index, (int)dataElement2index);
        }
        return listOfMdrIds;
    }
}

