/*
 * Decompiled with CFR 0.152.
 */
package de.samply.dktk.converter.sort;

import de.samply.common.mdrclient.MdrClient;
import de.samply.common.mdrclient.MdrConnectionException;
import de.samply.common.mdrclient.MdrInvalidResponseException;
import de.samply.common.mdrclient.domain.DataElement;
import de.samply.dktk.converter.PatientConverterUtil;
import de.samply.dktk.converter.sort.MdrUtilsException;
import java.util.concurrent.ExecutionException;

public class MdrUtils {
    private MdrClient mdrClient;

    public MdrUtils(MdrClient mdrClient) {
        this.mdrClient = mdrClient;
    }

    public boolean isDatum(String mdrId) throws MdrUtilsException {
        String dataType;
        boolean isDatum = false;
        if (mdrId != null && (dataType = this.getDataType(mdrId)) != null && dataType.equalsIgnoreCase("Date")) {
            isDatum = true;
        }
        return isDatum;
    }

    public String getDataType(String mdrId) throws MdrUtilsException {
        try {
            return this.getDataType_WithoutManagementException(mdrId);
        }
        catch (ExecutionException e) {
            throw new MdrUtilsException(e);
        }
        catch (MdrConnectionException e) {
            throw new MdrUtilsException(e);
        }
        catch (MdrInvalidResponseException e) {
            throw new MdrUtilsException(e);
        }
    }

    private String getDataType_WithoutManagementException(String mdrId) throws ExecutionException, MdrConnectionException, MdrInvalidResponseException {
        DataElement dataElement = this.mdrClient.getDataElement(mdrId, "de");
        return dataElement != null ? dataElement.getValidation().getDatatype() : null;
    }

    public String getDktkId(String mdrId) throws MdrUtilsException {
        try {
            return this.getDktkId_WithoutManagementExeception(mdrId);
        }
        catch (MdrConnectionException e) {
            throw new MdrUtilsException(e);
        }
        catch (MdrInvalidResponseException e) {
            throw new MdrUtilsException(e);
        }
        catch (ExecutionException e) {
            throw new MdrUtilsException(e);
        }
    }

    private String getDktkId_WithoutManagementExeception(String mdrId) throws ExecutionException, MdrConnectionException, MdrInvalidResponseException {
        String dktkId = null;
        if (mdrId != null) {
            DataElement dataElement = this.mdrClient.getDataElement(mdrId, "de");
            dktkId = PatientConverterUtil.getValueFromSlots(dataElement.getSlots(), "DKTK_ID");
        }
        return dktkId;
    }
}

