/*
 * Decompiled with CFR 0.152.
 */
package de.samply.dktk.converter;

import com.google.common.base.Joiner;
import com.google.common.collect.TreeTraverser;
import de.samply.common.mdrclient.MdrClient;
import de.samply.common.mdrclient.MdrConnectionException;
import de.samply.common.mdrclient.MdrInvalidResponseException;
import de.samply.common.mdrclient.domain.DataElement;
import de.samply.common.mdrclient.domain.Meaning;
import de.samply.common.mdrclient.domain.PermissibleValue;
import de.samply.common.mdrclient.domain.Slot;
import de.samply.common.mdrclient.domain.Validations;
import de.samply.dktk.converter.PatientAttributeOperator;
import de.samply.dktk.converter.PatientConverterException;
import de.samply.dktk.converter.sort.mdr.SortRules;
import de.samply.share.common.utils.MdrIdDatatype;
import de.samply.share.model.ccp.Attribute;
import de.samply.share.model.ccp.Case;
import de.samply.share.model.ccp.Contact;
import de.samply.share.model.ccp.Container;
import de.samply.share.model.ccp.Inquiry;
import de.samply.share.model.ccp.Sample;
import de.samply.share.model.common.Patient;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.SheetUtil;

public class PatientConverterUtil {
    private static final Logger logger = LogManager.getLogger(PatientConverterUtil.class);

    public static Map<String, String> getValuesAndDesignations(MdrClient mdrClient, String mdrKey, String languageCode, boolean includeIdentical) {
        try {
            DataElement dataElement = mdrClient.getDataElement(mdrKey, languageCode);
            Validations validations = dataElement.getValidation();
            String dataType = validations.getDatatype();
            if (dataType.equalsIgnoreCase("enumerated")) {
                HashMap<String, String> valueAndDesignationMap = new HashMap<String, String>();
                List permissibleValues = validations.getPermissibleValues();
                for (PermissibleValue pv : permissibleValues) {
                    List meanings = pv.getMeanings();
                    for (Meaning m : meanings) {
                        if (!m.getLanguage().equalsIgnoreCase(languageCode) || !includeIdentical && pv.getValue().equals(m.getDesignation())) continue;
                        valueAndDesignationMap.put(pv.getValue(), m.getDesignation());
                    }
                }
                return valueAndDesignationMap;
            }
            return null;
        }
        catch (MdrConnectionException | MdrInvalidResponseException | ExecutionException e) {
            return null;
        }
    }

    public static String getValueFromSlots(List<Slot> slots, String key) {
        for (Slot slot : slots) {
            if (!slot.getSlotName().trim().equalsIgnoreCase(key)) continue;
            return slot.getSlotValue();
        }
        return null;
    }

    public static Date convertDate(String dateString, SimpleDateFormat simpleDateFormat) throws ParseException {
        return simpleDateFormat.parse(dateString);
    }

    public static Workbook freezeHeaderRows(Workbook workBook) {
        for (int i = 0; i < workBook.getNumberOfSheets(); ++i) {
            Sheet sheet = workBook.getSheetAt(i);
            sheet.createFreezePane(0, 3);
        }
        return workBook;
    }

    public static String getOldestDateString(MdrClient mdrClient, de.samply.share.model.common.Container patient, MdrIdDatatype mdrId) throws PatientConverterException {
        TreeTraverser<de.samply.share.model.common.Container> containerTraverser = new TreeTraverser<de.samply.share.model.common.Container>(){

            public Iterable<de.samply.share.model.common.Container> children(de.samply.share.model.common.Container root) {
                return root.getContainer();
            }
        };
        SimpleDateFormat dateFormat = null;
        try {
            DataElement dataElement = mdrClient.getDataElement(mdrId.getLatestMdr(), "en");
            List dataElementSlots = dataElement.getSlots();
            String dateFormatString = PatientConverterUtil.getValueFromSlots(dataElementSlots, "JAVA_DATE_FORMAT");
            if (dateFormatString != null) {
                dateFormat = new SimpleDateFormat(dateFormatString);
            }
        }
        catch (MdrConnectionException | MdrInvalidResponseException | ExecutionException e) {
            logger.warn("Could not get dataelement slots for " + mdrId.toString());
        }
        if (dateFormat == null) {
            return null;
        }
        ArrayList<Date> dates = new ArrayList<Date>();
        for (de.samply.share.model.common.Container container : containerTraverser.preOrderTraversal((Object)patient)) {
            for (de.samply.share.model.common.Attribute attribute : container.getAttribute()) {
                MdrIdDatatype attributeKey = new MdrIdDatatype(attribute.getMdrKey());
                if (!mdrId.equalsIgnoreVersion((Object)attributeKey)) continue;
                try {
                    dates.add(PatientConverterUtil.convertDate((String)attribute.getValue().getValue(), dateFormat));
                }
                catch (ParseException e) {
                    throw new PatientConverterException(e);
                }
            }
        }
        if (dates.isEmpty()) {
            return null;
        }
        return dateFormat.format((Date)Collections.min(dates));
    }

    static boolean isLeaf(Container container) {
        List children = container.getContainer();
        if (children == null || children.size() < 1) {
            return true;
        }
        for (Container c : children) {
            if (c.getDesignation().equalsIgnoreCase("Sample")) continue;
            return false;
        }
        return true;
    }

    static int getCellIndex(String header, Row headerRow) {
        for (Cell cell : headerRow) {
            if (!cell.getStringCellValue().contains(header)) continue;
            return cell.getColumnIndex();
        }
        return -1;
    }

    public static Sheet sortSheet(Workbook workbook, int sheetIndex, SortRules sortRules) {
        Sheet sheet = workbook.getSheetAt(sheetIndex);
        if (sheet == null) {
            return sheet;
        }
        TreeMap<String, Integer> mdrIdColumnMap = new TreeMap<String, Integer>();
        Row headerRow = sheet.getRow(0);
        HashSet<Integer> excludedColumns = new HashSet<Integer>();
        for (int i = headerRow.getFirstCellNum(); i <= headerRow.getLastCellNum(); ++i) {
            Cell cell = i < 0 ? null : headerRow.getCell(i);
            if (cell == null) continue;
            String cellValue = cell.getStringCellValue();
            if (PatientConverterUtil.isUrn(cellValue)) {
                mdrIdColumnMap.put(cellValue, i);
                continue;
            }
            excludedColumns.add(i);
        }
        List<String> mdrIdsList = new ArrayList<String>();
        mdrIdsList.addAll(mdrIdColumnMap.keySet());
        if (mdrIdsList.size() > 0) {
            mdrIdsList = sortRules.sortMdrIds(mdrIdsList);
            int offset = headerRow.getFirstCellNum();
            for (int i = 0; i < mdrIdsList.size(); ++i) {
                String mdrId = mdrIdsList.get(i);
                int toGrab = (Integer)mdrIdColumnMap.get(mdrId);
                while (excludedColumns.contains(i + offset)) {
                    ++offset;
                }
                int target = i + offset;
                if (toGrab == target) continue;
                PatientConverterUtil.swapColumns(sheet, toGrab, target);
                PatientConverterUtil.updateMdrIdColumnMap(mdrIdColumnMap, toGrab, target);
            }
        }
        return sheet;
    }

    private static boolean isUrn(String element) {
        return element != null && element.startsWith("urn");
    }

    private static void updateMdrIdColumnMap(Map<String, Integer> mdrIdColumnMap, int changedColumn1, int changedColumn2) {
        for (Map.Entry<String, Integer> entry : mdrIdColumnMap.entrySet()) {
            if (entry.getValue() == changedColumn1) {
                entry.setValue(changedColumn2);
                continue;
            }
            if (entry.getValue() != changedColumn2) continue;
            entry.setValue(changedColumn1);
        }
    }

    private static void swapColumns(Sheet sheet, int columnA, int columnB) {
        if (sheet == null) {
            return;
        }
        if (columnA == columnB) {
            logger.trace("Both row indices are identical. No modifications needed.");
            return;
        }
        if (sheet == null || columnA < 0 || columnB < 0) {
            throw new IllegalArgumentException("An excel sheet has to be provided and the row indices have to be positive integers");
        }
        Row headerRow = sheet.getRow(0);
        short maxCellNum = headerRow.getLastCellNum();
        if (maxCellNum < columnA || maxCellNum < columnB) {
            throw new IndexOutOfBoundsException("One of the given columns exceeds the maximum. Max=" + maxCellNum + ";a=" + columnA + ";b=" + columnB);
        }
        CellStyle defaultCellstyle = sheet.getWorkbook().createCellStyle();
        for (int i = sheet.getFirstRowNum(); i <= sheet.getLastRowNum(); ++i) {
            Row row;
            Cell a = SheetUtil.getCellWithMerges((Sheet)sheet, (int)i, (int)columnA);
            Cell b = SheetUtil.getCellWithMerges((Sheet)sheet, (int)i, (int)columnB);
            if (a != null && b != null) {
                String tmp = b.getStringCellValue();
                b.setCellValue(a.getStringCellValue());
                b.setCellStyle(a.getCellStyle());
                a.setCellValue(tmp);
                CellStyle tmpStyle = b.getCellStyle();
                a.setCellStyle(tmpStyle);
            } else if (a == null && b != null) {
                row = sheet.getRow(i);
                a = row.createCell(columnA);
                a.setCellValue(b.getStringCellValue());
                a.setCellStyle(b.getCellStyle());
                b.setCellType(CellType.BLANK);
                b.setCellStyle(defaultCellstyle);
            } else {
                if (a == null || b != null) continue;
                row = sheet.getRow(i);
                b = row.createCell(columnB);
                b.setCellValue(a.getStringCellValue());
                b.setCellStyle(a.getCellStyle());
                a.setCellType(CellType.BLANK);
                a.setCellStyle(defaultCellstyle);
            }
            if (i == 0) {
                Hyperlink hyperlinkA = a.getHyperlink();
                Hyperlink hyperlinkB = b.getHyperlink();
                if (hyperlinkA != null && hyperlinkB != null) {
                    a.setHyperlink(hyperlinkB);
                    b.setHyperlink(hyperlinkA);
                } else if (hyperlinkA == null && hyperlinkB != null) {
                    a.setHyperlink(hyperlinkB);
                    b.removeHyperlink();
                } else if (hyperlinkA != null && hyperlinkB == null) {
                    b.setHyperlink(hyperlinkA);
                    a.removeHyperlink();
                }
            }
            if (i != 1) continue;
            Comment commentA = a.getCellComment();
            Comment commentB = b.getCellComment();
            if (commentA != null && commentB != null) {
                a.setCellComment(commentB);
                b.setCellComment(commentA);
                continue;
            }
            if (commentA == null && commentB != null) {
                a.setCellComment(commentB);
                b.removeCellComment();
                continue;
            }
            if (commentA == null || commentB != null) continue;
            b.setCellComment(commentA);
            a.removeCellComment();
        }
    }

    public static void addCellComments(MdrClient mdrClient, Workbook workbook) {
        Iterator sheetIterator = workbook.sheetIterator();
        while (sheetIterator.hasNext()) {
            Sheet sheet = (Sheet)sheetIterator.next();
            if (sheet.getSheetName() == null || sheet.getSheetName().equalsIgnoreCase("info")) continue;
            Row keyRow = sheet.getRow(0);
            Row destinationRow = sheet.getRow(1);
            Iterator cellIterator = destinationRow.cellIterator();
            while (cellIterator.hasNext()) {
                Cell cell = (Cell)cellIterator.next();
                String mdrKey = keyRow.getCell(cell.getColumnIndex()).getStringCellValue();
                if (mdrKey == null) continue;
                if (mdrKey.startsWith("urn:dktk:dataelement:43")) {
                    PatientConverterUtil.addCommentToCell(cell, "Entspricht dem Datum, an welchem dieses Ergebnis befundet wurde");
                    continue;
                }
                if (mdrKey.startsWith("urn:dktk:dataelement:50")) {
                    PatientConverterUtil.addCommentToCell(cell, "Gibt an, ob Probe vorhanden ist");
                    continue;
                }
                PatientConverterUtil.addValueDesignationListCommentToCell(mdrClient, cell, mdrKey);
            }
        }
    }

    public static Cell addValueDesignationListCommentToCell(MdrClient mdrClient, Cell cell, String mdrKey) {
        Row row = cell.getRow();
        Sheet sheet = row.getSheet();
        Workbook workBook = sheet.getWorkbook();
        Map<String, String> valueDesignationMap = PatientConverterUtil.getValuesAndDesignations(mdrClient, mdrKey, "de", false);
        if (valueDesignationMap == null || valueDesignationMap.isEmpty()) {
            return cell;
        }
        Joiner.MapJoiner mapJoiner = Joiner.on((char)'\n').withKeyValueSeparator(" -> ");
        String commentString = mapJoiner.join(valueDesignationMap);
        int listLength = valueDesignationMap.size();
        CreationHelper factory = workBook.getCreationHelper();
        Drawing drawing = sheet.createDrawingPatriarch();
        ClientAnchor anchor = factory.createClientAnchor();
        anchor.setCol1(cell.getColumnIndex());
        anchor.setCol2(cell.getColumnIndex() + 3);
        anchor.setRow1(row.getRowNum());
        anchor.setRow2(row.getRowNum() + listLength);
        Comment comment = drawing.createCellComment(anchor);
        RichTextString str = factory.createRichTextString(commentString);
        comment.setAuthor("Samply.Share.Client");
        comment.setString(str);
        cell.setCellComment(comment);
        return cell;
    }

    public static Cell addCommentToCell(Cell cell, String commentString) {
        Row row = cell.getRow();
        Sheet sheet = row.getSheet();
        Workbook workBook = sheet.getWorkbook();
        CreationHelper factory = workBook.getCreationHelper();
        Drawing drawing = sheet.createDrawingPatriarch();
        ClientAnchor anchor = factory.createClientAnchor();
        anchor.setCol1(cell.getColumnIndex());
        anchor.setCol2(cell.getColumnIndex() + 3);
        anchor.setRow1(row.getRowNum());
        anchor.setRow2(row.getRowNum() + 2);
        Comment comment = drawing.createCellComment(anchor);
        RichTextString str = factory.createRichTextString(commentString);
        comment.setAuthor("Samply.Share.Client");
        comment.setString(str);
        cell.setCellComment(comment);
        return cell;
    }

    public static Inquiry createInquiryObjectForInfoSheet(String inquiryLabel, String inquiryDescription) {
        Inquiry inquiry = new Inquiry();
        inquiry.setLabel(inquiryLabel);
        inquiry.setDescription(inquiryDescription);
        return inquiry;
    }

    public static Contact createContactObjectForInfoSheet(String contactTitle, String contactFirstname, String contactLastname) {
        Contact contact = new Contact();
        contact.setTitle(contactTitle);
        contact.setFirstname(contactFirstname);
        contact.setLastname(contactLastname);
        return contact;
    }

    public static de.samply.share.model.ccp.Patient removeAttributeFromPatient(de.samply.share.model.ccp.Patient patient, String attributeString) {
        PatientAttributeRemover patientAttributeRemover = new PatientAttributeRemover(patient, attributeString);
        return patientAttributeRemover.remove();
    }

    public static de.samply.share.model.ccp.Patient removeAttributeFromCases(de.samply.share.model.ccp.Patient patient, String attributeString) {
        for (Case caseCcp : patient.getCase()) {
            Iterator attributeIterator = caseCcp.getAttribute().iterator();
            while (attributeIterator.hasNext()) {
                Attribute attribute = (Attribute)attributeIterator.next();
                if (!attribute.getMdrKey().equalsIgnoreCase(attributeString)) continue;
                attributeIterator.remove();
            }
        }
        return patient;
    }

    public static de.samply.share.model.ccp.Patient removeAttributeFromSamples(de.samply.share.model.ccp.Patient patient, String attributeString) {
        for (Sample sample : patient.getSample()) {
            Iterator attributeIterator = sample.getAttribute().iterator();
            while (attributeIterator.hasNext()) {
                Attribute attribute = (Attribute)attributeIterator.next();
                if (!attribute.getMdrKey().equalsIgnoreCase(attributeString)) continue;
                attributeIterator.remove();
            }
        }
        return patient;
    }

    private static int getColumnIndex(Sheet sheet, String dataElementUrn) {
        Row headerRow = sheet.getRow(0);
        for (int i = 0; i < headerRow.getPhysicalNumberOfCells(); ++i) {
            Cell cell = headerRow.getCell(i);
            if (cell.getStringCellValue() == null || !cell.getStringCellValue().startsWith(dataElementUrn)) continue;
            return cell.getColumnIndex();
        }
        return -1;
    }

    protected static void autosizeAllColumns(Workbook workBook) {
        for (int i = 0; i < workBook.getNumberOfSheets(); ++i) {
            Sheet sheet = workBook.getSheetAt(i);
            Row headerRow = sheet.getRow(0);
            if (headerRow == null) continue;
            for (int j = 0; j <= headerRow.getLastCellNum(); ++j) {
                sheet.autoSizeColumn(j);
            }
        }
    }

    protected static void addAutoFilter(Workbook workbook, int sheetIndex) {
        Sheet sheet = workbook.getSheetAt(sheetIndex);
        int rowStartIndex = 2;
        int rowEndIndex = sheet.getLastRowNum();
        int columnStartIndex = 0;
        int columnEndIndex = sheet.getRow(0).getLastCellNum() - 1;
        CellRangeAddress cra = new CellRangeAddress(rowStartIndex, rowEndIndex, columnStartIndex, columnEndIndex);
        sheet.setAutoFilter(cra);
    }

    public static boolean isBlacklisted(List<MdrIdDatatype> blacklist, MdrIdDatatype attributeKey) {
        for (MdrIdDatatype entry : blacklist) {
            if (!entry.equalsIgnoreVersion((Object)attributeKey)) continue;
            return true;
        }
        return false;
    }

    static de.samply.share.model.common.Container createPatientContainer(Patient patient) {
        de.samply.share.model.common.Container patientContainer = new de.samply.share.model.common.Container();
        patientContainer.getAttribute().addAll(patient.getAttribute());
        patientContainer.getContainer().addAll(patient.getContainer());
        return patientContainer;
    }

    public static String getFirstValueForKey(Patient patient, MdrIdDatatype key) {
        TreeTraverser<de.samply.share.model.common.Container> containerTraverser = new TreeTraverser<de.samply.share.model.common.Container>(){

            public Iterable<de.samply.share.model.common.Container> children(de.samply.share.model.common.Container root) {
                return root.getContainer();
            }
        };
        de.samply.share.model.common.Container patientContainer = PatientConverterUtil.createPatientContainer(patient);
        for (de.samply.share.model.common.Container container : containerTraverser.breadthFirstTraversal((Object)patientContainer)) {
            for (de.samply.share.model.common.Attribute attribute : container.getAttribute()) {
                MdrIdDatatype attributeKey = new MdrIdDatatype(attribute.getMdrKey());
                if (!attributeKey.equalsIgnoreVersion((Object)key)) continue;
                return (String)attribute.getValue().getValue();
            }
        }
        return null;
    }

    private static class PatientAttributeRemover
    extends PatientAttributeOperator {
        private String attributeToBeRemoved;
        private de.samply.share.model.ccp.Patient patient;

        public PatientAttributeRemover(de.samply.share.model.ccp.Patient patient, String attributeToBeRemoved) {
            this.patient = patient;
            this.attributeToBeRemoved = this.getMajorMdrId(attributeToBeRemoved);
        }

        private String getMajorMdrId(Attribute attribute) {
            String mdrKey = attribute.getMdrKey();
            mdrKey = this.getMajorMdrId(mdrKey);
            return mdrKey;
        }

        private String getMajorMdrId(String urn) {
            if (urn != null) {
                MdrIdDatatype mdrId = new MdrIdDatatype(urn);
                urn = mdrId.getMajor();
            }
            return urn;
        }

        @Override
        protected Attribute operateAttribute(Attribute attribute) {
            return this.getMajorMdrId(attribute).equalsIgnoreCase(this.attributeToBeRemoved) ? null : attribute;
        }

        public de.samply.share.model.ccp.Patient remove() {
            return this.operateAttributes(this.patient);
        }
    }
}

