/*
 * Decompiled with CFR 0.152.
 */
package de.samply.dktk.converter;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.TreeTraverser;
import de.dth.mdr.validator.MdrValidator;
import de.dth.mdr.validator.exception.ValidatorException;
import de.samply.common.mdrclient.MdrClient;
import de.samply.common.mdrclient.MdrConnectionException;
import de.samply.common.mdrclient.MdrInvalidResponseException;
import de.samply.common.mdrclient.domain.DataElement;
import de.samply.common.mdrclient.domain.Designation;
import de.samply.common.mdrclient.domain.Slot;
import de.samply.common.mdrclient.domain.Validations;
import de.samply.dktk.converter.Constants;
import de.samply.dktk.converter.DiagnosisConverter;
import de.samply.dktk.converter.EnumValidationHandling;
import de.samply.dktk.converter.PatientConverterException;
import de.samply.dktk.converter.PatientConverterUtil;
import de.samply.dktk.converter.sort.container.DktkSortRules;
import de.samply.dktk.converter.sort.container.SortRules;
import de.samply.dktk.converter.sort.mdr.GbaSortRules;
import de.samply.share.common.utils.MdrIdDatatype;
import de.samply.share.common.utils.PercentageLogger;
import de.samply.share.model.bbmri.BbmriResult;
import de.samply.share.model.ccp.Attribute;
import de.samply.share.model.ccp.Case;
import de.samply.share.model.ccp.Contact;
import de.samply.share.model.ccp.Container;
import de.samply.share.model.ccp.Inquiry;
import de.samply.share.model.ccp.ObjectFactory;
import de.samply.share.model.ccp.QueryResult;
import de.samply.share.model.ccp.Sample;
import de.samply.share.model.common.Ref;
import de.samply.share.model.osse.Patient;
import de.samply.share.utils.Converter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.ss.util.WorkbookUtil;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class PatientConverter {
    private static final Logger logger = LogManager.getLogger(PatientConverter.class);
    private static final int WORKBOOK_WINDOW = 30000000;
    private static CellStyle validationErrorCellStyle;
    private int workbookWindow;
    private MdrClient mdrClient;
    private String mdrLinkUrl;
    private String mdrLinkPath = "/detail.xhtml?urn=";
    private EnumValidationHandling validationHandling;
    private MdrValidator validator;
    private List<MdrIdDatatype> blacklist;
    private Object queryTyp;
    private Map<String, Integer> runningEntityIds = new HashMap<String, Integer>();
    private int runningPatientId;

    public PatientConverter(MdrClient mdrClient) {
        this(mdrClient, new ArrayList<MdrIdDatatype>(), 30000000);
    }

    public PatientConverter(MdrClient mdrClient, Integer workbookWindow) {
        this(mdrClient, new ArrayList<MdrIdDatatype>(), workbookWindow);
    }

    public PatientConverter(MdrClient mdrClient, List<MdrIdDatatype> blacklist) {
        this(mdrClient, blacklist, 30000000);
    }

    public PatientConverter(MdrClient mdrClient, List<MdrIdDatatype> blacklist, Integer workbookWindow) {
        this(mdrClient, null, EnumValidationHandling.NO_VALIDATION, blacklist, workbookWindow);
    }

    public PatientConverter(MdrClient mdrClient, MdrValidator validator) {
        this(mdrClient, validator, EnumValidationHandling.REMOVE_INVALID_ENTRIES);
    }

    public PatientConverter(MdrClient mdrClient, MdrValidator validator, EnumValidationHandling validationHandling) {
        this(mdrClient, validator, validationHandling, new ArrayList<MdrIdDatatype>(), 30000000);
    }

    public PatientConverter(MdrClient mdrClient, MdrValidator validator, EnumValidationHandling validationHandling, List<MdrIdDatatype> blacklist) {
        this(mdrClient, validator, validationHandling, blacklist, 30000000);
    }

    public PatientConverter(MdrClient mdrClient, MdrValidator validator, EnumValidationHandling validationHandling, List<MdrIdDatatype> blacklist, Integer workbookWindow) {
        this.mdrClient = mdrClient;
        this.validationHandling = validationHandling;
        this.validator = validator;
        this.blacklist = blacklist;
        this.workbookWindow = workbookWindow != null ? workbookWindow : 30000000;
        URI mdrBaseUri = mdrClient.getBaseUri();
        this.mdrLinkUrl = mdrBaseUri.getScheme() + "://" + mdrBaseUri.getHost();
    }

    private static void createInfoSheet(Workbook workBook, Object queryResult, Inquiry inquiry, Contact contact, String siteName, String executionDateString, EnumValidationHandling validationHandling) {
        QueryResult queryResult1;
        CellStyle cs = workBook.createCellStyle();
        cs.setWrapText(true);
        Font headerFont = workBook.createFont();
        headerFont.setFontHeightInPoints((short)24);
        headerFont.setBold(true);
        CellStyle headerStyle = workBook.createCellStyle();
        headerStyle.setFont(headerFont);
        Sheet infoSheet = workBook.createSheet("Info");
        if (infoSheet instanceof SXSSFSheet) {
            ((SXSSFSheet)infoSheet).trackAllColumnsForAutoSizing();
        }
        Row headerRow = infoSheet.createRow(0);
        headerRow.setHeightInPoints(24.0f);
        Cell headerCell = headerRow.createCell(0);
        headerCell.setCellStyle(headerStyle);
        headerCell.setCellValue("Daten-Export aus Br\u00fcckenkopf");
        Row contentRow = infoSheet.createRow(1);
        contentRow.setHeightInPoints(14.0f * infoSheet.getDefaultRowHeightInPoints());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Dies ist ein automatischer Datenexport aus dem DKTK-Br\u00fcckenkopf am Standort " + siteName + ", der am " + executionDateString + " zur Beantwortung der folgenden Suchanfrage erzeugt wurde:\n\n");
        stringBuilder.append("Name der Anfrage: " + inquiry.getLabel() + "\n");
        if (queryResult instanceof QueryResult) {
            queryResult1 = (QueryResult)queryResult;
            stringBuilder.append("Anzahl der Ergebnisse: " + queryResult1.getPatient().size() + "\n");
        } else if (queryResult instanceof BbmriResult) {
            queryResult1 = (BbmriResult)queryResult;
            stringBuilder.append("Anzahl der Ergebnisse: " + queryResult1.getDonors().size() + "\n");
        }
        stringBuilder.append("Kontaktperson: ");
        if (contact.getTitle() != null && contact.getTitle().length() > 0) {
            stringBuilder.append(contact.getTitle() + " ");
        }
        stringBuilder.append(contact.getFirstname() + " " + contact.getLastname() + "\n");
        stringBuilder.append("Beschreibung: " + inquiry.getDescription() + "\n");
        stringBuilder.append("Syntaktische Validierung: ");
        switch (validationHandling) {
            case KEEP_INVALID_ENTRIES: {
                stringBuilder.append("Werte, die nicht konform zu den im MDR hinterlegten Validierungsinformationen sind, sind in diesem Dokument orange hinterlegt.");
                break;
            }
            case REMOVE_INVALID_ENTRIES: {
                stringBuilder.append("Werte, die nicht konform zu den im MDR hinterlegten Validierungsinformationen sind, wurden aus diesem Dokument entfernt.");
                break;
            }
            default: {
                stringBuilder.append("Es fand keine Validierung der Werte statt. Dieses Dokument kann deshalb Eintr\u00e4ge enthalten, die nicht konform zu den im MDR hinterlegten Validierungsinformationen sind.");
            }
        }
        stringBuilder.append("\n\nVor Verwendung der Datei beachten Sie unbedingt:\n");
        stringBuilder.append("1. Bitte stellen Sie sicher, dass organisatorische Rahmenbedingungen f\u00fcr den Export gegeben sind (insb. Zustimmung der Datenbesitzer und des Datenschutzes).\n");
        stringBuilder.append("2. Es handelt sich um ein experimentelles, noch in der Erprobung befindliches Feature. Technische Fehler sind nicht ausgeschlossen. Im Zweifel konsultieren Sie die Quelldatenbank.\n");
        stringBuilder.append("3. Die exportierten Daten haben eine sehr hohe Pr\u00e4zision. Es wurden keine Ma\u00dfnahmen zur Anonymisierung vorgenommen. Bitte pr\u00fcfen Sie die Ausgabe und anonymisieren Sie die Daten ggfls. selbst, um eine unerlaubte Reidentifikation von Patienten/Probanden auszuschlie\u00dfen.\n");
        stringBuilder.append("\nBei Fragen wenden Sie sich bitte an Ihren Standortvertreter der Arbeitsgruppe CCP-IT.");
        Cell contentCell = contentRow.createCell(0);
        contentCell.setCellValue(stringBuilder.toString());
        contentCell.setCellStyle(cs);
        CellRangeAddress region = new CellRangeAddress(0, 1, 0, 0);
        RegionUtil.setBorderBottom((BorderStyle)BorderStyle.THICK, (CellRangeAddress)region, (Sheet)infoSheet);
        RegionUtil.setBorderTop((BorderStyle)BorderStyle.THICK, (CellRangeAddress)region, (Sheet)infoSheet);
        RegionUtil.setBorderLeft((BorderStyle)BorderStyle.THICK, (CellRangeAddress)region, (Sheet)infoSheet);
        RegionUtil.setBorderRight((BorderStyle)BorderStyle.THICK, (CellRangeAddress)region, (Sheet)infoSheet);
    }

    private static ArrayList<String> splitParentRef(de.samply.share.model.common.Container container) {
        try {
            for (Ref ref : container.getRef()) {
                for (String entityId : ref.getEntityId()) {
                    ArrayList splitRef = Lists.newArrayList((Iterable)Splitter.on((char)':').split((CharSequence)entityId));
                    if (!((String)splitRef.get(0)).equals("PARENT")) continue;
                    return splitRef;
                }
            }
        }
        catch (IndexOutOfBoundsException | NullPointerException e) {
            System.out.println("No parent reference found");
        }
        return null;
    }

    private static List<de.samply.share.model.common.Container> transformQueryResultToContainerList(Object queryResult) {
        ArrayList<de.samply.share.model.common.Container> list = new ArrayList<de.samply.share.model.common.Container>();
        de.samply.share.model.common.Container patientContainer = null;
        if (queryResult instanceof QueryResult) {
            QueryResult queryResult1 = (QueryResult)queryResult;
            for (de.samply.share.model.ccp.Patient patient : queryResult1.getPatient()) {
                try {
                    patientContainer = PatientConverterUtil.createPatientContainer(Converter.convertCcpPatientToCommonPatient((de.samply.share.model.ccp.Patient)patient));
                }
                catch (JAXBException e) {
                    e.printStackTrace();
                }
                patientContainer.setId(patient.getId());
                patientContainer.setDesignation("Patient");
                list.add(patientContainer);
            }
            return list;
        }
        if (queryResult instanceof BbmriResult) {
            BbmriResult queryResult1 = (BbmriResult)queryResult;
            for (Patient patient : queryResult1.getDonors()) {
                try {
                    patientContainer = PatientConverterUtil.createPatientContainer(Converter.convertOssePatientToCommonPatient((Patient)patient));
                }
                catch (JAXBException e) {
                    e.printStackTrace();
                }
                patientContainer.setId(patient.getId());
                patientContainer.setDesignation("Patient");
                list.add(patientContainer);
            }
            return list;
        }
        return null;
    }

    private Integer getRunningEntityId(String entity) {
        Integer runningEntityId = this.runningEntityIds.get(entity);
        if (runningEntityId == null) {
            runningEntityId = 1;
            this.runningEntityIds.put(entity, runningEntityId);
        }
        return runningEntityId;
    }

    private void incrementRunningEntityId(String entity) {
        Integer runningEntityId;
        Integer n = runningEntityId = this.getRunningEntityId(entity);
        Integer n2 = runningEntityId = Integer.valueOf(runningEntityId + 1);
        this.runningEntityIds.put(entity, runningEntityId);
    }

    private String getRunningEntityIdName(String entity) {
        return entity.substring(0, 3);
    }

    public List<MdrIdDatatype> getBlacklist() {
        return this.blacklist;
    }

    public void setBlacklist(List<MdrIdDatatype> blacklist) {
        this.blacklist = blacklist;
    }

    public de.samply.share.model.ccp.Patient centraxxToCentralsearch(de.samply.share.model.ccp.Patient centraxxPatient) {
        Container patientContainer = null;
        try {
            patientContainer = Converter.convertCommonContainerToCcpContainer((de.samply.share.model.common.Container)PatientConverterUtil.createPatientContainer(Converter.convertCcpPatientToCommonPatient((de.samply.share.model.ccp.Patient)centraxxPatient)));
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        de.samply.share.model.ccp.Patient centralSearchPatient = this.traversePatientContainer(patientContainer);
        centralSearchPatient.setId(centraxxPatient.getId());
        centralSearchPatient.setCentraxxId(centraxxPatient.getCentraxxId());
        centralSearchPatient.setDktkId(centraxxPatient.getDktkId());
        return centralSearchPatient;
    }

    private de.samply.share.model.ccp.Patient traversePatientContainer(Container patientContainer) {
        TreeTraverser<Container> containerTraverser = new TreeTraverser<Container>(){

            public Iterable<Container> children(Container root) {
                ArrayList<Container> children = new ArrayList<Container>();
                for (Container c : root.getContainer()) {
                    if (c.getDesignation().equalsIgnoreCase("Diagnosis")) {
                        de.samply.share.model.ccp.Ref selfRef = new de.samply.share.model.ccp.Ref();
                        selfRef.getEntityId().add("Diagnosis:" + c.getId());
                        c.getRef().add(selfRef);
                    }
                    if (!c.getDesignation().equalsIgnoreCase("Sample")) {
                        c.getAttribute().addAll(root.getAttribute());
                        c.getRef().addAll(root.getRef());
                    }
                    children.add(c);
                }
                return children;
            }
        };
        de.samply.share.model.ccp.Patient patient = new de.samply.share.model.ccp.Patient();
        for (Container container : containerTraverser.breadthFirstTraversal((Object)patientContainer)) {
            if (!PatientConverterUtil.isLeaf(container)) continue;
            if (container.getDesignation().equalsIgnoreCase("Sample")) {
                Sample sample = new Sample();
                sample.setId(container.getId());
                sample.getAttribute().addAll(container.getAttribute());
                sample.getRef().addAll(container.getRef());
                patient.getSample().add(sample);
                continue;
            }
            Case caseCcp = new Case();
            caseCcp.setId(container.getId());
            caseCcp.getAttribute().addAll(container.getAttribute());
            caseCcp.getRef().addAll(container.getRef());
            patient.getCase().add(caseCcp);
        }
        return this.linkRefs(patient);
    }

    private de.samply.share.model.ccp.Patient linkRefs(de.samply.share.model.ccp.Patient sourcePatient) {
        for (Sample sample : sourcePatient.getSample()) {
            String designation;
            if (sample.getRef().isEmpty() || (designation = (String)((de.samply.share.model.ccp.Ref)sample.getRef().get(0)).getEntityId().get(0)) == null || !designation.contains(":")) continue;
            sample.getRef().clear();
            de.samply.share.model.ccp.Ref newRef = new de.samply.share.model.ccp.Ref();
            for (Case caseCcp : sourcePatient.getCase()) {
                for (de.samply.share.model.ccp.Ref ref : caseCcp.getRef()) {
                    for (String entityId : ref.getEntityId()) {
                        if (!entityId.equalsIgnoreCase(designation)) continue;
                        newRef.getEntityId().add("Case:" + caseCcp.getId());
                    }
                }
            }
            sample.getRef().add(newRef);
        }
        for (Case caseCcp : sourcePatient.getCase()) {
            caseCcp.getRef().clear();
        }
        return sourcePatient;
    }

    public QueryResult unmarshalInputStream(InputStream in) throws JAXBException {
        try {
            StreamSource source = new StreamSource(in);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{QueryResult.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            JAXBElement qrElement = unmarshaller.unmarshal((Source)source, QueryResult.class);
            return (QueryResult)qrElement.getValue();
        }
        catch (ClassCastException e) {
            logger.error(e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public de.samply.share.model.ccp.Patient removeAttributes(de.samply.share.model.ccp.Patient patient, List<String> attributes) {
        Attribute attribute;
        Iterator attributeIterator;
        ObjectFactory objectFactory = new ObjectFactory();
        for (Case caseCcp : patient.getCase()) {
            attributeIterator = caseCcp.getAttribute().iterator();
            while (attributeIterator.hasNext()) {
                attribute = (Attribute)attributeIterator.next();
                if (!attributes.contains(attribute.getMdrKey())) continue;
                if (attribute.getMdrKey().equalsIgnoreCase("urn:dktk:dataelement:29:2") || attribute.getMdrKey().equalsIgnoreCase("urn:dktk:dataelement:57:2") || attribute.getMdrKey().equalsIgnoreCase("urn:dktk:dataelement:58:2") || attribute.getMdrKey().equalsIgnoreCase("urn:dktk:dataelement:4:2")) {
                    attribute.setValue(objectFactory.createValue(((String)attribute.getValue().getValue()).toUpperCase()));
                    continue;
                }
                attributeIterator.remove();
            }
        }
        for (Sample sample : patient.getSample()) {
            attributeIterator = sample.getAttribute().iterator();
            while (attributeIterator.hasNext()) {
                attribute = (Attribute)attributeIterator.next();
                if (!attributes.contains(attribute.getMdrKey())) continue;
                if (attribute.getMdrKey().equalsIgnoreCase("urn:dktk:dataelement:29:2") || attribute.getMdrKey().equalsIgnoreCase("urn:dktk:dataelement:57:2") || attribute.getMdrKey().equalsIgnoreCase("urn:dktk:dataelement:58:2") || attribute.getMdrKey().equalsIgnoreCase("urn:dktk:dataelement:4:2")) {
                    attribute.setValue(objectFactory.createValue(((String)attribute.getValue().getValue()).toUpperCase()));
                    continue;
                }
                attributeIterator.remove();
            }
        }
        return patient;
    }

    public String centraxxQueryResultToExcel(QueryResult queryResult, Inquiry inquiry, Contact contact, String siteName, String executionDateString, File destinationFolder) throws PatientConverterException {
        Workbook workBook = this.centraxxQueryResultToExcel(queryResult, inquiry, contact, siteName, executionDateString);
        try {
            String filename = destinationFolder + File.separator + queryResult.getId() + ".xlsx";
            FileOutputStream fileOut = new FileOutputStream(filename);
            workBook.write((OutputStream)fileOut);
            fileOut.close();
            workBook.close();
            return filename;
        }
        catch (IOException e) {
            throw new PatientConverterException(e);
        }
    }

    public Workbook centraxxQueryResultToExcel(QueryResult queryResult, Inquiry inquiry, Contact contact, String siteName, String executionDateString) throws PatientConverterException {
        this.runningPatientId = 1;
        this.runningEntityIds = new HashMap<String, Integer>();
        this.queryTyp = queryResult;
        SXSSFWorkbook workBook = new SXSSFWorkbook(this.workbookWindow);
        validationErrorCellStyle = workBook.createCellStyle();
        validationErrorCellStyle.setFillForegroundColor(IndexedColors.LIGHT_ORANGE.getIndex());
        validationErrorCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        PatientConverter.createInfoSheet((Workbook)workBook, queryResult, inquiry, contact, siteName, executionDateString, this.validationHandling);
        DktkSortRules sortRules = new DktkSortRules(this.mdrClient);
        List<de.samply.share.model.common.Container> containerList = PatientConverter.transformQueryResultToContainerList(queryResult);
        PercentageLogger percentageLogger = new PercentageLogger(logger, containerList.size(), "adding patients...");
        for (de.samply.share.model.common.Container patient : containerList) {
            percentageLogger.incrementCounter();
            this.addPatientDataToExcel((Workbook)workBook, patient, sortRules);
        }
        PatientConverterUtil.autosizeAllColumns((Workbook)workBook);
        percentageLogger = new PercentageLogger(logger, workBook.getNumberOfSheets(), "adding sheets...");
        for (int i = 1; i < workBook.getNumberOfSheets(); ++i) {
            percentageLogger.incrementCounter();
            PatientConverterUtil.addAutoFilter((Workbook)workBook, i);
            this.filterValueOfDatalement((Workbook)workBook, i, "urn:dktk:dataelement:50", "true");
            PatientConverterUtil.sortSheet((Workbook)workBook, i, new de.samply.dktk.converter.sort.mdr.DktkSortRules(this.mdrClient));
        }
        PatientConverterUtil.freezeHeaderRows((Workbook)workBook);
        PatientConverterUtil.addCellComments(this.mdrClient, (Workbook)workBook);
        return workBook;
    }

    private void filterValueOfDatalement(Workbook workbook, int sheetIndex, String mdrKey, String value) {
        Row headerRow;
        int columnIndex;
        Sheet sheet = workbook.getSheetAt(sheetIndex);
        if (sheet != null && (columnIndex = PatientConverterUtil.getCellIndex(mdrKey, headerRow = sheet.getRow(0))) >= 0) {
            this.filterValueInColumn(sheet, columnIndex, value);
        }
    }

    private void filterValueInColumn(Sheet sheet, int columnIndex, String value) {
        if (sheet != null && sheet instanceof SXSSFSheet) {
            for (Row row : sheet) {
                for (Cell c : row) {
                    SXSSFRow r1;
                    if (c.getColumnIndex() != columnIndex || c.getStringCellValue().equals(value) || (r1 = (SXSSFRow)c.getRow()).getRowNum() <= 2 || r1.getRowStyle() == null) continue;
                    r1.getRowStyle().setHidden(true);
                }
            }
        }
    }

    public Workbook biobanksQueryResultToExcel(BbmriResult queryResult, Inquiry inquiry, Contact contact, String siteName, String executionDateString) throws PatientConverterException {
        this.runningPatientId = 1;
        this.queryTyp = queryResult;
        SXSSFWorkbook workBook = new SXSSFWorkbook(this.workbookWindow);
        validationErrorCellStyle = workBook.createCellStyle();
        validationErrorCellStyle.setFillForegroundColor(IndexedColors.LIGHT_ORANGE.getIndex());
        validationErrorCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        PatientConverter.createInfoSheet((Workbook)workBook, queryResult, inquiry, contact, siteName, executionDateString, this.validationHandling);
        List<de.samply.share.model.common.Container> containerList = PatientConverter.transformQueryResultToContainerList(queryResult);
        for (de.samply.share.model.common.Container patient : containerList) {
            this.addPatientDataToExcel((Workbook)workBook, patient);
        }
        PatientConverterUtil.autosizeAllColumns((Workbook)workBook);
        for (int i = 1; i < workBook.getNumberOfSheets(); ++i) {
            PatientConverterUtil.addAutoFilter((Workbook)workBook, i);
            PatientConverterUtil.sortSheet((Workbook)workBook, i, new GbaSortRules(this.mdrClient));
        }
        PatientConverterUtil.freezeHeaderRows((Workbook)workBook);
        PatientConverterUtil.addCellComments(this.mdrClient, (Workbook)workBook);
        return workBook;
    }

    private void addPatientDataToExcel(Workbook workBook, de.samply.share.model.common.Container patient) throws PatientConverterException {
        this.addPatientDataToExcel(workBook, patient, null);
    }

    private void addPatientDataToExcel(Workbook workBook, de.samply.share.model.common.Container patient, SortRules sortRules) throws PatientConverterException {
        String newPatId = this.getRunningEntityIdName(patient.getDesignation()) + "_" + this.getRunningEntityId(patient.getDesignation());
        String localDktkId = patient.getId();
        String firstProgressDate = PatientConverterUtil.getOldestDateString(this.mdrClient, patient, Constants.PROGRESS_FIRST_DATE);
        String firstTumourDate = PatientConverterUtil.getOldestDateString(this.mdrClient, patient, Constants.TUMOUR_FIRST_DATE);
        DiagnosisConverter diagnosisConverter = new DiagnosisConverter(patient);
        HashMap<String, String> idAssignment = new HashMap<String, String>();
        List<de.samply.share.model.common.Container> containersOfPatient = this.getContainersOfPatient(patient, sortRules);
        for (de.samply.share.model.common.Container container : containersOfPatient) {
            Row headerDktkIdRow;
            Row headerDestinationRow;
            Row headerRow;
            String oldId = container.getId();
            String newId = this.getAppropriateEntityId(container.getDesignation());
            idAssignment.put(oldId + "." + container.getDesignation(), newId);
            String safeName = WorkbookUtil.createSafeSheetName((String)container.getDesignation());
            Sheet sheet = workBook.getSheet(safeName);
            ArrayList<String> splitRef = PatientConverter.splitParentRef(container);
            if (sheet == null) {
                sheet = workBook.createSheet(safeName);
                if (sheet instanceof SXSSFSheet) {
                    ((SXSSFSheet)sheet).trackAllColumnsForAutoSizing();
                }
                headerRow = sheet.createRow(0);
                headerDestinationRow = sheet.createRow(1);
                headerDktkIdRow = sheet.createRow(2);
                headerRow.createCell(0).setCellValue("ID");
                if (splitRef != null) {
                    headerRow.createCell(1).setCellValue(splitRef.get(1) + "_ID");
                    if (!splitRef.get(1).equalsIgnoreCase("Patient")) {
                        headerRow.createCell(2).setCellValue("Patient_ID");
                    }
                } else {
                    headerRow.createCell(1).setCellValue("Standort ID");
                    if (this.queryTyp instanceof QueryResult) {
                        headerRow.createCell(2).setCellValue("Datum 1. Verlauf");
                        headerRow.createCell(3).setCellValue("Tumor Diagnosedatum");
                    }
                }
            } else {
                headerRow = sheet.getRow(0);
                headerDestinationRow = sheet.getRow(1);
                headerDktkIdRow = sheet.getRow(2);
            }
            Row thisRow = sheet.createRow(sheet.getLastRowNum() + 1);
            thisRow.createCell(0).setCellValue(newId);
            if (splitRef != null) {
                String parentId = (String)idAssignment.get(splitRef.get(2) + "." + splitRef.get(1));
                thisRow.createCell(1).setCellValue(parentId);
                if (!splitRef.get(1).equalsIgnoreCase("patient")) {
                    thisRow.createCell(2).setCellValue(newPatId);
                }
            } else {
                thisRow.createCell(1).setCellValue(localDktkId);
                thisRow.createCell(2).setCellValue(firstProgressDate);
                thisRow.createCell(3).setCellValue(firstTumourDate);
            }
            this.addDiagnosisCell(headerRow, thisRow, diagnosisConverter, container);
            try {
                for (de.samply.share.model.common.Attribute attribute : container.getAttribute()) {
                    this.createCell(headerRow, headerDestinationRow, headerDktkIdRow, thisRow, attribute);
                }
            }
            catch (ValidatorException | MdrConnectionException | MdrInvalidResponseException | ExecutionException e) {
                throw new PatientConverterException(e);
            }
        }
    }

    private String getAppropriateEntityId(String entity) {
        String resultID = "";
        int id = this.getRunningEntityId(entity);
        resultID = this.getRunningEntityIdName(entity) + "_" + id;
        this.incrementRunningEntityId(entity);
        return resultID;
    }

    private List<de.samply.share.model.common.Container> getContainersOfPatient(de.samply.share.model.common.Container patient, SortRules sortRules) {
        TreeTraverser<de.samply.share.model.common.Container> containerTraverser = new TreeTraverser<de.samply.share.model.common.Container>(){

            public Iterable<de.samply.share.model.common.Container> children(de.samply.share.model.common.Container root) {
                ArrayList<de.samply.share.model.common.Container> children = new ArrayList<de.samply.share.model.common.Container>();
                for (de.samply.share.model.common.Container c : root.getContainer()) {
                    Ref parentRef = new Ref();
                    parentRef.getEntityId().add("PARENT:" + root.getDesignation() + ":" + root.getId());
                    c.getRef().add(parentRef);
                    children.add(c);
                }
                return children;
            }
        };
        List<de.samply.share.model.common.Container> containers = new ArrayList<de.samply.share.model.common.Container>();
        containerTraverser.preOrderTraversal((Object)patient).forEach(containers::add);
        if (sortRules != null) {
            containers = sortRules.sortContainers(containers);
        }
        return containers;
    }

    private void addDiagnosisCell(Row headerRow, Row row, DiagnosisConverter diagnosisConverter, de.samply.share.model.common.Container container) {
        String diagnosisCode = diagnosisConverter.getDiagnosisCode(container);
        if (diagnosisCode != null) {
            int diagnosisCodeColumn = this.getDiagnosisCodeColumn(headerRow);
            row.createCell(diagnosisCodeColumn).setCellValue(diagnosisCode);
        }
    }

    private int getDiagnosisCodeColumn(Row headerRow) {
        int cellIndex = PatientConverterUtil.getCellIndex("Diagnosecode", headerRow);
        if (cellIndex < 0) {
            cellIndex = headerRow.getLastCellNum();
            headerRow.createCell(cellIndex).setCellValue("Diagnosecode");
        }
        return cellIndex;
    }

    private void createCell(Row headerRow, Row headerDestinationRow, Row headerDktkIdRow, Row thisRow, de.samply.share.model.common.Attribute attribute) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException, ValidatorException {
        this.createCell(headerRow, headerDestinationRow, headerDktkIdRow, thisRow, attribute, this.validationHandling);
    }

    private void createCell(Row headerRow, Row headerDestinationRow, Row headerDktkIdRow, Row thisRow, de.samply.share.model.common.Attribute attribute, EnumValidationHandling validationHandling) throws MdrConnectionException, MdrInvalidResponseException, ExecutionException, ValidatorException {
        Cell thisCell;
        MdrIdDatatype attributeKey = new MdrIdDatatype(attribute.getMdrKey());
        if (PatientConverterUtil.isBlacklisted(this.blacklist, attributeKey)) {
            return;
        }
        DataElement dataElement = this.mdrClient.getDataElement(attribute.getMdrKey(), "de");
        if (this.isHidden(dataElement)) {
            // empty if block
        }
        String designation = ((Designation)dataElement.getDesignations().get(0)).getDesignation();
        String dktkId = PatientConverterUtil.getValueFromSlots(dataElement.getSlots(), "DKTK_ID");
        int cellIndex = PatientConverterUtil.getCellIndex(attribute.getMdrKey(), headerRow);
        if (cellIndex < 0) {
            cellIndex = headerRow.getLastCellNum();
            Cell newHeaderCell = headerRow.createCell(cellIndex);
            newHeaderCell.setCellValue(attribute.getMdrKey());
            try {
                this.addHyperlinkToCell(newHeaderCell);
            }
            catch (UnsupportedEncodingException e) {
                System.out.println("Error while trying to add hyperlink");
            }
            Cell newDestinationCell = headerDestinationRow.createCell(cellIndex);
            newDestinationCell.setCellValue(designation);
            Cell newDktkIdCell = headerDktkIdRow.createCell(cellIndex);
            newDktkIdCell.setCellValue(dktkId);
        }
        String value = (String)attribute.getValue().getValue();
        boolean isValid = true;
        if (validationHandling != EnumValidationHandling.NO_VALIDATION) {
            boolean bl = isValid = value == null || value.isEmpty() || this.validator.validate(attribute.getMdrKey(), (Object)value);
        }
        if (!isValid) {
            isValid = this.isValidAccordingToJavaDateFormatSlot(attribute.getMdrKey(), value);
        }
        if (isValid) {
            thisCell = thisRow.createCell(cellIndex);
            thisCell.setCellValue(value);
        } else if (validationHandling == EnumValidationHandling.KEEP_INVALID_ENTRIES) {
            thisCell = thisRow.createCell(cellIndex);
            thisCell.setCellValue(value);
            thisCell.setCellStyle(validationErrorCellStyle);
        }
    }

    private boolean isValidAccordingToJavaDateFormatSlot(String mdrKey, String value) throws ExecutionException, MdrConnectionException, MdrInvalidResponseException, ValidatorException {
        if (value == null || value.toString().equals("")) {
            return true;
        }
        Validations validations = this.mdrClient.getDataElementValidations(mdrKey, "de");
        ArrayList slots = this.mdrClient.getDataElementSlots(mdrKey);
        if (validations.getDatatype().equalsIgnoreCase("DATE")) {
            for (Slot slot : slots) {
                if (!slot.getSlotName().equalsIgnoreCase("JAVA_DATE_FORMAT")) continue;
                String targetDateFormat = slot.getSlotValue();
                DateTimeFormatter fmt = DateTimeFormatter.ofPattern(targetDateFormat);
                DateTimeFormatter fmt2 = fmt.withResolverStyle(ResolverStyle.STRICT);
                try {
                    fmt2.parse(value);
                    return Integer.parseInt(value) > 1900;
                }
                catch (NumberFormatException | DateTimeParseException runtimeException) {
                }
            }
        }
        return false;
    }

    private boolean isHidden(DataElement dataElement) {
        for (Slot slot : dataElement.getSlots()) {
            if (!slot.getSlotName().equalsIgnoreCase("DKTK_SUCHBAR") || !slot.getSlotValue().equalsIgnoreCase("H")) continue;
            return true;
        }
        return false;
    }

    private Cell addHyperlinkToCell(Cell cell) throws UnsupportedEncodingException {
        Workbook workBook = cell.getRow().getSheet().getWorkbook();
        CellStyle hlinkStyle = workBook.createCellStyle();
        Font hlinkFont = workBook.createFont();
        hlinkFont.setUnderline((byte)1);
        hlinkFont.setColor(IndexedColors.BLUE.getIndex());
        hlinkStyle.setFont(hlinkFont);
        CreationHelper createHelper = workBook.getCreationHelper();
        Hyperlink link = createHelper.createHyperlink(HyperlinkType.URL);
        link.setAddress(this.mdrLinkUrl + this.mdrLinkPath + URLEncoder.encode(cell.getStringCellValue(), StandardCharsets.UTF_8.name()));
        cell.setHyperlink(link);
        cell.setCellStyle(hlinkStyle);
        return cell;
    }
}

