/*
 * Decompiled with CFR 0.152.
 */
package de.samply.dktk.converter;

import de.samply.share.model.ccp.Attribute;
import de.samply.share.model.ccp.Case;
import de.samply.share.model.ccp.Container;
import de.samply.share.model.ccp.Patient;
import de.samply.share.model.ccp.Sample;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public abstract class PatientAttributeOperator {
    protected abstract Attribute operateAttribute(Attribute var1);

    protected Patient operateAttributes(Patient patient) {
        List caseListP = patient.getCase();
        for (Case caseP : caseListP) {
            this.operateAttributes(caseP);
        }
        List sampleList = patient.getSample();
        for (Sample sample : sampleList) {
            this.operateAttributes(sample);
        }
        this.operateAttributes(() -> patient.getAttribute(), () -> patient.getContainer());
        return patient;
    }

    private void operateAttributes(Case caseP) {
        this.operateAttributes(() -> caseP.getAttribute(), () -> caseP.getContainer());
    }

    private void operateAttributes(Sample sample) {
        this.operateAttributes(() -> sample.getAttribute(), () -> sample.getContainer());
    }

    private void operateAttributes(Supplier<List<Attribute>> attributesSupplier, Supplier<List<Container>> containersSupplier) {
        List<Attribute> attributes = attributesSupplier.get();
        this.operateAttributes(attributes);
        List<Container> containers = containersSupplier.get();
        for (Container container : containers) {
            this.operateAttributes(() -> container.getAttribute(), () -> container.getContainer());
        }
    }

    private void operateAttributes(List<Attribute> attributes) {
        ArrayList<Attribute> newAttributes = new ArrayList<Attribute>();
        for (Attribute attribute : attributes) {
            Attribute newAttribute = this.operateAttribute(attribute);
            if (newAttribute == null) continue;
            newAttributes.add(newAttribute);
        }
        attributes.clear();
        attributes.addAll(newAttributes);
    }
}

