/*
 * Decompiled with CFR 0.152.
 */
package de.samply.dktk.converter;

import de.samply.dktk.converter.Constants;
import de.samply.share.common.utils.MdrIdDatatype;
import de.samply.share.model.common.Attribute;
import de.samply.share.model.common.Container;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class DiagnosisConverter {
    private Map<Container, String> containerDiagnosisCodeMap = new HashMap<Container, String>();

    public DiagnosisConverter(Container patient) {
        this.parsePatient(patient);
    }

    private void parsePatient(Container patient) {
        if (this.isPatient(patient)) {
            for (Container container : patient.getContainer()) {
                this.parseContainer(container);
            }
        }
    }

    private void parseContainer(Container container) {
        this.parseContainer(container, null);
    }

    private void parseContainer(Container container, Consumer<Container> consumerContainer) {
        if (consumerContainer != null) {
            consumerContainer.accept(container);
        }
        String diagnosisCode = this.isDiagnosis(container) ? this.getDiagnosisCodeOfDiagnosis(container) : null;
        consumerContainer = diagnosisCode != null ? x -> this.addContainerToDiagnosisChildren((Container)x, diagnosisCode) : consumerContainer;
        for (Container child : container.getContainer()) {
            this.parseContainer(child, consumerContainer);
        }
    }

    private void addContainerToDiagnosisChildren(Container container, String diagnosisCode) {
        this.containerDiagnosisCodeMap.put(container, diagnosisCode);
    }

    private boolean isDiagnosis(Container container) {
        return container.getDesignation().equalsIgnoreCase("Diagnosis");
    }

    private boolean isPatient(Container container) {
        return container.getDesignation().equalsIgnoreCase("Patient");
    }

    private String getDiagnosisCodeOfDiagnosis(Container diagnosis) {
        for (Attribute attribute : diagnosis.getAttribute()) {
            if (!this.isDiagnosisCode(attribute)) continue;
            return (String)attribute.getValue().getValue();
        }
        return null;
    }

    private boolean isDiagnosisCode(Attribute attribute) {
        MdrIdDatatype attributeKey = new MdrIdDatatype(attribute.getMdrKey());
        return Constants.DIAGNOSE.equalsIgnoreVersion((Object)attributeKey);
    }

    public String getDiagnosisCode(Container container) {
        return this.containerDiagnosisCodeMap.get(container);
    }
}

