/*
 * Decompiled with CFR 0.152.
 */
package de.samply.common.ldmclient.cql;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.DataFormatException;
import com.google.common.base.Splitter;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.samply.common.ldmclient.LdmClientCqlQuery;
import de.samply.common.ldmclient.LdmClientException;
import de.samply.common.ldmclient.LdmClientUtil;
import de.samply.common.ldmclient.model.LdmQueryResult;
import de.samply.share.model.common.Error;
import de.samply.share.model.common.QueryResultStatistic;
import de.samply.share.model.common.result.Stratification;
import de.samply.share.model.common.result.Stratum;
import de.samply.share.model.cql.CqlResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.Configurable;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.hl7.fhir.r4.model.CapabilityStatement;
import org.hl7.fhir.r4.model.MeasureReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdmClientCql
extends LdmClientCqlQuery<CqlResult, CqlResult, Error> {
    private static final String EVALUATE = "$evaluate-measure?periodStart=2000&periodEnd=2019";
    private static final FhirContext FHIR_CONTEXT = FhirContext.forR4();
    private static final Logger logger = LoggerFactory.getLogger(LdmClientCql.class);

    public LdmClientCql(CloseableHttpClient httpClient, String ldmBaseUrl) {
        super(httpClient, ldmBaseUrl);
    }

    protected Class<CqlResult> getResultClass() {
        return CqlResult.class;
    }

    protected Class<CqlResult> getStatisticsClass() {
        return CqlResult.class;
    }

    protected Class<Error> getErrorClass() {
        return Error.class;
    }

    public String getUserAgentInfo() {
        return "Blaze/" + this.getVersionString();
    }

    public CqlResult getResult(String location) {
        throw new NotImplementedException("CqlResult depends on two locations and must be created differently.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getVersionString() {
        HttpGet httpGet = new HttpGet(this.getLdmBaseUrl() + "metadata");
        try (CloseableHttpResponse response = this.getHttpClient().execute((HttpUriRequest)httpGet);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) return "unknown";
            HttpEntity entity = response.getEntity();
            String entityOutput = EntityUtils.toString((HttpEntity)entity, (Charset)Consts.UTF_8);
            CapabilityStatement capabilityStatement = (CapabilityStatement)FHIR_CONTEXT.newJsonParser().parseResource(entityOutput);
            String string = capabilityStatement.getSoftware().getVersion();
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "unknown";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LdmQueryResult getStatsOrError(String location) throws LdmClientException {
        HttpGet httpGet = new HttpGet(LdmClientUtil.addTrailingSlash((String)location) + EVALUATE);
        CloseableHttpClient httpClient = this.getHttpClient();
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                HttpEntity entity = response.getEntity();
                String entityOutput = EntityUtils.toString((HttpEntity)entity, (Charset)Consts.UTF_8);
                MeasureReport measureReport = (MeasureReport)FHIR_CONTEXT.newJsonParser().parseResource(entityOutput);
                QueryResultStatistic queryResultStatistic = this.createQueryResultStatistic(measureReport);
                LdmQueryResult ldmQueryResult = new LdmQueryResult(queryResultStatistic);
                return ldmQueryResult;
            }
            if (statusCode >= 400 && statusCode < 500) {
                Error error = this.createError(statusCode);
                LdmQueryResult ldmQueryResult = new LdmQueryResult(error);
                return ldmQueryResult;
            }
            if (statusCode != 504) throw new LdmClientException("Unexpected response code '" + statusCode + "' while evaluating measure with URL '" + location + "'");
            throw new LdmClientException("Gateway timeout while evaluating measure with URL '" + location + "'");
        }
        catch (SocketTimeoutException e) {
            throw new LdmClientException("Timeout (" + ((Configurable)httpClient).getConfig().getSocketTimeout() + " ms) while evaluating measure with URL '" + location + "'", (Throwable)e);
        }
        catch (DataFormatException | IOException e) {
            throw new LdmClientException(e);
        }
    }

    private Error createError(int statusCode) {
        Error error = new Error();
        error.setErrorCode(statusCode);
        return error;
    }

    private QueryResultStatistic createQueryResultStatistic(MeasureReport measureReport) {
        MeasureReport.MeasureReportGroupComponent firstGroup = measureReport.getGroupFirstRep();
        int count = firstGroup.getPopulationFirstRep().getCount();
        QueryResultStatistic queryResultStatistic = new QueryResultStatistic();
        queryResultStatistic.setTotalSize(count);
        queryResultStatistic.setNumberOfPages(1);
        queryResultStatistic.setRequestId("1");
        for (MeasureReport.MeasureReportGroupStratifierComponent fhirStratifier : firstGroup.getStratifier()) {
            Stratum stratum;
            Stratification stratification = new Stratification();
            stratification.setTitle(fhirStratifier.getCodeFirstRep().getText());
            if (stratification.getTitle().equals("Custodian")) {
                for (MeasureReport.StratifierGroupComponent fhirStratum : fhirStratifier.getStratum()) {
                    stratum = new Stratum();
                    stratum.setLabel(fhirStratum.getValue().getText());
                    stratum.setCount((long)fhirStratum.getPopulationFirstRep().getCount());
                    stratification.getStrata().add(stratum);
                }
            }
            for (MeasureReport.StratifierGroupComponent fhirStratum : fhirStratifier.getStratum()) {
                stratum = new Stratum();
                stratum.setLabel(fhirStratum.getValue().getText());
                stratum.setCount((long)fhirStratum.getPopulationFirstRep().getCount());
                stratification.getStrata().add(stratum);
            }
            queryResultStatistic.getStratification().add(stratification);
        }
        return queryResultStatistic;
    }

    public String createSubjectList(URI location) throws LdmClientException {
        URI measureReportUri = this.createMeasureReport(location);
        return this.getFirstSubjectListUri(measureReportUri);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    URI createMeasureReport(URI location) throws LdmClientException {
        JsonObject parameter = LdmClientCql.loadParameterStub();
        location = URI.create(location + "/$evaluate-measure");
        HttpPost httpPost = new HttpPost(location);
        httpPost.setHeader("Content-Type", "application/fhir+json");
        StringEntity entity = new StringEntity(parameter.toString(), Consts.UTF_8);
        httpPost.setEntity((HttpEntity)entity);
        try (CloseableHttpResponse response = this.getHttpClient().execute((HttpUriRequest)httpPost);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 201) {
                logger.error(String.format("Measure report not created. Status code: %d, Response: %s", statusCode, EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Consts.UTF_8)));
                throw new LdmClientException("Measure report not created. Received status code " + statusCode);
            }
            Header locationHeader = response.getFirstHeader("Location");
            if (locationHeader == null) {
                throw new LdmClientException("Location header is missing");
            }
            URI uRI = LdmClientCql.resourceLocation(locationHeader.getValue());
            return uRI;
        }
        catch (IOException | URISyntaxException e) {
            throw new LdmClientException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String getFirstSubjectListUri(URI measureReportUri) throws LdmClientException {
        HttpGet httpGet = new HttpGet(measureReportUri);
        httpGet.setHeader("Accept", "application/fhir+json");
        try (CloseableHttpResponse response = this.getHttpClient().execute((HttpUriRequest)httpGet);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                HttpEntity entity = response.getEntity();
                String entityOutput = EntityUtils.toString((HttpEntity)entity, (Charset)Consts.UTF_8);
                MeasureReport measureReport = (MeasureReport)FHIR_CONTEXT.newJsonParser().parseResource(entityOutput);
                String string = LdmClientUtil.addTrailingSlash((String)this.getLdmBaseUrl()) + measureReport.getGroupFirstRep().getPopulationFirstRep().getSubjectResults().getReference();
                return string;
            }
            throw new LdmClientException("Unexpected response code '" + statusCode + "' while getting subject list from measure with URL '" + measureReportUri + "'");
        }
        catch (IOException e) {
            throw new LdmClientException((Throwable)e);
        }
    }

    private static URI resourceLocation(String location) throws URISyntaxException {
        Iterator partIter = Splitter.on((String)"/_history").split((CharSequence)location).iterator();
        return new URI((String)partIter.next());
    }

    private static JsonObject loadParameterStub() {
        return LdmClientCql.loadJson("parameters-stub.json");
    }

    private static JsonObject loadJson(String name) {
        InputStream in = LdmClientCql.class.getResourceAsStream(name);
        return new JsonParser().parse((Reader)new InputStreamReader(in, StandardCharsets.UTF_8)).getAsJsonObject();
    }

    public boolean isLdmCql() {
        return true;
    }
}

