/*
 * Decompiled with CFR 0.152.
 */
package de.samply.common.ldmclient.cql;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.DataFormatException;
import de.samply.common.ldmclient.LdmClientCqlQuery;
import de.samply.common.ldmclient.LdmClientException;
import de.samply.common.ldmclient.LdmClientUtil;
import de.samply.common.ldmclient.model.LdmQueryResult;
import de.samply.share.model.common.Error;
import de.samply.share.model.common.QueryResultStatistic;
import de.samply.share.model.common.result.Stratification;
import de.samply.share.model.common.result.Stratum;
import de.samply.share.model.cql.CqlResult;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.Configurable;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.hl7.fhir.r4.model.CapabilityStatement;
import org.hl7.fhir.r4.model.MeasureReport;

public class LdmClientCql
extends LdmClientCqlQuery<CqlResult, CqlResult, Error> {
    private static final String EVALUATE = "$evaluate-measure?periodStart=2000&periodEnd=2019";
    private static final FhirContext FHIR_CONTEXT = FhirContext.forR4();

    public LdmClientCql(CloseableHttpClient httpClient, String ldmBaseUrl) {
        super(httpClient, ldmBaseUrl);
    }

    protected Class<CqlResult> getResultClass() {
        return CqlResult.class;
    }

    protected Class<CqlResult> getStatisticsClass() {
        return CqlResult.class;
    }

    protected Class<Error> getErrorClass() {
        return Error.class;
    }

    public String getUserAgentInfo() {
        return "BLAZE/" + this.getVersionString();
    }

    public CqlResult getResult(String location) {
        throw new NotImplementedException("CqlResult depends on two locations and must be created differently.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getVersionString() {
        HttpGet httpGet = new HttpGet(this.getLdmBaseUrl() + "metadata");
        try (CloseableHttpResponse response = this.getHttpClient().execute((HttpUriRequest)httpGet);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) return "unknown";
            HttpEntity entity = response.getEntity();
            String entityOutput = EntityUtils.toString((HttpEntity)entity, (Charset)Consts.UTF_8);
            CapabilityStatement capabilityStatement = (CapabilityStatement)FHIR_CONTEXT.newJsonParser().parseResource(entityOutput);
            String string = capabilityStatement.getSoftware().getVersion();
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "unknown";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LdmQueryResult getStatsOrError(String location) throws LdmClientException {
        HttpGet httpGet = new HttpGet(LdmClientUtil.addTrailingSlash((String)location) + EVALUATE);
        CloseableHttpClient httpClient = this.getHttpClient();
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                HttpEntity entity = response.getEntity();
                String entityOutput = EntityUtils.toString((HttpEntity)entity, (Charset)Consts.UTF_8);
                MeasureReport measureReport = (MeasureReport)FHIR_CONTEXT.newJsonParser().parseResource(entityOutput);
                QueryResultStatistic queryResultStatistic = this.createQueryResultStatistic(measureReport);
                LdmQueryResult ldmQueryResult = new LdmQueryResult(queryResultStatistic);
                return ldmQueryResult;
            }
            if (statusCode >= 400 && statusCode < 500) {
                Error error = this.createError(statusCode);
                LdmQueryResult ldmQueryResult = new LdmQueryResult(error);
                return ldmQueryResult;
            }
            if (statusCode != 504) throw new LdmClientException("Unexpected response code '" + statusCode + "' while evaluating measure with URL '" + location + "'");
            throw new LdmClientException("Gateway timeout while evaluating measure with URL '" + location + "'");
        }
        catch (SocketTimeoutException e) {
            throw new LdmClientException("Timeout (" + ((Configurable)httpClient).getConfig().getSocketTimeout() + " ms) while evaluating measure with URL '" + location + "'", (Throwable)e);
        }
        catch (DataFormatException | IOException e) {
            throw new LdmClientException(e);
        }
    }

    private Error createError(int statusCode) {
        Error error = new Error();
        error.setErrorCode(statusCode);
        return error;
    }

    private QueryResultStatistic createQueryResultStatistic(MeasureReport measureReport) {
        MeasureReport.MeasureReportGroupComponent firstGroup = measureReport.getGroupFirstRep();
        int count = firstGroup.getPopulationFirstRep().getCount();
        QueryResultStatistic queryResultStatistic = new QueryResultStatistic();
        queryResultStatistic.setTotalSize(count);
        queryResultStatistic.setNumberOfPages(1);
        queryResultStatistic.setRequestId("1");
        for (MeasureReport.MeasureReportGroupStratifierComponent fhirStratifier : firstGroup.getStratifier()) {
            Stratification stratification = new Stratification();
            stratification.setTitle(fhirStratifier.getCodeFirstRep().getText());
            for (MeasureReport.StratifierGroupComponent fhirStratum : fhirStratifier.getStratum()) {
                Stratum stratum = new Stratum();
                stratum.setLabel(fhirStratum.getValue().getText());
                stratum.setCount((long)fhirStratum.getPopulationFirstRep().getCount());
                stratification.getStrata().add(stratum);
            }
            queryResultStatistic.getStratification().add(stratification);
        }
        return queryResultStatistic;
    }

    public boolean isLdmCql() {
        return true;
    }
}

