/*
 * Decompiled with CFR 0.152.
 */
package de.samply.common.ldmclient.centraxx;

import de.samply.common.ldmclient.LdmClientException;
import de.samply.common.ldmclient.LdmClientUtil;
import de.samply.common.ldmclient.LdmClientView;
import de.samply.common.ldmclient.centraxx.model.CentraxxInfo;
import de.samply.common.ldmclient.centraxx.model.QueryResultStatistic;
import de.samply.common.ldmclient.model.LdmQueryResult;
import de.samply.share.common.utils.PercentageLogger;
import de.samply.share.model.ccp.ObjectFactory;
import de.samply.share.model.ccp.Patient;
import de.samply.share.model.ccp.QueryResult;
import de.samply.share.model.ccp.View;
import de.samply.share.model.common.Error;
import de.samply.share.utils.QueryConverter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdmClientCentraxx
extends LdmClientView<QueryResult, de.samply.share.model.common.QueryResultStatistic, de.samply.share.model.ccp.Error, View> {
    private static final String REST_PATH_TEILER = "teiler/";
    private static final String REST_PATH_INFO = "info/";
    private static final boolean CACHING_DEFAULT_VALUE = false;
    private final Logger logger = LoggerFactory.getLogger(LdmClientCentraxx.class);

    public LdmClientCentraxx(CloseableHttpClient httpClient, String centraxxBaseUrl) throws LdmClientException {
        this(httpClient, centraxxBaseUrl, false);
    }

    public LdmClientCentraxx(CloseableHttpClient httpClient, String centraxxBaseUrl, boolean useCaching) throws LdmClientException {
        this(httpClient, centraxxBaseUrl, useCaching, 1000);
    }

    public LdmClientCentraxx(CloseableHttpClient httpClient, String centraxxBaseUrl, boolean useCaching, int cacheSize) throws LdmClientException {
        super(httpClient, centraxxBaseUrl, useCaching, cacheSize);
    }

    public boolean isLdmCentraxx() {
        return true;
    }

    protected String getFullPath(boolean statisticsOnly) {
        String path = "requests";
        if (statisticsOnly) {
            path = path + "?statisticsOnly=true";
        }
        return LdmClientUtil.addTrailingSlash((String)this.getLdmBaseUrl()) + path;
    }

    protected Class<View> getSpecificViewClass() {
        return View.class;
    }

    protected Class<QueryResult> getResultClass() {
        return QueryResult.class;
    }

    protected Class<de.samply.share.model.common.QueryResultStatistic> getStatisticsClass() {
        return de.samply.share.model.common.QueryResultStatistic.class;
    }

    private Class getStatisticsClass(String response) {
        return response.contains("http://de.kairos.centraxx/ccp/QueryResultStatistic") ? QueryResultStatistic.class : this.getStatisticsClass();
    }

    protected Class<de.samply.share.model.ccp.Error> getErrorClass() {
        return de.samply.share.model.ccp.Error.class;
    }

    protected Class<?> getObjectFactoryClassForPostView() {
        return ObjectFactory.class;
    }

    protected Class<?> getObjectFactoryClassForResult() {
        return ObjectFactory.class;
    }

    protected View convertCommonViewToSpecificView(de.samply.share.model.common.View view) throws JAXBException {
        return QueryConverter.convertCommonViewToCcpView((de.samply.share.model.common.View)view);
    }

    protected de.samply.share.model.common.View convertSpecificViewToCommonView(View ccpView) throws JAXBException {
        return QueryConverter.convertCcpViewToCommonView((View)ccpView);
    }

    public LdmQueryResult convertQueryResultStatisticToCommonQueryResultStatistic(QueryResultStatistic queryResultStatistic) {
        de.samply.share.model.common.QueryResultStatistic commonQueryResultStatistic = new de.samply.share.model.common.QueryResultStatistic();
        commonQueryResultStatistic.setNumberOfPages(queryResultStatistic.getNumberOfPages());
        commonQueryResultStatistic.setRequestId(queryResultStatistic.getRequestId());
        commonQueryResultStatistic.setTotalSize(queryResultStatistic.getTotalSize());
        return new LdmQueryResult(commonQueryResultStatistic);
    }

    protected LdmQueryResult convertQueryResultStatisticToCommonQueryResultStatistic(de.samply.share.model.common.QueryResultStatistic qrs) throws JAXBException {
        return new LdmQueryResult(qrs);
    }

    protected LdmQueryResult convertSpecificErrorToCommonError(de.samply.share.model.ccp.Error error) throws JAXBException {
        Error convertedError = QueryConverter.convertCcpErrorToCommonError((de.samply.share.model.ccp.Error)error);
        return new LdmQueryResult(convertedError);
    }

    public QueryResult getResult(String location) throws LdmClientException {
        QueryResult queryResult = new QueryResult();
        de.samply.share.model.common.QueryResultStatistic queryResultStatistic = this.getQueryResultStatistic(location);
        if (queryResultStatistic != null && queryResultStatistic.getTotalSize() > 0) {
            int numberOfPages = queryResultStatistic.getNumberOfPages();
            PercentageLogger percentageLogger = new PercentageLogger(this.logger, numberOfPages, "getting results from centraxx...");
            percentageLogger.start();
            for (int i = 0; i < numberOfPages; ++i) {
                QueryResult queryResultPage = (QueryResult)this.getResultPage(location, i);
                queryResult.getPatient().addAll(queryResultPage.getPatient());
                percentageLogger.incrementCounter();
            }
            queryResult.setId(queryResultStatistic.getRequestId());
        }
        return queryResult;
    }

    public String getVersionString() throws LdmClientException {
        CentraxxInfo centraxxInfo = this.getInfo();
        return centraxxInfo != null ? centraxxInfo.getCentraxxVersion() : null;
    }

    public String getUserAgentInfo() throws LdmClientException {
        String centraxxVersion = this.getVersionString();
        return centraxxVersion != null ? "Centraxx/" + centraxxVersion : "No CentraXX info provided";
    }

    public LdmQueryResult getStatsOrError(String location) throws LdmClientException {
        HttpGet httpGet = new HttpGet(LdmClientUtil.addTrailingSlash((String)location) + "stats");
        this.addHttpHeaders((HttpRequestBase)httpGet);
        if (this.isLdmCentraxx()) {
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(60000).setConnectionRequestTimeout(60000).build();
            httpGet.setConfig(requestConfig);
        }
        try {
            CloseableHttpResponse response = this.getHttpClient().execute((HttpUriRequest)httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            String entityOutput = EntityUtils.toString((HttpEntity)entity, (Charset)Consts.UTF_8);
            if (statusCode == 200) {
                Class statisticsClass = this.getStatisticsClass(entityOutput);
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{statisticsClass});
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                Object qrs = jaxbUnmarshaller.unmarshal((Reader)new StringReader(entityOutput));
                EntityUtils.consume((HttpEntity)entity);
                response.close();
                return qrs instanceof QueryResultStatistic ? this.convertQueryResultStatisticToCommonQueryResultStatistic((QueryResultStatistic)qrs) : this.convertQueryResultStatisticToCommonQueryResultStatistic((de.samply.share.model.common.QueryResultStatistic)qrs);
            }
            if (statusCode == 422) {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{this.getErrorClass()});
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                de.samply.share.model.ccp.Error error = (de.samply.share.model.ccp.Error)jaxbUnmarshaller.unmarshal((Reader)new StringReader(entityOutput));
                EntityUtils.consume((HttpEntity)entity);
                response.close();
                return this.convertSpecificErrorToCommonError(error);
            }
            if (statusCode == 202) {
                response.close();
                this.logger.debug("Statistics not written yet. LDM client is probably busy with another request.");
                return LdmQueryResult.EMPTY;
            }
            response.close();
            throw new LdmClientException("Unexpected response code: " + statusCode);
        }
        catch (IOException | JAXBException e) {
            throw new LdmClientException("While trying to read stats/error", e);
        }
    }

    private CentraxxInfo getInfo() throws LdmClientException {
        ResponseHandler responseHandler = response -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        };
        String infoUrl = this.getInfoUrl();
        try {
            return (CentraxxInfo)this.getHttpClient().execute((HttpUriRequest)new HttpGet(infoUrl), responseHandler);
        }
        catch (IOException e) {
            throw new LdmClientException("Could not read centraxx info", (Throwable)e);
        }
    }

    private String getInfoUrl() {
        String baseUrl = LdmClientUtil.addTrailingSlash((String)this.getLdmBaseUrl());
        if (baseUrl.contains(REST_PATH_TEILER)) {
            int index = baseUrl.indexOf(REST_PATH_TEILER);
            baseUrl = baseUrl.substring(0, index);
        }
        return baseUrl + REST_PATH_INFO;
    }

    public QueryResult exportQuery(QueryResult queryResult) throws JAXBException, LdmClientException, InterruptedException, IOException {
        ArrayList<String> patientids = new ArrayList<String>();
        for (int i = 0; i < queryResult.getPatient().size(); ++i) {
            patientids.add(((Patient)queryResult.getPatient().get(i)).getId());
        }
        StringBuilder builder = new StringBuilder();
        builder.append("<ns5:View xmlns:ns2=\"http://schema.samply.de/common/MdrKey\" xmlns:ns3=\"http://schema.samply.de/common/Value\" xmlns:ns4=\"http://schema.samply.de/common/Attribute\" xmlns:ns5=\"http://schema.samply.de/common/Query\">\n<ns5:Query>\n<ns5:Where>\n<ns5:Or>\n");
        for (String patientid : patientids) {
            builder.append("<ns5:Eq>\n<ns4:Attribute>\n<ns2:MdrKey>urn:dktk:dataelement:91:1</ns2:MdrKey>\n<ns3:Value>" + patientid + "</ns3:Value>\n</ns4:Attribute>\n</ns5:Eq>\n");
        }
        builder.append("</ns5:Or>\n</ns5:Where>\n</ns5:Query>\n<ns5:ViewFields>\n<ns2:MdrKey>urn:dktk:dataelement:54:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:26:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:1:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:24:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:25:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:46:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:43:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:45:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:74:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:72:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:73:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:80:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:99:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:79:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:101:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:78:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:100:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:2:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:10:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:81:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:18:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:82:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:28:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:21:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:29:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:77:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:9:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:3:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:8:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:5:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:19:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:4:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:98:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:7:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:6:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:83:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:89:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:39:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:38:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:69:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:23:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:67:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:40:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:36:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:33:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:34:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:48:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:53:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:49:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:90:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:50:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:97:*</ns2:MdrKey>\n<ns2:MdrKey>urn:dktk:dataelement:95:*</ns2:MdrKey>\n<ns2:MdrKey>urn:adt:dataelement:77:*</ns2:MdrKey>\n<ns2:MdrKey>urn:adt:dataelement:78:*</ns2:MdrKey>\n<ns2:MdrKey>urn:adt:dataelement:90:*</ns2:MdrKey>\n<ns2:MdrKey>urn:adt:dataelement:93:*</ns2:MdrKey>\n<ns2:MdrKey>urn:adt:dataelement:89:*</ns2:MdrKey>\n<ns2:MdrKey>urn:adt:dataelement:91:*</ns2:MdrKey>\n</ns5:ViewFields>\n</ns5:View>");
        de.samply.share.model.common.View v = QueryConverter.xmlToView((String)builder.toString());
        String location = this.postView(v);
        HttpGet httpGet = new HttpGet(location + "/" + "result" + "?page=" + 0);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(60000).setConnectionRequestTimeout(60000).build();
        httpGet.setConfig(requestConfig);
        int statusCode = 202;
        while (statusCode == 202) {
            CloseableHttpResponse response = this.getHttpClient().execute((HttpUriRequest)httpGet);
            statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 202) continue;
            TimeUnit.SECONDS.sleep(3L);
        }
        queryResult = this.getResult(location);
        System.out.println(builder.toString());
        return queryResult;
    }
}

