/*
 * Decompiled with CFR 0.152.
 */
package de.samply.common.http;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.client.apache4.ApacheHttpClient4Handler;
import de.samply.common.config.Configuration;
import de.samply.common.config.Proxy;
import de.samply.common.http.HttpConnectorException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.ChallengeState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.auth.DigestSchemeFactory;
import org.apache.http.impl.auth.KerberosSchemeFactory;
import org.apache.http.impl.auth.NTLMSchemeFactory;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.jaxrs.JacksonJaxbJsonProvider;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;
import org.codehaus.jackson.map.DeserializationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnector {
    private static final String PROTOCOL_HTTP = "http";
    private static final String PROTOCOL_HTTPS = "https";
    public static final String PROXY_HTTPS_PASSWORD = "proxy.https.password";
    public static final String PROXY_HTTPS_USERNAME = "proxy.https.username";
    public static final String PROXY_HTTP_PASSWORD = "proxy.http.password";
    public static final String PROXY_HTTP_USERNAME = "proxy.http.username";
    public static final String PROXY_HTTPS_PORT = "proxy.https.port";
    public static final String PROXY_HTTPS_HOST = "proxy.https.host";
    public static final String PROXY_HTTP_PORT = "proxy.http.port";
    public static final String PROXY_HTTP_HOST = "proxy.http.host";
    public static final String USER_AGENT = "http.useragent";
    public static final String PROXY_BYPASS_PRIVATE_NETWORKS = "proxy.bypass.private.networks";
    private static final Logger logger = LoggerFactory.getLogger(HttpConnector.class);
    private String httpProxyUrl;
    private String httpProxyPort;
    private String httpsProxyUrl;
    private String httpsProxyPort;
    private String httpProxyUsername;
    private String httpProxyPassword;
    private String httpsProxyUsername;
    private String httpsProxyPassword;
    private CredentialsProvider credentialsProvider;
    private CloseableHttpClient httpc;
    private CloseableHttpClient httpsc;
    private String userAgent;
    private boolean bypassProxyForPrivateNetworks = false;
    private List<Header> customHeaders = new ArrayList<Header>();
    private int timeout = 0;

    public HttpConnector() {
        this.credentialsProvider = this.initializeCredentialsProvider();
        this.initClients();
    }

    public HttpConnector(org.apache.commons.configuration.Configuration config) {
        this.httpProxyUrl = config.getString(PROXY_HTTP_HOST);
        this.httpProxyPort = config.getString(PROXY_HTTP_PORT);
        this.httpsProxyUrl = config.getString(PROXY_HTTPS_HOST);
        this.httpsProxyPort = config.getString(PROXY_HTTPS_PORT);
        this.httpProxyUsername = config.getString(PROXY_HTTP_USERNAME);
        this.httpProxyPassword = config.getString(PROXY_HTTP_PASSWORD);
        this.httpsProxyUsername = config.getString(PROXY_HTTPS_USERNAME);
        this.httpsProxyPassword = config.getString(PROXY_HTTPS_PASSWORD);
        if (config.getString(USER_AGENT) != null) {
            this.userAgent = config.getString(USER_AGENT);
        }
        this.bypassProxyForPrivateNetworks = config.getBoolean(PROXY_BYPASS_PRIVATE_NETWORKS, false);
        this.credentialsProvider = this.initializeCredentialsProvider();
        this.initClients();
    }

    public HttpConnector(HashMap<String, String> config) {
        this.httpProxyUrl = config.get(PROXY_HTTP_HOST);
        this.httpProxyPort = config.get(PROXY_HTTP_PORT);
        this.httpsProxyUrl = config.get(PROXY_HTTPS_HOST);
        this.httpsProxyPort = config.get(PROXY_HTTPS_PORT);
        this.httpProxyUsername = config.get(PROXY_HTTP_USERNAME);
        this.httpProxyPassword = config.get(PROXY_HTTP_PASSWORD);
        this.httpsProxyUsername = config.get(PROXY_HTTPS_USERNAME);
        this.httpsProxyPassword = config.get(PROXY_HTTPS_PASSWORD);
        if (config.get(USER_AGENT) != null) {
            this.userAgent = config.get(USER_AGENT);
        }
        try {
            this.bypassProxyForPrivateNetworks = Boolean.parseBoolean(config.get(PROXY_BYPASS_PRIVATE_NETWORKS));
        }
        catch (Exception e) {
            this.bypassProxyForPrivateNetworks = false;
        }
        this.credentialsProvider = this.initializeCredentialsProvider();
        this.initClients();
    }

    public HttpConnector(HashMap<String, String> config, CredentialsProvider credentialsProvider) {
        this.httpProxyUrl = config.get(PROXY_HTTP_HOST);
        this.httpProxyPort = config.get(PROXY_HTTP_PORT);
        this.httpsProxyUrl = config.get(PROXY_HTTPS_HOST);
        this.httpsProxyPort = config.get(PROXY_HTTPS_PORT);
        if (config.get(USER_AGENT) != null) {
            this.userAgent = config.get(USER_AGENT);
        }
        try {
            this.bypassProxyForPrivateNetworks = Boolean.parseBoolean(config.get(PROXY_BYPASS_PRIVATE_NETWORKS));
        }
        catch (Exception e) {
            this.bypassProxyForPrivateNetworks = false;
        }
        this.setCp(credentialsProvider);
        this.initClients();
    }

    public HttpConnector(HashMap<String, String> config, CredentialsProvider credentialsProvider, int timeout) {
        this.httpProxyUrl = config.get(PROXY_HTTP_HOST);
        this.httpProxyPort = config.get(PROXY_HTTP_PORT);
        this.httpsProxyUrl = config.get(PROXY_HTTPS_HOST);
        this.httpsProxyPort = config.get(PROXY_HTTPS_PORT);
        if (config.get(USER_AGENT) != null) {
            this.userAgent = config.get(USER_AGENT);
        }
        try {
            this.bypassProxyForPrivateNetworks = Boolean.parseBoolean(config.get(PROXY_BYPASS_PRIVATE_NETWORKS));
        }
        catch (Exception e) {
            this.bypassProxyForPrivateNetworks = false;
        }
        this.timeout = timeout;
        this.setCp(credentialsProvider);
        this.initClients();
    }

    public HttpConnector(Configuration config) {
        if (config != null && config.getProxy() != null) {
            if (config.getProxy().getHttp() != null && config.getProxy().getHttp().getUrl() != null) {
                this.httpProxyUrl = config.getProxy().getHttp().getUrl().getHost();
                this.httpProxyPort = config.getProxy().getHttp().getUrl().getPort() + "";
                this.httpProxyUsername = config.getProxy().getHttp().getUsername();
                this.httpProxyPassword = config.getProxy().getHttp().getPassword();
            }
            if (config.getProxy().getHttps() != null && config.getProxy().getHttps().getUrl() != null) {
                this.httpsProxyUrl = config.getProxy().getHttps().getUrl().getHost();
                this.httpsProxyPort = config.getProxy().getHttps().getUrl().getPort() + "";
                this.httpsProxyUsername = config.getProxy().getHttps().getUsername();
                this.httpsProxyPassword = config.getProxy().getHttps().getPassword();
            }
        }
        this.credentialsProvider = this.initializeCredentialsProvider();
        this.initClients();
    }

    public HttpConnector(Proxy config) {
        this.httpProxyUrl = config.getHttp().getUrl().getHost();
        this.httpProxyPort = config.getHttp().getUrl().getPort() + "";
        this.httpsProxyUrl = config.getHttps().getUrl().getHost();
        this.httpsProxyPort = config.getHttps().getUrl().getPort() + "";
        this.httpProxyUsername = config.getHttp().getUsername();
        this.httpProxyPassword = config.getHttp().getPassword();
        this.httpsProxyUsername = config.getHttps().getUsername();
        this.httpsProxyPassword = config.getHttps().getPassword();
        this.credentialsProvider = this.initializeCredentialsProvider();
        this.initClients();
    }

    private void initClients() {
        this.httpc = this.initializeCloseableHttpClient(PROTOCOL_HTTP);
        this.httpsc = this.httpProxyUrl == null && this.httpsProxyUrl == null ? this.httpc : (this.httpsProxyUrl == null || this.httpProxyPort.equalsIgnoreCase(this.httpsProxyPort) && this.httpProxyUrl.equalsIgnoreCase(this.httpsProxyUrl) ? this.httpc : this.initializeCloseableHttpClient(PROTOCOL_HTTPS));
    }

    public void closeClients() throws IOException {
        if (this.httpc != null) {
            this.httpc.close();
        }
        if (this.httpsc != null) {
            this.httpsc.close();
        }
    }

    public CloseableHttpResponse doAction(String action, String URL2, HashMap<String, String> headers, HashMap<String, String> params, String mediaType, String request, Boolean preemptiveAuth, Boolean preemptiveProxyAuthentication) throws HttpConnectorException {
        return this.doAction(action, URL2, headers, params, mediaType, request, preemptiveAuth, preemptiveProxyAuthentication, 0);
    }

    public CloseableHttpResponse doAction(String action, String URL2, HashMap<String, String> headers, HashMap<String, String> params, String mediaType, String request, Boolean preemptiveAuth, Boolean preemptiveProxyAuthentication, int retryCount) throws HttpConnectorException {
        CloseableHttpClient httpClient;
        URL targetURL;
        if (mediaType == null) {
            mediaType = "application/json";
        }
        try {
            targetURL = new URL(URL2);
        }
        catch (MalformedURLException e) {
            StackTraceElement[] stacktrace = e.getStackTrace();
            throw new HttpConnectorException(stacktrace[2] + ": Malformed URL provided by " + stacktrace[3] + " with URL = " + URL2);
        }
        int targetPort = targetURL.getPort();
        HttpHost proxy = null;
        if (targetPort < 0) {
            int n = targetPort = targetURL.getProtocol().equalsIgnoreCase(PROTOCOL_HTTPS) ? 443 : 80;
        }
        if (targetURL.getProtocol().equalsIgnoreCase(PROTOCOL_HTTPS)) {
            httpClient = this.httpsc;
            if (preemptiveProxyAuthentication.booleanValue()) {
                proxy = this.getHttpProxy();
            }
        } else {
            httpClient = this.httpc;
            if (preemptiveProxyAuthentication.booleanValue()) {
                proxy = this.getHttpsProxy();
            }
        }
        if (httpClient == null) {
            throw new HttpConnectorException("HttpConnector : httpclient is null");
        }
        HttpHost target = new HttpHost(targetURL.getHost(), targetPort, targetURL.getProtocol());
        BasicAuthCache authCache = new BasicAuthCache();
        boolean addAuthCache = false;
        if (preemptiveProxyAuthentication.booleanValue()) {
            if (proxy == null) {
                throw new HttpConnectorException("HttpConnector : preemptiveProxy expected, but proxy is null");
            }
            BasicScheme basicAuthProxy = new BasicScheme(ChallengeState.PROXY);
            authCache.put(proxy, (AuthScheme)basicAuthProxy);
            logger.debug("AuthCache: proxy host " + authCache.get(proxy).toString());
            addAuthCache = true;
        }
        if (preemptiveAuth.booleanValue()) {
            BasicScheme basicAuthTarget = new BasicScheme(ChallengeState.TARGET);
            authCache.put(target, (AuthScheme)basicAuthTarget);
            logger.debug("AuthCache: target host " + authCache.get(target).toString());
            addAuthCache = true;
        }
        HttpClientContext localContext = HttpClientContext.create();
        if (addAuthCache) {
            localContext.setAuthCache((AuthCache)authCache);
        }
        if (this.credentialsProvider != null) {
            localContext.setCredentialsProvider(this.credentialsProvider);
        }
        localContext.setCookieStore((CookieStore)new BasicCookieStore());
        if (action.equalsIgnoreCase("PUT")) {
            HttpPut httpPut = new HttpPut(URL2);
            logger.debug("request line:" + httpPut.getRequestLine());
            StringEntity entity = new StringEntity(request, StandardCharsets.UTF_8);
            entity.setContentType(mediaType);
            httpPut.setHeader("Content-Type", mediaType);
            httpPut.setEntity((HttpEntity)entity);
            if (headers != null && !headers.isEmpty()) {
                for (Map.Entry<String, String> header : headers.entrySet()) {
                    httpPut.addHeader(header.getKey(), header.getValue());
                }
            }
            return this.executeRequest(target, (HttpRequest)httpPut, localContext, retryCount);
        }
        if (action.equalsIgnoreCase("POST")) {
            HttpPost httpPost = new HttpPost(URL2);
            logger.debug("request line:" + httpPost.getRequestLine());
            StringEntity entity = new StringEntity(request, StandardCharsets.UTF_8);
            entity.setContentType(mediaType);
            httpPost.setHeader("Content-Type", mediaType);
            httpPost.setEntity((HttpEntity)entity);
            if (headers != null && !headers.isEmpty()) {
                for (Map.Entry<String, String> header : headers.entrySet()) {
                    httpPost.addHeader(header.getKey(), header.getValue());
                }
            }
            return this.executeRequest(target, (HttpRequest)httpPost, localContext, retryCount);
        }
        if (action.equalsIgnoreCase("GET")) {
            if (params != null && !params.isEmpty()) {
                if (!URL2.endsWith("?")) {
                    URL2 = URL2 + "?";
                }
                ArrayList<BasicNameValuePair> transparams = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, String> param : params.entrySet()) {
                    transparams.add(new BasicNameValuePair(param.getKey(), param.getValue()));
                }
                String paramString = URLEncodedUtils.format(transparams, (Charset)StandardCharsets.UTF_8);
                URL2 = URL2 + paramString;
            }
            HttpGet httpGet = new HttpGet(URL2);
            if (headers != null && !headers.isEmpty()) {
                for (Map.Entry<String, String> header : headers.entrySet()) {
                    httpGet.addHeader(header.getKey(), header.getValue());
                }
            }
            return this.executeRequest(target, (HttpRequest)httpGet, localContext, retryCount);
        }
        throw new HttpConnectorException("Action method " + action + " is not supported by this connector");
    }

    public HashMap<String, Object> doActionHashMap(String action, String URL2, HashMap<String, String> headers, HashMap<String, String> params, String contentType, String request, Boolean preemptiveAuth, Boolean preemptiveProxy) throws HttpConnectorException {
        return this.doActionHashMap(action, URL2, headers, params, contentType, request, preemptiveAuth, preemptiveProxy, 0);
    }

    public HashMap<String, Object> doActionHashMap(String action, String URL2, HashMap<String, String> headers, HashMap<String, String> params, String contentType, String request, Boolean preemptiveAuth, Boolean preemptiveProxy, int retryCount) throws HttpConnectorException {
        CloseableHttpResponse response1 = this.doAction(action, URL2, headers, params, contentType, request, preemptiveAuth, preemptiveProxy, retryCount);
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            response.put("body", EntityUtils.toString((HttpEntity)response1.getEntity()));
            response.put("statuscode", response1.getStatusLine().getStatusCode());
            response.put("headers", response1.getHeaders("Content-Type"));
            response1.close();
        }
        catch (IOException e) {
            StackTraceElement[] stacktrace = e.getStackTrace();
            throw new HttpConnectorException(stacktrace[2] + ": IOException, method called by " + stacktrace[3]);
        }
        return response;
    }

    private CloseableHttpResponse executeRequest(HttpHost target, HttpRequest request, HttpClientContext localContext, int retryCount) throws HttpConnectorException {
        DefaultHttpRequestRetryHandler retryHandler = new DefaultHttpRequestRetryHandler(retryCount, false);
        boolean retry = true;
        int retries = 0;
        StackTraceElement[] stacktrace = new StackTraceElement[]{};
        while (retry) {
            try {
                CloseableHttpResponse response = this.getHttpClient(target).execute(target, request, (HttpContext)localContext);
                return response;
            }
            catch (IOException e) {
                retry = retryHandler.retryRequest(e, ++retries, (HttpContext)localContext);
                logger.debug("executeRequest failed, retrying. Attempt #" + retries, (Throwable)e);
                stacktrace = e.getStackTrace();
            }
        }
        throw new HttpConnectorException(stacktrace[2] + ": IOException, method called by " + stacktrace[3]);
    }

    public String addTrailingSlash(String in) {
        return in.replaceAll("/+$", "") + "/";
    }

    public String removeDuplicateSlashes(String in) {
        return in.replaceAll("/+", "/");
    }

    public Client getClient(CloseableHttpClient httpClient, Boolean failOnUnknownProperties) {
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        clientConfig.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        if (!failOnUnknownProperties.booleanValue()) {
            JacksonJsonProvider jacksonJsonProvider = new JacksonJaxbJsonProvider().configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            clientConfig.getSingletons().add(jacksonJsonProvider);
        }
        return new Client((ClientHandler)new ApacheHttpClient4Handler((HttpClient)httpClient, (CookieStore)new BasicCookieStore(), false), (ClientConfig)clientConfig);
    }

    public Client getClient(CloseableHttpClient httpClient) {
        return this.getClient(httpClient, true);
    }

    public Client getJerseyClientForHTTP() {
        return this.getClient(this.getHttpClientForHTTP(), true);
    }

    public Client getJerseyClientForHTTP(Boolean failOnUnknownProperties) {
        return this.getClient(this.getHttpClientForHTTP(), failOnUnknownProperties);
    }

    public Client getJerseyClientForHTTPS() {
        return this.getClient(this.getHttpClientForHTTPS(), true);
    }

    public Client getJerseyClientForHTTPS(Boolean failOnUnknownProperties) {
        return this.getClient(this.getHttpClientForHTTPS(), failOnUnknownProperties);
    }

    public Client getJerseyClient(HttpHost target, Boolean failOnUnknownProperties) {
        return this.getClient(this.getHttpClient(target), failOnUnknownProperties);
    }

    public Client getJerseyClient(HttpHost target) {
        return this.getClient(this.getHttpClient(target), true);
    }

    public Client getJerseyClient(String urlOrScheme) {
        return this.getClient(this.getHttpClient(urlOrScheme), true);
    }

    public Client getJerseyClient(String urlOrScheme, Boolean failOnUnknownProperties) {
        return this.getClient(this.getHttpClient(urlOrScheme), failOnUnknownProperties);
    }

    public Client getJerseyClient(URL url) {
        return this.getClient(this.getHttpClient(url), true);
    }

    public Client getJerseyClient(URL url, Boolean failOnUnknownProperties) {
        return this.getClient(this.getHttpClient(url), failOnUnknownProperties);
    }

    public HttpHost getProxy(String target) throws MalformedURLException {
        URL targetUrl = new URL(target);
        return targetUrl.getProtocol().equalsIgnoreCase(PROTOCOL_HTTPS) ? this.getHttpsProxy() : this.getHttpProxy();
    }

    private HttpHost getHttpsProxy() {
        int myHttpsProxyPort;
        if (this.httpsProxyUrl == null || this.httpsProxyUrl.equals("")) {
            return null;
        }
        try {
            myHttpsProxyPort = Integer.parseInt(this.httpsProxyPort);
            if (myHttpsProxyPort < 0) {
                myHttpsProxyPort = 443;
            }
        }
        catch (Exception e) {
            myHttpsProxyPort = 443;
        }
        return new HttpHost(this.httpsProxyUrl, myHttpsProxyPort);
    }

    private HttpHost getHttpProxy() {
        int myHttpProxyPort;
        if (this.httpProxyUrl == null || this.httpProxyUrl.equals("")) {
            return null;
        }
        try {
            myHttpProxyPort = Integer.parseInt(this.httpProxyPort);
            if (myHttpProxyPort < 0) {
                myHttpProxyPort = 80;
            }
        }
        catch (Exception e) {
            myHttpProxyPort = 80;
        }
        return new HttpHost(this.httpProxyUrl, myHttpProxyPort);
    }

    public CredentialsProvider getCp() {
        return this.credentialsProvider;
    }

    public void setCp(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        this.initClients();
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        this.initClients();
    }

    public CloseableHttpClient getHttpClient(HttpHost target) {
        if (target == null) {
            return null;
        }
        return target.getSchemeName().startsWith(PROTOCOL_HTTPS) ? this.getHttpClientForHTTPS() : this.getHttpClientForHTTP();
    }

    public CloseableHttpClient getHttpClient(URL url) {
        if (url == null) {
            return null;
        }
        return url.getProtocol().equalsIgnoreCase(PROTOCOL_HTTPS) ? this.getHttpClientForHTTPS() : this.getHttpClientForHTTP();
    }

    public CloseableHttpClient getHttpClient(String urlOrScheme) {
        URL target;
        try {
            target = new URL(urlOrScheme);
        }
        catch (MalformedURLException e) {
            if (urlOrScheme.equalsIgnoreCase(PROTOCOL_HTTPS)) {
                return this.getHttpClientForHTTPS();
            }
            if (urlOrScheme.equalsIgnoreCase(PROTOCOL_HTTP)) {
                return this.getHttpClientForHTTP();
            }
            return null;
        }
        return this.getHttpClient(target);
    }

    @Deprecated
    public CloseableHttpClient getHttpc() {
        return this.httpc;
    }

    public CloseableHttpClient getHttpClientForHTTP() {
        return this.httpc;
    }

    @Deprecated
    public CloseableHttpClient getHttpsc() {
        return this.httpsc;
    }

    public CloseableHttpClient getHttpClientForHTTPS() {
        return this.httpsc;
    }

    private CloseableHttpClient initializeCloseableHttpClient(String protocol) {
        HttpHost proxy;
        HttpHost httpHost = proxy = protocol.equalsIgnoreCase(PROTOCOL_HTTP) ? this.getHttpProxy() : this.getHttpsProxy();
        if (this.userAgent != null && this.userAgent.length() > 0) {
            BasicHeader header = new BasicHeader("User-Agent", this.userAgent);
            Iterator<Header> iterator = this.customHeaders.iterator();
            while (iterator.hasNext()) {
                Header h = iterator.next();
                if (!h.getName().equalsIgnoreCase(header.getName())) continue;
                iterator.remove();
            }
            this.customHeaders.add((Header)header);
        }
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(200);
        cm.setDefaultMaxPerRoute(20);
        Registry authProviders = RegistryBuilder.create().register("Basic", (Object)new BasicSchemeFactory(StandardCharsets.UTF_8)).register("NTLM", (Object)new NTLMSchemeFactory()).register("Digest", (Object)new DigestSchemeFactory(StandardCharsets.UTF_8)).register("Negotiate", (Object)new SPNegoSchemeFactory()).register("Kerberos", (Object)new KerberosSchemeFactory()).build();
        RequestConfig config = RequestConfig.DEFAULT;
        if (this.timeout > 0) {
            config = RequestConfig.custom().setConnectTimeout(this.timeout * 1000).setConnectionRequestTimeout(this.timeout * 1000).setSocketTimeout(this.timeout * 1000).build();
        }
        if (proxy != null) {
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy){

                public HttpRoute determineRoute(HttpHost host, HttpRequest request, HttpContext context) throws HttpException {
                    String hostname = host.getHostName();
                    if (HttpConnector.this.isLoopbackAddress(hostname) || HttpConnector.this.bypassProxyForPrivateNetworks && HttpConnector.this.isLocalAddress(hostname)) {
                        return new HttpRoute(host);
                    }
                    return super.determineRoute(host, request, context);
                }
            };
            return HttpClients.custom().setDefaultAuthSchemeRegistry((Lookup)authProviders).setDefaultCredentialsProvider(this.credentialsProvider).setDefaultHeaders(this.customHeaders).setRoutePlanner((HttpRoutePlanner)routePlanner).setProxy(proxy).setConnectionManager((HttpClientConnectionManager)cm).setDefaultRequestConfig(config).build();
        }
        return HttpClients.custom().setDefaultAuthSchemeRegistry((Lookup)authProviders).setDefaultHeaders(this.customHeaders).setDefaultCredentialsProvider(this.credentialsProvider).setConnectionManager((HttpClientConnectionManager)cm).setDefaultRequestConfig(config).build();
    }

    public void addHttpAuth(String URL2, String username, String password) throws MalformedURLException {
        URL targetURL = new URL(URL2);
        int targetPort = targetURL.getPort();
        this.credentialsProvider.setCredentials(new AuthScope(targetURL.getHost(), targetPort), (Credentials)new UsernamePasswordCredentials(username, password));
        this.initClients();
    }

    public void addCredentials(AuthScope authScope, Credentials credentials) {
        this.credentialsProvider.setCredentials(authScope, credentials);
        this.initClients();
    }

    private CredentialsProvider initializeCredentialsProvider() {
        int myHttpsProxyPort;
        int myHttpProxyPort;
        try {
            myHttpProxyPort = Integer.parseInt(this.httpProxyPort);
        }
        catch (Exception e) {
            myHttpProxyPort = 80;
        }
        try {
            myHttpsProxyPort = Integer.parseInt(this.httpsProxyPort);
        }
        catch (Exception e) {
            myHttpsProxyPort = 443;
        }
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        if (this.httpProxyUrl != null && this.httpProxyUrl.length() > 0) {
            credsProvider.setCredentials(new AuthScope(this.httpProxyUrl, myHttpProxyPort, AuthScope.ANY_REALM, "Basic"), (Credentials)new UsernamePasswordCredentials(this.httpProxyUsername, this.httpProxyPassword));
        }
        if (this.httpsProxyUrl != null && this.httpsProxyUrl.length() > 0) {
            credsProvider.setCredentials(new AuthScope(this.httpsProxyUrl, myHttpsProxyPort, AuthScope.ANY_REALM, "Basic"), (Credentials)new UsernamePasswordCredentials(this.httpsProxyUsername, this.httpsProxyPassword));
        }
        logger.debug("CredentialsProvider initialized");
        return credsProvider;
    }

    private boolean isLocalAddress(String ipAddress) {
        try {
            InetAddress ad = InetAddress.getByName(ipAddress);
            return ad.isSiteLocalAddress();
        }
        catch (UnknownHostException e) {
            logger.trace("Caught an Exception while trying to check if an address is local. Return false.");
            return false;
        }
    }

    private boolean isLoopbackAddress(String ipAddress) {
        try {
            InetAddress ad = InetAddress.getByName(ipAddress);
            return ad.isLoopbackAddress();
        }
        catch (UnknownHostException e) {
            logger.trace("Caught an Exception while trying to check if an address is a loopback address. Return false.");
            return false;
        }
    }

    public List<Header> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(List<Header> customHeaders) {
        this.customHeaders = customHeaders;
        this.initClients();
    }

    public void addCustomHeader(Header customHeader) {
        Iterator<Header> iterator = this.customHeaders.iterator();
        while (iterator.hasNext()) {
            Header header = iterator.next();
            if (!header.getName().equalsIgnoreCase(customHeader.getName())) continue;
            iterator.remove();
        }
        this.customHeaders.add(customHeader);
        this.initClients();
    }

    public void addCustomHeader(String key, String value) {
        this.addCustomHeader((Header)new BasicHeader(key, value));
    }
}

