/*
 * Decompiled with CFR 0.152.
 */
package de.samply.auth.utils;

import de.samply.auth.rest.Scope;
import de.samply.common.config.OAuth2Client;
import de.samply.string.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public class OAuth2ClientConfig {
    public static String getHost(OAuth2Client config, String serverName) {
        String host = config.getHost();
        if (config.getAdditionalHostnames() != null) {
            for (OAuth2Client.AdditionalHostnames.Hostname hostname : config.getAdditionalHostnames().getHostname()) {
                if (!serverName.toLowerCase().equals(hostname.getIfServernameEquals())) continue;
                host = hostname.getHost();
            }
        }
        return host;
    }

    public static String getRedirectUrl(OAuth2Client config, String scheme, String serverName, int port, String contextPath, String redirectUrl, Scope ... scopes) throws UnsupportedEncodingException {
        return OAuth2ClientConfig.getRedirectUrl(config, scheme, serverName, port, contextPath, redirectUrl, null, null, scopes);
    }

    public static String getRedirectUrl(OAuth2Client config, String scheme, String serverName, int port, String contextPath, String redirectUrl, String ip, Scope ... scopes) throws UnsupportedEncodingException {
        return OAuth2ClientConfig.getRedirectUrl(config, scheme, serverName, port, contextPath, redirectUrl, ip, null, scopes);
    }

    public static String getRedirectUrl(OAuth2Client config, String scheme, String serverName, int port, String contextPath, String redirectUrl, String ip, String state, Scope ... scopes) throws UnsupportedEncodingException {
        String redirectUri = OAuth2ClientConfig.getLocalRedirectUrl(config, scheme, serverName, port, contextPath, redirectUrl);
        String host = OAuth2ClientConfig.getHost(config, serverName);
        StringBuilder builder = new StringBuilder(host);
        if (config.isUseSamplyAuth()) {
            builder.append("/grant.xhtml?");
        } else {
            builder.append(OAuth2ClientConfig.getEndpointPrefix(config.getRealm()));
            builder.append("auth");
            builder.append("?response_type=code&");
        }
        builder.append("client_id=").append(URLEncoder.encode(config.getClientId(), StandardCharsets.UTF_8.displayName()));
        builder.append("&scope=").append(URLEncoder.encode(StringUtil.join((Object[])scopes, (String)" ", Scope::getIdentifier), StandardCharsets.UTF_8.displayName()));
        builder.append("&redirect_uri=").append(URLEncoder.encode(redirectUri, StandardCharsets.UTF_8.displayName()));
        if (!StringUtil.isEmpty((String)ip)) {
            builder.append("&ip=").append(URLEncoder.encode(ip, StandardCharsets.UTF_8.displayName()));
        } else if (!StringUtil.isEmpty((String)config.getExternalIP())) {
            builder.append("&ip=").append(URLEncoder.encode(config.getExternalIP(), StandardCharsets.UTF_8.displayName()));
        }
        if (!StringUtil.isEmpty((String)state)) {
            builder.append("&state=").append(URLEncoder.encode(state, StandardCharsets.UTF_8.displayName()));
        }
        return builder.toString();
    }

    public static String getLocalRedirectUrl(OAuth2Client config, String scheme, String serverName, int port, String contextPath, String redirectUrl) {
        return OAuth2ClientConfig.getLocalRedirectUrl(scheme, serverName, port, contextPath, redirectUrl);
    }

    public static String getLocalRedirectUrl(String scheme, String serverName, int port, String contextPath, String redirectUrl) {
        String strPort = port == 80 || port == 443 ? "" : ":" + port;
        return scheme + "://" + serverName + strPort + contextPath + redirectUrl;
    }

    public static String getLogoutUrl(OAuth2Client config, String scheme, String serverName, int port, String contextPath, String localRedirectUrl) throws UnsupportedEncodingException {
        String redirect = OAuth2ClientConfig.getLocalRedirectUrl(config, scheme, serverName, port, contextPath, localRedirectUrl);
        String host = OAuth2ClientConfig.getHost(config, serverName);
        StringBuilder builder = new StringBuilder(host);
        if (config.isUseSamplyAuth()) {
            builder.append("/logout.xhtml?redirect_uri=").append(URLEncoder.encode(redirect, StandardCharsets.UTF_8.displayName())).append("&client_id=").append(URLEncoder.encode(config.getClientId(), StandardCharsets.UTF_8.displayName()));
        } else {
            builder.append(OAuth2ClientConfig.getEndpointPrefix(config.getRealm()));
            builder.append("logout?redirect_uri=");
            builder.append(URLEncoder.encode(redirect, StandardCharsets.UTF_8.displayName()));
        }
        return builder.toString();
    }

    public static String getEndpointPrefix(String realm) {
        return "/realms/" + realm + "/protocol/openid-connect/";
    }
}

