/*
 * Decompiled with CFR 0.152.
 */
package de.samply.auth.utils;

import de.samply.string.util.StringUtil;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class HashUtils {
    public static String sha1(String input) {
        return HashUtils.sha1(input.getBytes(StandardCharsets.UTF_8));
    }

    public static String sha1(byte[] input) {
        try {
            return HashUtils.hash("SHA-1", input);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String sha512(String input) {
        return HashUtils.sha512(input.getBytes(StandardCharsets.UTF_8));
    }

    public static String sha512(byte[] input) {
        try {
            return HashUtils.hash("SHA-512", input);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String hash(String algorithm, byte[] input) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance(algorithm);
        digest.update(input);
        return Hex.encodeHexString((byte[])digest.digest());
    }

    public static String getFingerPrint(String base64EncodedKey) {
        return StringUtil.join((String[])Objects.requireNonNull(HashUtils.sha1(Base64.decodeBase64((String)base64EncodedKey))).split("(?<=\\G.{2})"), (String)":");
    }
}

