/*
 * Decompiled with CFR 0.152.
 */
package de.samply.auth.client.jwt;

import de.samply.auth.client.jwt.AbstractJwt;
import de.samply.auth.client.jwt.JwtException;
import de.samply.common.config.OAuth2Client;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;

public class JwtAccessToken
extends AbstractJwt {
    private static final long serialVersionUID = 1399797953598510747L;
    private List<String> realmRoles = new ArrayList<String>();
    private Map<String, List<String>> resourceRoles = new HashMap<String, List<String>>();

    public JwtAccessToken(PublicKey key, String serialized) throws JwtException {
        super(key, serialized);
    }

    public JwtAccessToken(PublicKey key, String serialized, boolean externalValidation) throws JwtException {
        super(key, serialized, externalValidation);
        this.init();
    }

    public JwtAccessToken(OAuth2Client config, String serialized) throws JwtException {
        super(config, serialized);
        this.init();
    }

    public JwtAccessToken(OAuth2Client config, String serialized, boolean externalValidation) throws JwtException {
        super(config, serialized, externalValidation);
        this.init();
    }

    private void init() {
        try {
            JSONObject realmAccessClaims = (JSONObject)this.getClaimsSet().getClaim("realm_access");
            JSONArray roleClaims = (JSONArray)realmAccessClaims.get((Object)"roles");
            for (Object roleClaim : roleClaims) {
                this.realmRoles.add((String)roleClaim);
            }
            JSONObject resourceAccessClaims = (JSONObject)this.getClaimsSet().getClaim("resource_access");
            for (Map.Entry entry : resourceAccessClaims.entrySet()) {
                ArrayList<String> roles = new ArrayList<String>();
                JSONObject resourceAccessClaim = (JSONObject)entry.getValue();
                JSONArray resourceAccessRoleClaim = (JSONArray)resourceAccessClaim.get((Object)"roles");
                for (Object roleClaim : resourceAccessRoleClaim) {
                    roles.add((String)roleClaim);
                }
                this.resourceRoles.put((String)entry.getKey(), (List<String>)roles);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<String> getScopes() {
        try {
            return new ArrayList<String>(Arrays.asList(((String)this.getClaimsSet().getClaim("scope")).split(" ")));
        }
        catch (NullPointerException npe) {
            System.err.println("NPE caught. Returning empty list");
            return new ArrayList<String>();
        }
    }

    public boolean isExtended() {
        return this.getClaimsSet().getClaim("key") != null;
    }

    public String getState() {
        return (String)this.getClaimsSet().getClaim("state");
    }

    public String getHeader() {
        return "Bearer " + this.getSerialized();
    }

    public List<String> getRealmRoles() {
        return this.realmRoles;
    }

    public Map<String, List<String>> getResourceRoles() {
        return this.resourceRoles;
    }

    @Override
    protected String getTokenType() {
        return "ACCESS_TOKEN";
    }
}

