/*
 * Decompiled with CFR 0.152.
 */
package de.samply.auth.client.jwt;

import de.samply.auth.client.jwt.AbstractJwt;
import de.samply.auth.client.jwt.JwtException;
import de.samply.auth.client.jwt.KeyLoader;
import de.samply.auth.rest.LocationDto;
import de.samply.auth.rest.RoleDto;
import de.samply.auth.rest.Usertype;
import de.samply.common.config.OAuth2Client;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONObject;

public class JwtIdToken
extends AbstractJwt {
    private static final long serialVersionUID = -4323096832195533045L;
    private final String clientId;
    private List<LocationDto> locations = new ArrayList<LocationDto>();
    private List<RoleDto> roles = new ArrayList<RoleDto>();
    private Map<String, List<String>> permissions = new HashMap<String, List<String>>();

    public JwtIdToken(OAuth2Client config, String serialized) throws JwtException {
        this(config.getClientId(), KeyLoader.loadKey(config.getHostPublicKey()), serialized);
    }

    public JwtIdToken(OAuth2Client config, String serialized, boolean externalValidation) throws JwtException {
        this(config.getClientId(), KeyLoader.loadKey(config.getHostPublicKey()), serialized, externalValidation);
    }

    public JwtIdToken(String clientId, PublicKey publicKey, String serialized) throws JwtException {
        this(clientId, publicKey, serialized, false);
    }

    public JwtIdToken(String clientId, PublicKey publicKey, String serialized, boolean externalValidation) throws JwtException {
        super(publicKey, serialized, externalValidation);
        Object permissionsClaim;
        Object rolesClaim;
        this.clientId = clientId;
        Object locationsClaim = this.getClaimsSet().getClaim("locations");
        if (locationsClaim instanceof List) {
            List list = (List)locationsClaim;
            for (Object o : list) {
                if (!(o instanceof JSONObject)) continue;
                JSONObject json = (JSONObject)o;
                LocationDto location = new LocationDto();
                location.setContact((String)json.get((Object)"locationContact"));
                location.setDescription((String)json.get((Object)"locationDescription"));
                location.setId((String)json.get((Object)"locationIdentifier"));
                location.setName((String)json.get((Object)"locationName"));
                this.locations.add(location);
            }
        }
        if ((rolesClaim = this.getClaimsSet().getClaim("roles")) instanceof List) {
            List list = (List)rolesClaim;
            for (Object o : list) {
                if (!(o instanceof JSONObject)) continue;
                JSONObject json = (JSONObject)o;
                RoleDto role = new RoleDto();
                role.setIdentifier((String)json.get((Object)"roleIdentifier"));
                role.setDescription((String)json.get((Object)"roleDescription"));
                role.setName((String)json.get((Object)"roleName"));
                this.roles.add(role);
            }
        }
        if ((permissionsClaim = this.getClaimsSet().getClaim("permissions")) instanceof Map) {
            Map map = (Map)permissionsClaim;
            for (String key : map.keySet()) {
                this.permissions.put(key, (List)map.get(key));
            }
        }
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.getClaimsSet().getAudience().contains(this.clientId);
    }

    public String getEmail() {
        return (String)this.getClaimsSet().getClaim("email");
    }

    public String getName() {
        String name = (String)this.getClaimsSet().getClaim("name");
        if (name != null && !name.equals("")) {
            return name;
        }
        return (String)this.getClaimsSet().getClaim("preferred_username");
    }

    public String getLanguage() {
        return (String)this.getClaimsSet().getClaim("lang");
    }

    public Usertype getUsertype() {
        try {
            return Usertype.valueOf((String)this.getClaimsSet().getClaim("usertype"));
        }
        catch (Exception e) {
            return Usertype.NORMAL;
        }
    }

    public String getExternalLabel() {
        return (String)this.getClaimsSet().getClaim("externalLabel");
    }

    public List<RoleDto> getRoles() {
        return this.roles;
    }

    public List<LocationDto> getLocations() {
        return this.locations;
    }

    @Override
    protected String getTokenType() {
        return "ID_TOKEN";
    }

    public Map<String, List<String>> getPermissions() {
        return this.permissions;
    }
}

