/*
 * Decompiled with CFR 0.152.
 */
package de.samply.auth.client.jwt;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.security.PrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Calendar;
import java.util.UUID;

public class Jwt {
    private final String jwtid;
    protected JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder();

    public Jwt(String type, int hours) {
        this.builder.claim("type", (Object)type);
        Calendar cal = Calendar.getInstance();
        cal.add(12, -15);
        this.builder.notBeforeTime(cal.getTime());
        cal = Calendar.getInstance();
        cal.add(10, hours);
        this.builder.expirationTime(cal.getTime());
        this.jwtid = UUID.randomUUID().toString();
        this.builder.jwtID(this.getJwtid());
    }

    protected String sign(PrivateKey privateKey) throws JOSEException {
        if (privateKey instanceof RSAPrivateKey) {
            SignedJWT signedJwt = new SignedJWT(new JWSHeader(JWSAlgorithm.RS512), this.builder.build());
            RSASSASigner signer = new RSASSASigner(privateKey);
            signedJwt.sign((JWSSigner)signer);
            return signedJwt.serialize();
        }
        if (privateKey instanceof ECPrivateKey) {
            SignedJWT signedJwt = new SignedJWT(new JWSHeader(JWSAlgorithm.ES512), this.builder.build());
            ECDSASigner signer = new ECDSASigner((ECPrivateKey)privateKey);
            signedJwt.sign((JWSSigner)signer);
            return signedJwt.serialize();
        }
        throw new UnsupportedOperationException("Unknown key type: " + privateKey.getClass().getCanonicalName());
    }

    public JWTClaimsSet.Builder getBuilder() {
        return this.builder;
    }

    public String getJwtid() {
        return this.jwtid;
    }
}

