/*
 * Decompiled with CFR 0.152.
 */
package de.samply.auth.client.jwt;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.ECDSAVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.SignedJWT;
import de.samply.auth.client.jwt.JwtException;
import de.samply.auth.client.jwt.JwtInvalidSignatureFormatException;
import de.samply.auth.client.jwt.JwtKeyMismatchException;
import de.samply.auth.client.jwt.JwtParseException;
import de.samply.auth.client.jwt.KeyLoader;
import de.samply.common.config.OAuth2Client;
import java.io.Serializable;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJwt
implements Serializable {
    private static final long serialVersionUID = -6242591976053763039L;
    private static final Logger logger = LoggerFactory.getLogger(AbstractJwt.class);
    private final String serialized;
    private boolean signatureValid = false;
    private boolean externalValidation;
    private transient JWTClaimsSet claimsSet;
    private PublicKey publicKey;

    protected AbstractJwt(OAuth2Client config, String serialized) throws JwtException {
        this(KeyLoader.loadKey(config.getHostPublicKey()), serialized, false);
    }

    protected AbstractJwt(OAuth2Client config, String serialized, boolean externalValidation) throws JwtException {
        this(KeyLoader.loadKey(config.getHostPublicKey()), serialized, externalValidation);
    }

    protected AbstractJwt(PublicKey publicKey, String serialized) throws JwtException {
        this(publicKey, serialized, false);
    }

    protected AbstractJwt(PublicKey publicKey, String serialized, boolean externalValidation) throws JwtException {
        this.serialized = serialized;
        this.publicKey = publicKey;
        this.externalValidation = externalValidation;
        try {
            this.reloadClaimsSet();
        }
        catch (ParseException e) {
            throw new JwtParseException(e);
        }
        catch (JOSEException e) {
            throw new JwtInvalidSignatureFormatException();
        }
    }

    private void reloadClaimsSet() throws ParseException, JOSEException, JwtKeyMismatchException {
        Base64URL[] parsedParts = JWTParser.parse((String)this.serialized).getParsedParts();
        SignedJWT signed = new SignedJWT(parsedParts[0], parsedParts[1], parsedParts[2]);
        this.claimsSet = signed.getJWTClaimsSet();
        if (this.externalValidation) {
            this.signatureValid = true;
        } else {
            RSASSAVerifier verifier;
            boolean isHmac;
            JWSAlgorithm algorithm = signed.getHeader().getAlgorithm();
            boolean isRsa = algorithm == JWSAlgorithm.RS256 || algorithm == JWSAlgorithm.RS384 || algorithm == JWSAlgorithm.RS512;
            boolean isEC = algorithm == JWSAlgorithm.ES256 || algorithm == JWSAlgorithm.ES384 || algorithm == JWSAlgorithm.ES512;
            boolean bl = isHmac = algorithm == JWSAlgorithm.HS256 || algorithm == JWSAlgorithm.HS384 || algorithm == JWSAlgorithm.HS512;
            if (this.publicKey instanceof RSAPublicKey && isRsa) {
                verifier = new RSASSAVerifier((RSAPublicKey)this.publicKey);
            } else if (this.publicKey instanceof ECPublicKey && isEC) {
                ECPublicKey ecPublicKey = (ECPublicKey)this.publicKey;
                verifier = new ECDSAVerifier(ecPublicKey);
            } else {
                if (isHmac) {
                    logger.warn("HMAC signature can't be verified. Verification must be done server-sided. Deal with verification in calling application and pass externalValidation=true to the JWT constructor.");
                    this.signatureValid = this.externalValidation;
                    return;
                }
                throw new JwtKeyMismatchException();
            }
            this.signatureValid = signed.verify((JWSVerifier)verifier);
        }
    }

    public boolean isValid() {
        Date now = new Date();
        return this.signatureValid && now.before(this.getClaimsSet().getExpirationTime()) && (this.getClaimsSet().getNotBeforeTime() == null || now.after(this.getClaimsSet().getNotBeforeTime()));
    }

    public JWTClaimsSet getClaimsSet() {
        if (this.claimsSet == null) {
            try {
                this.reloadClaimsSet();
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.claimsSet;
    }

    public String getSerialized() {
        return this.serialized;
    }

    public String getSubject() {
        return this.getClaimsSet().getSubject();
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    protected abstract String getTokenType();
}

