/*
 * Decompiled with CFR 0.152.
 */
package de.samply.auth.oidc;

import de.samply.auth.client.jwt.JwtAccessToken;
import de.samply.auth.client.jwt.JwtException;
import de.samply.auth.oidc.OpenIdConnectAccessTokenDto;
import de.samply.auth.rest.UserDto;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenIdConnectClient {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static Logger logger = LoggerFactory.getLogger(OpenIdConnectClient.class);
    private String url;
    private String urlExt;
    private String publicKey;
    private String clientId;
    private String clientSecret;
    private Client client;

    public OpenIdConnectClient(String url, String urlExt, String publicKey, String clientId, String clientSecret, Client client) {
        this.setUrl(url);
        this.setUrlExt(urlExt);
        this.publicKey = publicKey;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.client = client;
    }

    public UserDto getNewUserInfo(String authorizationHeader) {
        UserDto userDto = (UserDto)this.client.target(this.getBaseUrl()).path("userinfo").request(new String[]{"application/json"}).header(AUTHORIZATION_HEADER, (Object)authorizationHeader).get(UserDto.class);
        return userDto;
    }

    public String getRedirectUrl(String localRedirectUrl) {
        StringBuilder builder = new StringBuilder(this.getBaseUrl());
        builder.append("authorize?");
        try {
            builder.append("scope=openid+email+profile+groupNames");
            builder.append("&redirect_uri=").append(URLEncoder.encode(localRedirectUrl, StandardCharsets.UTF_8.displayName()));
            builder.append("&client_id=").append(URLEncoder.encode(this.clientId, StandardCharsets.UTF_8.displayName()));
            builder.append("&client_secret=").append(URLEncoder.encode(this.clientSecret, StandardCharsets.UTF_8.displayName()));
            builder.append("&response_type=code");
            logger.debug("Redirect URL: " + builder.toString());
            return builder.toString();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getBaseUrl() {
        String resultUrl = !this.url.endsWith("/") && !this.urlExt.startsWith("/") ? this.url + "/" + this.urlExt : (this.url.endsWith("/") && this.urlExt.startsWith("/") ? this.url + this.urlExt.substring(1) : this.url + this.urlExt);
        if (!resultUrl.endsWith("/")) {
            resultUrl = resultUrl + "/";
        }
        return resultUrl;
    }

    public OpenIdConnectAccessTokenDto getAccessTokenDto(String code, String localRedirectUrl) throws JwtException {
        WebTarget target = this.client.target(this.getBaseUrl() + "token");
        MultivaluedHashMap values = new MultivaluedHashMap();
        values.add((Object)"grant_type", (Object)"authorization_code");
        values.add((Object)"client_id", (Object)this.clientId);
        values.add((Object)"client_secret", (Object)this.clientSecret);
        values.add((Object)"redirect_uri", (Object)localRedirectUrl);
        values.add((Object)"code", (Object)code);
        OpenIdConnectAccessTokenDto openIdConnectAccessTokenDto = null;
        try {
            openIdConnectAccessTokenDto = (OpenIdConnectAccessTokenDto)target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity((Object)values, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE), OpenIdConnectAccessTokenDto.class);
            return openIdConnectAccessTokenDto;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public String getAuthorizationHeader(JwtAccessToken accessToken) {
        if (accessToken != null) {
            return accessToken.getHeader();
        }
        return "Basic " + Base64.encodeBase64String((byte[])(this.clientId + ":" + this.clientSecret).getBytes());
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrlExt() {
        return this.urlExt;
    }

    public void setUrlExt(String urlExt) {
        this.urlExt = urlExt;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }
}

