/*
 * Decompiled with CFR 0.152.
 */
package de.samply.auth.client;

import de.samply.auth.client.AuthClient;
import de.samply.auth.client.InvalidTokenException;
import de.samply.auth.client.RegistrationWrapper;
import de.samply.auth.client.jwt.JwtAccessToken;
import de.samply.auth.client.jwt.JwtException;
import de.samply.auth.client.jwt.JwtIdToken;
import de.samply.auth.client.jwt.JwtRefreshToken;
import de.samply.auth.client.jwt.KeyLoader;
import de.samply.auth.rest.AccessTokenDto;
import de.samply.auth.rest.AccessTokenRequestDto;
import de.samply.auth.rest.KeyIdentificationDto;
import de.samply.auth.rest.LocationDto;
import de.samply.auth.rest.LocationListDto;
import de.samply.auth.rest.OAuth2Discovery;
import de.samply.auth.rest.RegistrationRequestDto;
import de.samply.auth.rest.RoleDto;
import de.samply.auth.rest.RoleListDto;
import de.samply.auth.rest.SignRequestDto;
import de.samply.auth.rest.UserListDto;
import de.samply.auth.utils.HashUtils;
import de.samply.common.config.OAuth2Client;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;

public class SamplyAuthClient
extends AuthClient {
    private static final String OAUTH2_PATH = "oauth2";

    public SamplyAuthClient(JwtAccessToken accessToken, JwtIdToken idToken, JwtRefreshToken refreshToken, OAuth2Client config, Client client, String state) {
        super(config.getHost(), accessToken, idToken, refreshToken, config, KeyLoader.loadKey((String)config.getHostPublicKey()), null, null, client, state, null, null, null, null);
    }

    public SamplyAuthClient(String code, OAuth2Client config, Client client, String state) {
        super(config.getHost(), null, null, null, config, KeyLoader.loadKey((String)config.getHostPublicKey()), null, code, client, state, null, null, null, null);
    }

    public SamplyAuthClient(PrivateKey privKey, OAuth2Client config, Client client, String state) {
        super(config.getHost(), null, null, null, config, KeyLoader.loadKey((String)config.getHostPublicKey()), privKey, null, client, state, null, null, null, null);
    }

    @Override
    public JwtIdToken getIdToken() throws InvalidTokenException {
        if (this.code == null) {
            return null;
        }
        return super.getIdToken();
    }

    @Override
    public UserListDto searchUser(String input) throws InvalidTokenException {
        return (UserListDto)this.getSearchUserRequestBuilder(input).header("Authorization", (Object)this.getAccessToken().getHeader()).get(UserListDto.class);
    }

    @Override
    public List<LocationDto> getLocations() {
        return ((LocationListDto)this.getLocationsRequestBuilder().header("Authorization", (Object)this.getAuthorizationHeader()).get(LocationListDto.class)).getLocations();
    }

    @Override
    public Response register(RegistrationWrapper wrapper) {
        RegistrationRequestDto dto = wrapper.getRegReq();
        if (dto == null) {
            return null;
        }
        dto.setBase64EncodedPublicKey(Base64.encodeBase64String((byte[])KeyLoader.loadPublicRsaKey((PrivateKey)this.privateKey).getEncoded()));
        return this.getRegisterRequestBuilder().accept(new String[]{"application/json"}).post(Entity.json((Object)dto));
    }

    @Override
    protected JwtAccessToken getNewAccessToken() throws JwtException, InvalidTokenException {
        this.logger.debug("Requesting new access token, base URL: " + this.baseUrl);
        if (this.code != null || this.refreshToken != null) {
            Invocation.Builder builder = this.getAccessTokenRequestBuilder();
            AccessTokenRequestDto dto = new AccessTokenRequestDto();
            if (this.refreshToken == null) {
                this.logger.debug("No refresh token available yet");
                dto.setClientId(this.config.getClientId());
                dto.setClientSecret(this.config.getClientSecret());
                dto.setCode(this.code);
            } else {
                this.logger.debug("Using the refresh token");
                dto.setRefreshToken(this.refreshToken.getSerialized());
            }
            AccessTokenDto tokenDto = (AccessTokenDto)builder.post(Entity.json((Object)dto), AccessTokenDto.class);
            this.accessToken = new JwtAccessToken(this.publicKey, tokenDto.getAccessToken());
            this.idToken = new JwtIdToken(this.config.getClientId(), this.publicKey, tokenDto.getIdToken());
            this.refreshToken = new JwtRefreshToken(this.publicKey, tokenDto.getRefreshToken());
            if (!(this.accessToken.isValid() && this.idToken.isValid() && this.refreshToken.isValid())) {
                this.logger.debug("The token we got was not valid. Throw an exception.");
                throw new InvalidTokenException();
            }
            this.logger.debug("Got new valid access token using a code!");
            return this.accessToken;
        }
        if (this.privateKey != null) {
            this.logger.debug("Requesting a code to sign");
            try {
                PublicKey publicKey = KeyLoader.loadPublicRsaKey((PrivateKey)this.privateKey);
                KeyIdentificationDto dto = new KeyIdentificationDto();
                dto.setSha512Hash(HashUtils.sha512((byte[])publicKey.getEncoded()));
                Invocation.Builder builder = this.getSignRequestBuilder();
                SignRequestDto post = (SignRequestDto)builder.post(Entity.json((Object)dto), SignRequestDto.class);
                Signature signature = Signature.getInstance(post.getAlgorithm());
                signature.initSign(this.privateKey);
                signature.update(post.getCode().getBytes(StandardCharsets.UTF_8));
                this.logger.debug("Signing code:" + post.getCode());
                AccessTokenRequestDto accessDto = new AccessTokenRequestDto();
                accessDto.setCode(post.getCode());
                accessDto.setSignature(Base64.encodeBase64String((byte[])signature.sign()));
                builder = this.getAccessTokenRequestBuilder();
                AccessTokenDto tokenDto = (AccessTokenDto)builder.post(Entity.json((Object)accessDto), AccessTokenDto.class);
                this.accessToken = new JwtAccessToken(this.publicKey, tokenDto.getAccessToken());
                this.idToken = null;
                this.refreshToken = null;
                if (!this.accessToken.isValid()) {
                    this.logger.debug("The token we got was not valid. Throw an exception.");
                    throw new InvalidTokenException();
                }
                this.logger.debug("Got new valid access token using a private key!");
                return this.accessToken;
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
                this.logger.debug("Apparently this is not a valid RSA key!");
                throw new InvalidTokenException();
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public OAuth2Discovery getDiscovery() {
        return (OAuth2Discovery)this.getDiscoveryRequestBuilder().get(OAuth2Discovery.class);
    }

    private WebTarget getUriPrefix() {
        return this.client.target(this.baseUrl).path(OAUTH2_PATH);
    }

    @Override
    protected Invocation.Builder getAccessTokenBuilder() {
        return this.getUriPrefix().path("access_token").request(new String[]{"application/json"});
    }

    private Invocation.Builder getAccessTokenRequestBuilder() {
        return this.getUriPrefix().path("access_token").request(new String[]{"application/json"});
    }

    private Invocation.Builder getSignRequestBuilder() {
        return this.client.target(this.baseUrl).path(OAUTH2_PATH).path("sign_request").request(new String[]{"application/json"});
    }

    private Invocation.Builder getRegisterRequestBuilder() {
        return this.getUriPrefix().path("register").request(new String[]{"application/json"});
    }

    private Invocation.Builder getDiscoveryRequestBuilder() {
        return this.getUriPrefix().path(".well-known").path("openid-configuration").request(new String[]{"application/json"});
    }

    private Invocation.Builder getSearchUserRequestBuilder(String input) {
        return this.getUriPrefix().path("users").path("search").queryParam("query", new Object[]{input}).request(new String[]{"application/json"});
    }

    private Invocation.Builder getLocationsRequestBuilder() {
        return this.getUriPrefix().path("locations").request(new String[]{"application/json"});
    }

    @Override
    protected Invocation.Builder getClientBuilder() {
        return this.getUriPrefix().path("clients").request(new String[]{"application/json"});
    }

    private Invocation.Builder getClientsRequestBuilder() {
        return this.getUriPrefix().path("clients").request(new String[]{"application/json"});
    }

    private Invocation.Builder getRoleRequestBuilder() {
        return this.client.target(this.baseUrl).path(OAUTH2_PATH).path("roles").request(new String[]{"application/json"});
    }

    private Invocation.Builder getRoleRequestBuilder(String identifier) {
        return this.client.target(this.baseUrl).path(OAUTH2_PATH).path("roles").path(identifier).request(new String[]{"application/json"});
    }

    public RoleListDto getRoles() {
        return (RoleListDto)this.getRoleRequestBuilder().header("Authorization", (Object)this.getAuthorizationHeader()).get(RoleListDto.class);
    }

    public RoleDto getRole(String identifier) {
        return (RoleDto)this.getRoleRequestBuilder(identifier).header("Authorization", (Object)this.getAuthorizationHeader()).get(RoleDto.class);
    }
}

