/*
 * Decompiled with CFR 0.152.
 */
package de.samply.auth.client;

import com.nimbusds.jose.JWSAlgorithm;
import de.samply.auth.client.AuthClient;
import de.samply.auth.client.AuthClientUtils;
import de.samply.auth.client.InvalidTokenException;
import de.samply.auth.client.RegistrationWrapper;
import de.samply.auth.client.jwt.AbstractJwt;
import de.samply.auth.client.jwt.JwtAccessToken;
import de.samply.auth.client.jwt.JwtException;
import de.samply.auth.client.jwt.JwtIdToken;
import de.samply.auth.client.jwt.JwtRefreshToken;
import de.samply.auth.client.jwt.KeyLoader;
import de.samply.auth.rest.AccessTokenDto;
import de.samply.auth.rest.ClientListDto;
import de.samply.auth.rest.LocationDto;
import de.samply.auth.rest.LocationListDto;
import de.samply.auth.rest.OAuth2Discovery;
import de.samply.auth.rest.UserListDto;
import de.samply.auth.utils.OAuth2ClientConfig;
import de.samply.common.config.OAuth2Client;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import javax.xml.bind.DatatypeConverter;
import net.minidev.json.JSONObject;
import org.keycloak.representations.idm.UserRepresentation;

public class KeycloakAuthClient
extends AuthClient {
    public KeycloakAuthClient(JwtAccessToken accessToken, JwtIdToken idToken, JwtRefreshToken refreshToken, OAuth2Client config, Client client, String state) {
        super(config.getHost(), accessToken, idToken, refreshToken, config, KeyLoader.loadKey((String)config.getHostPublicKey()), null, null, client, state, null, null, null, null);
    }

    public KeycloakAuthClient(String code, OAuth2Client config, Client client, String state) {
        super(config.getHost(), null, null, null, config, KeyLoader.loadKey((String)config.getHostPublicKey()), null, code, client, state, null, null, null, null);
    }

    public KeycloakAuthClient(OAuth2Client config, Client client, String state) {
        super(config.getHost(), null, null, null, config, KeyLoader.loadKey((String)config.getHostPublicKey()), null, null, client, state, null, null, null, null);
    }

    public KeycloakAuthClient(OAuth2Client config, Client client) {
        super(config.getHost(), null, null, null, config, KeyLoader.loadKey((String)config.getHostPublicKey()), null, null, client, null, null, null, null, null);
    }

    @Override
    public ClientListDto getClients() {
        return (ClientListDto)this.getClientBuilder().get(ClientListDto.class);
    }

    @Override
    public UserListDto searchUser(String input) {
        UserRepresentation[] keycloakUsers = (UserRepresentation[])this.getUserBuilder(input).header("Authorization", (Object)this.getRestAccessToken().getHeader()).get(UserRepresentation[].class);
        return AuthClientUtils.keycloakUsersToSamply(keycloakUsers);
    }

    @Override
    public List<LocationDto> getLocations() {
        return ((LocationListDto)this.getLocationsBuilder().header("Authorization", (Object)this.getAuthorizationHeader()).get(LocationListDto.class)).getLocations();
    }

    @Override
    public Response register(RegistrationWrapper wrapper) {
        UserRepresentation user = wrapper.getUsrRep();
        if (user == null) {
            return null;
        }
        return this.getRegisterBuilder().header("Authorization", (Object)this.getRestAccessToken().getHeader()).post(Entity.json((Object)user));
    }

    @Override
    protected JwtAccessToken getNewAccessToken() throws JwtException, InvalidTokenException {
        this.logger.debug("Requesting new access token, base URL: " + this.baseUrl);
        Invocation.Builder builder = this.getAccessTokenBuilder();
        Form form = new Form();
        if (this.refreshToken != null) {
            form.param("refresh_token", this.refreshToken.getSerialized());
        } else if (this.code != null) {
            form.param("grant_type", "authorization_code");
            form.param("code", this.code);
            form.param("redirect_uri", this.redirectUrl);
            form.param("client_id", this.config.getClientId());
            form.param("client_secret", this.config.getClientSecret());
            form.param("state", this.state);
        } else if (this.grantType.equals("client_credentials")) {
            form.param("grant_type", this.grantType);
            form.param("client_id", this.config.getClientId());
            form.param("client_secret", this.config.getClientSecret());
            form.param("scope", "openid");
        } else if (this.grantType.equals("password")) {
            form.param("grant_type", this.grantType);
            form.param("client_id", this.config.getClientId());
            form.param("client_secret", this.config.getClientSecret());
            form.param("username", this.username);
            form.param("password", this.password);
            form.param("scope", "openid");
        }
        try {
            List supportedRequestObjectSigningAlgs = this.getDiscovery().getSupportedSigningAlgs();
            List supportedIdTokenSigningAlgs = this.getDiscovery().getSupportedIdTokenSigningAlgs();
            List supportedSigningAlgs = Stream.concat(supportedIdTokenSigningAlgs.stream(), supportedRequestObjectSigningAlgs.stream()).collect(Collectors.toList());
            boolean externalValidation = supportedSigningAlgs.contains(JWSAlgorithm.HS256.getName());
            AccessTokenDto tokenDto = (AccessTokenDto)builder.post(Entity.form((Form)form), AccessTokenDto.class);
            this.accessToken = new JwtAccessToken(this.publicKey, tokenDto.getAccessToken(), externalValidation);
            this.idToken = new JwtIdToken(this.config.getClientId(), this.publicKey, tokenDto.getIdToken(), externalValidation);
            this.refreshToken = new JwtRefreshToken(this.publicKey, tokenDto.getRefreshToken(), externalValidation);
            if (!(this.checkTokenValidity((AbstractJwt)this.accessToken, externalValidation) && this.checkTokenValidity((AbstractJwt)this.idToken, externalValidation) && this.checkTokenValidity((AbstractJwt)this.refreshToken, externalValidation))) {
                this.logger.debug("The token we got was not valid. Throw an exception.");
                throw new InvalidTokenException();
            }
        }
        catch (ResponseProcessingException e) {
            this.logger.error("Error processing the response: " + e.getMessage());
        }
        catch (ProcessingException e) {
            this.logger.error("General processing error: " + e.getMessage());
        }
        this.logger.debug("Got new valid access token using a code!");
        return this.accessToken;
    }

    public boolean checkTokenValidity(AbstractJwt token, boolean externalValidation) {
        if (!externalValidation) {
            return token.isValid();
        }
        Invocation.Builder builder = this.getTokenIntrospectionBuilder();
        builder.header("Authorization", (Object)this.getBasicAuthentication());
        Form form = new Form();
        form.param("token", token.getSerialized());
        JSONObject introspectionResult = (JSONObject)builder.post(Entity.form((Form)form), JSONObject.class);
        return (Boolean)introspectionResult.getOrDefault((Object)"active", (Object)false);
    }

    @Override
    public OAuth2Discovery getDiscovery() {
        return (OAuth2Discovery)this.getDiscoveryBuilder().get(OAuth2Discovery.class);
    }

    private WebTarget getUriPrefix() {
        return this.client.target(this.baseUrl).path(OAuth2ClientConfig.getEndpointPrefix((String)this.config.getRealm()));
    }

    @Override
    protected Invocation.Builder getAccessTokenBuilder() {
        return this.getUriPrefix().path("token").request(new String[]{"application/json"});
    }

    protected Invocation.Builder getTokenIntrospectionBuilder() {
        return this.client.target(this.baseUrl).path(OAuth2ClientConfig.getEndpointPrefix((String)this.config.getRealm())).path("token").path("introspect").request(new String[]{"application/json"});
    }

    private Invocation.Builder getRegisterBuilder() {
        return this.client.target(this.baseUrl).path("admin").path("realms").path(this.config.getRealm()).path("users").request(new String[]{"application/json"});
    }

    private Invocation.Builder getDiscoveryBuilder() {
        return this.client.target(this.baseUrl).path("realms").path(this.config.getRealm()).path(".well-known").path("openid-configuration").request(new String[]{"application/json"});
    }

    private Invocation.Builder getUserBuilder(String input) {
        return this.client.target(this.baseUrl).path("admin").path("realms").path(this.config.getRealm()).path("users").queryParam("search", new Object[]{input}).request(new String[]{"application/json"});
    }

    private Invocation.Builder getLocationsBuilder() {
        return this.getUriPrefix().path("???").request(new String[]{"application/json"});
    }

    @Override
    protected Invocation.Builder getClientBuilder() {
        return this.getUriPrefix().path("token").request(new String[]{"application/json"});
    }

    private String getBasicAuthentication() {
        String token = this.config.getClientId() + ":" + this.config.getClientSecret();
        try {
            return "BASIC " + DatatypeConverter.printBase64Binary((byte[])token.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException("Cannot encode with UTF-8", ex);
        }
    }
}

