/*
 * Decompiled with CFR 0.152.
 */
package de.samply.auth.client;

import de.samply.auth.rest.RegistrationRequestDto;
import de.samply.auth.rest.UserDto;
import de.samply.auth.rest.UserListDto;
import de.samply.auth.rest.Usertype;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.UserRepresentation;

public class AuthClientUtils {
    public static UserRepresentation samplyRegistrationToKeycloak(RegistrationRequestDto samplyUser, String password) {
        UserRepresentation keycloakUser = new UserRepresentation();
        keycloakUser.setEmail(samplyUser.getEmail());
        keycloakUser.setEmailVerified(Boolean.valueOf(true));
        keycloakUser.setUsername(samplyUser.getName());
        keycloakUser.setEnabled(Boolean.valueOf(true));
        HashMap<String, List<String>> attributes = new HashMap<String, List<String>>();
        attributes.put("usertype", Collections.singletonList(AuthClientUtils.samplyUserTypeToKeycloak(samplyUser.getUsertype())));
        attributes.put("description", Collections.singletonList(samplyUser.getDescription()));
        keycloakUser.setAttributes(attributes);
        CredentialRepresentation credentials = new CredentialRepresentation();
        credentials.setTemporary(Boolean.valueOf(false));
        credentials.setType("password");
        credentials.setValue(password);
        keycloakUser.setCredentials(Collections.singletonList(credentials));
        return keycloakUser;
    }

    public static UserDto keycloakUserToSamply(UserRepresentation keycloakUser) {
        UserDto samplyUser = new UserDto();
        samplyUser.setEmail(keycloakUser.getEmail());
        samplyUser.setEmailVerified(keycloakUser.isEmailVerified());
        samplyUser.setId(keycloakUser.getId());
        samplyUser.setName(keycloakUser.getFirstName() + " " + keycloakUser.getLastName());
        return samplyUser;
    }

    public static UserListDto keycloakUsersToSamply(UserRepresentation[] keycloakUsers) {
        UserListDto userList = new UserListDto();
        ArrayList<UserDto> samplyUsers = new ArrayList<UserDto>();
        for (UserRepresentation keycloakUser : keycloakUsers) {
            samplyUsers.add(AuthClientUtils.keycloakUserToSamply(keycloakUser));
        }
        userList.setUsers(samplyUsers);
        return userList;
    }

    public static String samplyUserTypeToKeycloak(Usertype usertype) {
        switch (usertype) {
            case OSSE_REGISTRY: {
                return "OSSE_REGISTRY";
            }
            case NORMAL: {
                return "NORMAL";
            }
            case BRIDGEHEAD: {
                return "BRIDGEHEAD";
            }
        }
        return null;
    }
}

