/*
 * Decompiled with CFR 0.152.
 */
package de.samply.auth.client;

import de.samply.auth.client.InvalidTokenException;
import de.samply.auth.client.RegistrationWrapper;
import de.samply.auth.client.jwt.JwtAccessToken;
import de.samply.auth.client.jwt.JwtException;
import de.samply.auth.client.jwt.JwtIdToken;
import de.samply.auth.client.jwt.JwtRefreshToken;
import de.samply.auth.rest.AccessTokenDto;
import de.samply.auth.rest.ClientListDto;
import de.samply.auth.rest.LocationDto;
import de.samply.auth.rest.OAuth2Discovery;
import de.samply.auth.rest.UserListDto;
import de.samply.common.config.OAuth2Client;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AuthClient {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String baseUrl;
    protected JwtAccessToken accessToken;
    protected JwtIdToken idToken;
    protected JwtRefreshToken refreshToken;
    protected OAuth2Client config;
    protected PublicKey publicKey;
    protected PrivateKey privateKey;
    protected String code;
    protected Client client;
    protected String state;
    protected String redirectUrl;
    protected String grantType;
    protected String username;
    protected String password;

    public AuthClient() {
    }

    public AuthClient(String baseUrl, JwtAccessToken accessToken, JwtIdToken idToken, JwtRefreshToken refreshToken, OAuth2Client config, PublicKey publicKey, PrivateKey privateKey, String code, Client client, String state, String redirectUrl, String grantType, String username, String password) {
        this.baseUrl = baseUrl;
        this.accessToken = accessToken;
        this.idToken = idToken;
        this.refreshToken = refreshToken;
        this.config = config;
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.code = code;
        this.client = client;
        this.state = state;
        this.redirectUrl = redirectUrl;
        this.grantType = grantType;
        this.username = username;
        this.password = password;
    }

    public JwtAccessToken getAccessToken() throws InvalidTokenException {
        try {
            if (this.accessToken == null || !this.accessToken.isValid()) {
                this.getNewAccessToken();
            }
            return this.accessToken;
        }
        catch (JwtException e) {
            this.logger.debug("This should never happen.");
            return null;
        }
    }

    public JwtIdToken getIdToken() throws InvalidTokenException {
        if (this.refreshToken == null) {
            return null;
        }
        try {
            if (this.idToken == null) {
                this.getNewAccessToken();
            }
            return this.idToken;
        }
        catch (JwtException e) {
            this.logger.debug("This should never happen.");
            return null;
        }
    }

    protected JwtAccessToken getRestAccessToken() {
        try {
            this.logger.debug("Requesting new access token, base URL: " + this.baseUrl);
            this.logger.debug("This is a client with an ID, a secret and a code.");
            Invocation.Builder builder = this.getAccessTokenBuilder();
            Form form = new Form();
            form.param("grant_type", "client_credentials");
            form.param("client_id", this.config.getClientId());
            form.param("client_secret", this.config.getClientSecret());
            AccessTokenDto tokenDto = (AccessTokenDto)builder.post(Entity.form((Form)form), AccessTokenDto.class);
            JwtAccessToken accessToken = new JwtAccessToken(this.publicKey, tokenDto.getAccessToken());
            if (!accessToken.isValid()) {
                this.logger.debug("The token we got was not valid. Throw an exception.");
                throw new InvalidTokenException();
            }
            this.logger.debug("Got new valid access token for rest user using a code!");
            return accessToken;
        }
        catch (InvalidTokenException | JwtException e) {
            this.logger.debug("Retrieving rest access token failed.");
            this.logger.debug(e.toString());
            return null;
        }
    }

    protected abstract JwtAccessToken getNewAccessToken() throws JwtException, InvalidTokenException;

    protected String getAuthorizationHeader() {
        if (this.accessToken != null) {
            return this.accessToken.getHeader();
        }
        return "Basic " + Base64.encodeBase64String((byte[])(this.config.getClientId() + ":" + this.config.getClientSecret()).getBytes());
    }

    public abstract UserListDto searchUser(String var1) throws InvalidTokenException;

    public abstract List<LocationDto> getLocations();

    public abstract Response register(RegistrationWrapper var1);

    protected abstract Invocation.Builder getClientBuilder();

    public ClientListDto getClients() {
        return (ClientListDto)this.getClientBuilder().get(ClientListDto.class);
    }

    protected abstract Invocation.Builder getAccessTokenBuilder();

    public abstract OAuth2Discovery getDiscovery();

    public static OAuth2Discovery getDiscovery(Client client, OAuth2Client config) {
        return (OAuth2Discovery)client.target(config.getHost()).path("realms").path(config.getRealm()).path(".well-known").path("openid-configuration").request(new String[]{"application/json"}).get(OAuth2Discovery.class);
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public OAuth2Client getConfig() {
        return this.config;
    }

    public void setConfig(OAuth2Client config) {
        this.config = config;
    }

    public JwtRefreshToken getRefreshToken() {
        return this.refreshToken;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

